local metadata = {
"## Interface:FS15 1.1.0.0 RC12",
"## Title: FoerderBandMoveBeltEvent",
"## Notes: Event für Bänder Animation",
"## Author: Marhu",
"## Version: 1.0.7",
"## Date: 11.02.2015",
"## Web: http://marhu.net"
}

FoerderBandMoveBeltEvent = {};
FoerderBandMoveBeltEvent_mt = Class(FoerderBandMoveBeltEvent, Event);

InitEventClass(FoerderBandMoveBeltEvent, "FoerderBandMoveBeltEvent");

function FoerderBandMoveBeltEvent:emptyNew()
    local self = Event:new(FoerderBandMoveBeltEvent_mt);
    return self;
end;
    
function FoerderBandMoveBeltEvent:new(object, move)
	local self = FoerderBandMoveBeltEvent:emptyNew()
	self.object = object;
	self.move = move;
	return self;
end;

function FoerderBandMoveBeltEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.move);
end;

function FoerderBandMoveBeltEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.move = streamReadBool(streamId);
		
	self:run(connection);
end;

function FoerderBandMoveBeltEvent:run(connection)
	if connection:getIsServer() then
		if self.object ~= nil then
			self.object.moveBelts = self.move;
		end;
	end;
end;

function FoerderBandMoveBeltEvent.sendEvent(vehicle, move, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(FoerderBandMoveBeltEvent:new(vehicle, move), nil, nil, vehicle);
		end;
	end;
end;