local metadata = {
"## Interface: FS15 1.3.0.1 1.3RC1",
"## Title: HiddeWarningInvalidFillType",
"## Notes: Specialization fr Anhnger, entfernt nicht vorhandene Filltypes aus der xml",
"## Author: Marhu",
"## Version: 0.1.0-9",
"## Date: 15.06.2015",
"## Web: http://Marhu.net"
}

HiddeWarningInvalidFillType = {};
function HiddeWarningInvalidFillType.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;
function HiddeWarningInvalidFillType:preLoad(xmlFile)
	if g_currentMission.hiddeHiddeWarningInvalidFillType ~= true then 
		local fillTypes = getXMLString(xmlFile, "vehicle.fillTypes#fillTypes");
		if fillTypes ~= nil then
			local diff, newTypesStr = false, "";
			local types = Utils.splitString(" ", fillTypes);
			for k,v in pairs(types) do
				local fillType = Fillable.fillTypeNameToInt[v];
				if fillType ~= nil then
					if newTypesStr ~= "" then v = " "..v; end;
					newTypesStr = newTypesStr..v;
				else
					diff = true;
				end;
			end;
			if diff == true then
				setXMLString(xmlFile, "vehicle.fillTypes#fillTypes",newTypesStr);
			end;
		end;
		local fruitTypes = getXMLString(xmlFile, "vehicle.fillTypes#fruitTypes");
		if fruitTypes ~= nil then
			local diff, newTypesStr = false, "";
			local types = Utils.splitString(" ", fruitTypes);
			for k,v in pairs(types) do
				local fillType = Fillable.fillTypeNameToInt[v];
				if fillType ~= nil then
					if newTypesStr ~= "" then v = " "..v; end;
					newTypesStr = newTypesStr..v;
				else
					diff = true;
				end;
			end;
			if diff == true then
				setXMLString(xmlFile, "vehicle.fillTypes#fruitTypes",newTypesStr);
			end
		end;
	end;
end
function HiddeWarningInvalidFillType:load(xmlFile)
end;
function HiddeWarningInvalidFillType:delete()
end;
function HiddeWarningInvalidFillType:mouseEvent(posX, posY, isDown, isUp, button)
end;
function HiddeWarningInvalidFillType:keyEvent(unicode, sym, modifier, isDown)
end;
function HiddeWarningInvalidFillType:update(dt)
end
function HiddeWarningInvalidFillType:draw()
end;