HideConsolle = {};

function HideConsolle.prerequisitesPresent(specializations)
    return true;
end;
function HideConsolle:load(xmlFile)

	self.setConsolles1Visibility = SpecializationUtil.callSpecializationsFunction("setConsolles1Visibility");

    self.Consolles1 = {};
        local i = 0;
        while true do
        local key = string.format("vehicle.Consolles1.Consolle1(%d)", i);
            if not hasXMLProperty(xmlFile, key) then
             break;
        end;
            local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
            if node ~= nil then
        setVisibility(node, true);
            table.insert(self.Consolles1, {node=node});
        end;
        i = i + 1;
        end;
    self.Consolles1Active = true;

    
end;
function HideConsolle:delete()
end;
function HideConsolle:readStream(streamId, connection)
	self.isLoading = true;
	local visibility = streamReadBool(streamId);
	self:setConsolles1Visibility(visibility, true);
	
end;

function HideConsolle:writeStream(streamId, connection)
	streamWriteBool(streamId, self.Consolles1Active);

end;
function HideConsolle:mouseEvent(posX, posY, isDown, isUp, button)
end;
function HideConsolle:keyEvent(unicode, sym, modifier, isDown)
end;
function HideConsolle:update(dt)

    if self:getIsActiveForInput() and self.isClient then
        if InputBinding.hasEvent(InputBinding.ConsolleHide) then
              self:setConsolles1Visibility(not self.Consolles1Active);
        end;
	end;
end;
function HideConsolle:onLeave()
end;
function HideConsolle:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("ConsolleHide"),  InputBinding.ConsolleHide);

end;
function HideConsolle:setConsolles1Visibility(visibility, noEventSend)
    if visibility ~= self.Consolles1Active then

        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(HideConsolleEvent:new(self, visibility), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(HideConsolleEvent:new(self, visibility));
            end;
        end;

        self.Consolles1Active = visibility;

        for _, Consolle1 in pairs(self.Consolles1) do
            setVisibility(Consolle1.node, visibility);
        end;
        for _,v in pairs(self.specializations) do
            if v.setConsolle1Visibility ~= nil then
                v.setConsolle1Visibility(self, visibility);
            end;
        end;
    end;
end;


-----------HIDE CONSOLLE FRONTLOADER-----------
HideConsolleEvent = {};
HideConsolleEvent_mt = Class(HideConsolleEvent, Event);
InitEventClass(HideConsolleEvent, "HideConsolleEvent");
function HideConsolleEvent:emptyNew()
      local self = Event:new(HideConsolleEvent_mt);
      self.className="HideConsolleEvent";
      return self;
end;
function HideConsolleEvent:new(object, active)
      local self = HideConsolleEvent:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;
function HideConsolleEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
function HideConsolleEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;
function HideConsolleEvent:run(connection)
      self.object:setConsolles1Visibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(HideConsolleEvent:new(self.object, self.active), nil, connection, self.object);
      end;
end;