
LuefterSound = {};

function LuefterSound.prerequisitesPresent(specializations)
    return true;
end;
function LuefterSound:load(xmlFile)
	  local fanSound = getXMLString(xmlFile, "vehicle.fanSound#file");
		if fanSound ~= nil and fanSound ~= "" then
			fanSound = Utils.getFilename(fanSound, self.baseDirectory);
			self.fanSound = createSample("fanSound");
			loadSample(self.fanSound, fanSound, false);
			self.fanSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fanSound#pitchOffset"), 1);
			self.fanSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fanSound#volume"), 1);
			setSamplePitch(self.fanSound, self.fanSoundPitchOffset);
			self.fanSoundTime = 0;
			self.fanSoundEnabled = false;
      end;
end;
function LuefterSound:delete()		 
	 if self.fanSound ~= nil then
          delete(self.fanSound);
	end;  
end;
function LuefterSound:readStream(streamId, connection)		
end;
function LuefterSound:writeStream(streamId, connection)	
end;
function LuefterSound:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
     return BaseMission.VEHICLE_LOAD_OK;
end;

function LuefterSound:mouseEvent(posX, posY, isDown, isUp, button)
end;
function LuefterSound:keyEvent(unicode, sym, modifier, isDown)			
end;

function LuefterSound:update(dt)	 
	if self.isMotorStarted then 
         if self:getIsActiveForSound() then 
            if self.fanSound ~= nil and not self.fanSoundEnabled and self.fanSoundTime <= self.time then
                  playSample(self.fanSound, 1, self.fanSoundVolume, 0);
                  self.fanSoundTime = self.time + 240000;
                  self.fanSoundEnabled = true;	
			end;
		end;
	end;
end;

function LuefterSound:updateTick(dt)
end;
function LuefterSound:draw() 	
end;

function LuefterSound:stopSounds()
	if self.isClient then
		 if self.fanSoundEnabled then
              stopSample(self.fanSound);
              self.fanSoundEnabled = false;
		 end;
	end;
end;

function LuefterSound:startMotor()
	self.fanSoundTime = self.time + 240000;
end;

function LuefterSound:stopMotor()
  LuefterSound.stopSounds(self);
end;
function LuefterSound:onEnter() 
end;

function LuefterSound:onLeave()
	LuefterSound.stopSounds(self);	        
end;

