--
-- Ploughing specialization
--
-- author: Burner
-- date: 24.05.2011
-- total rebuild date: 07.04.2012
--


PloughingSpec = {};

function PloughingSpec.prerequisitesPresent(specializations)
    return true;
end;

function PloughingSpec:load(xmlFile)
	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	
	self.workExhaustParticleSystems = {};
	local exhaustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.workExhaustParticleSystems#count"), 0);
	for i=1, exhaustParticleSystemCount do
		local namei = string.format("vehicle.workExhaustParticleSystems.workExhaustParticleSystem%d", i);
		Utils.loadParticleSystem(xmlFile, self.workExhaustParticleSystems, namei, self.components, false, nil, self.baseDirectory)
	end;
	
	-- front left wheel data --
	self.frontLeftWheel = {}
	self.frontLeftWheel.wheelIndex = getXMLInt(xmlFile, "vehicle.frontLeftWheel#wheelIndex");
	self.frontLeftWheel.jointIndex = getXMLInt(xmlFile, "vehicle.frontLeftWheel#componentJointIndex");
	self.frontLeftWheel.jointDefaultPosition = {}
	self.frontLeftWheel.jointDefaultPosition.x, self.frontLeftWheel.jointDefaultPosition.y, self.frontLeftWheel.jointDefaultPosition.z = getTranslation(self.componentJoints[self.frontLeftWheel.jointIndex].jointNode);
	self.frontLeftWheel.wheelDefaultPosition = {}
	self.frontLeftWheel.wheelDefaultPosition.x, self.frontLeftWheel.wheelDefaultPosition.y, self.frontLeftWheel.wheelDefaultPosition.z = getTranslation(self.wheels[self.frontLeftWheel.wheelIndex].repr);
	self.frontLeftWheel.furrowDepth = getXMLFloat(xmlFile, "vehicle.frontLeftWheel#furrowDepth");
	self.frontLeftWheel.minTrans = {};
	self.frontLeftWheel.minTrans[1] = self.frontLeftWheel.jointDefaultPosition.x;
	self.frontLeftWheel.minTrans[2] = self.frontLeftWheel.jointDefaultPosition.y;
	self.frontLeftWheel.minTrans[3] = self.frontLeftWheel.jointDefaultPosition.z;
	self.frontLeftWheel.maxTrans = {};
	self.frontLeftWheel.maxTrans[1] = self.frontLeftWheel.jointDefaultPosition.x
	self.frontLeftWheel.maxTrans[2] = self.frontLeftWheel.jointDefaultPosition.y - self.frontLeftWheel.furrowDepth;
	self.frontLeftWheel.maxTrans[3] = self.frontLeftWheel.jointDefaultPosition.z;
	self.frontLeftWheel.bounceTrans = {};
	self.frontLeftWheel.bounceTrans[1] = self.frontLeftWheel.jointDefaultPosition.x
	self.frontLeftWheel.bounceTrans[2] = self.frontLeftWheel.jointDefaultPosition.y - (self.frontLeftWheel.furrowDepth/4);
	self.frontLeftWheel.bounceTrans[3] = self.frontLeftWheel.jointDefaultPosition.z;
	self.frontLeftWheel.fallSpeed = Utils.getNoNil(getXMLString(xmlFile, "vehicle.frontLeftWheel#fallSpeed"), 0.4)*1000;
	self.frontLeftWheel.tireWidth = Utils.getNoNil(getXMLString(xmlFile, "vehicle.frontLeftWheel#tireWidth"), 0.4)/2;
	self.frontLeftWheel.areaOffset = (self.frontLeftWheel.tireWidth*2)+0.7;
	
	self.frontLeftWheel.innerNode = createTransformGroup("frontLeftInnerNode");
	link(self.wheels[self.frontLeftWheel.wheelIndex].node, self.frontLeftWheel.innerNode);
	setTranslation(self.frontLeftWheel.innerNode,self.frontLeftWheel.wheelDefaultPosition.x-self.frontLeftWheel.areaOffset, self.frontLeftWheel.wheelDefaultPosition.y, self.frontLeftWheel.wheelDefaultPosition.z);

	self.frontLeftWheel.outerNode = createTransformGroup("frontLeftOuterNode");
	link(self.wheels[self.frontLeftWheel.wheelIndex].node, self.frontLeftWheel.outerNode);
	setTranslation(self.frontLeftWheel.outerNode,self.frontLeftWheel.wheelDefaultPosition.x+self.frontLeftWheel.areaOffset, self.frontLeftWheel.wheelDefaultPosition.y, self.frontLeftWheel.wheelDefaultPosition.z);
	
	-- front right wheel data --
	self.frontRightWheel = {}
	self.frontRightWheel.wheelIndex = getXMLInt(xmlFile, "vehicle.frontRightWheel#wheelIndex");
	self.frontRightWheel.jointIndex = getXMLInt(xmlFile, "vehicle.frontRightWheel#componentJointIndex");
	self.frontRightWheel.jointDefaultPosition = {}
	self.frontRightWheel.jointDefaultPosition.x, self.frontRightWheel.jointDefaultPosition.y, self.frontRightWheel.jointDefaultPosition.z = getTranslation(self.componentJoints[self.frontRightWheel.jointIndex].jointNode);
	self.frontRightWheel.wheelDefaultPosition = {}
	self.frontRightWheel.wheelDefaultPosition.x, self.frontRightWheel.wheelDefaultPosition.y, self.frontRightWheel.wheelDefaultPosition.z = getTranslation(self.wheels[self.frontRightWheel.wheelIndex].repr);
	self.frontRightWheel.furrowDepth = getXMLFloat(xmlFile, "vehicle.frontRightWheel#furrowDepth");
	self.frontRightWheel.minTrans = {};
	self.frontRightWheel.minTrans[1] = self.frontRightWheel.jointDefaultPosition.x;
	self.frontRightWheel.minTrans[2] = self.frontRightWheel.jointDefaultPosition.y;
	self.frontRightWheel.minTrans[3] = self.frontRightWheel.jointDefaultPosition.z;
	self.frontRightWheel.maxTrans = {};
	self.frontRightWheel.maxTrans[1] = self.frontRightWheel.jointDefaultPosition.x
	self.frontRightWheel.maxTrans[2] = self.frontRightWheel.jointDefaultPosition.y - self.frontRightWheel.furrowDepth;
	self.frontRightWheel.maxTrans[3] = self.frontRightWheel.jointDefaultPosition.z;
	self.frontRightWheel.bounceTrans = {};
	self.frontRightWheel.bounceTrans[1] = self.frontRightWheel.jointDefaultPosition.x
	self.frontRightWheel.bounceTrans[2] = self.frontRightWheel.jointDefaultPosition.y - (self.frontRightWheel.furrowDepth/4);
	self.frontRightWheel.bounceTrans[3] = self.frontRightWheel.jointDefaultPosition.z;
	self.frontRightWheel.fallSpeed = Utils.getNoNil(getXMLString(xmlFile, "vehicle.frontRightWheel#fallSpeed"), 0.4)*1000;
	self.frontRightWheel.tireWidth = Utils.getNoNil(getXMLString(xmlFile, "vehicle.frontRightWheel#tireWidth"), 0.4)/2;
	self.frontRightWheel.areaOffset = (self.frontRightWheel.tireWidth*2)+0.7;
	
	self.frontRightWheel.innerNode = createTransformGroup("frontRightInnerNode");
	link(self.wheels[self.frontRightWheel.wheelIndex].node, self.frontRightWheel.innerNode);
	setTranslation(self.frontRightWheel.innerNode,self.frontRightWheel.wheelDefaultPosition.x-self.frontRightWheel.areaOffset, self.frontRightWheel.wheelDefaultPosition.y, self.frontRightWheel.wheelDefaultPosition.z);

	self.frontRightWheel.outerNode = createTransformGroup("frontRightOuterNode");
	link(self.wheels[self.frontRightWheel.wheelIndex].node, self.frontRightWheel.outerNode);
	setTranslation(self.frontRightWheel.outerNode,self.frontRightWheel.wheelDefaultPosition.x+self.frontRightWheel.areaOffset, self.frontRightWheel.wheelDefaultPosition.y, self.frontRightWheel.wheelDefaultPosition.z);
	
	-- back left wheel data --
	self.backLeftWheel = {}
	self.backLeftWheel.wheelIndex = getXMLInt(xmlFile, "vehicle.backLeftWheel#wheelIndex");
	self.backLeftWheel.jointIndex = getXMLInt(xmlFile, "vehicle.backLeftWheel#componentJointIndex");
	self.backLeftWheel.jointDefaultPosition = {}
	self.backLeftWheel.jointDefaultPosition.x, self.backLeftWheel.jointDefaultPosition.y, self.backLeftWheel.jointDefaultPosition.z = getTranslation(self.componentJoints[self.backLeftWheel.jointIndex].jointNode);
	self.backLeftWheel.wheelDefaultPosition = {}
	self.backLeftWheel.wheelDefaultPosition.x, self.backLeftWheel.wheelDefaultPosition.y, self.backLeftWheel.wheelDefaultPosition.z = getTranslation(self.wheels[self.backLeftWheel.wheelIndex].repr);
	self.backLeftWheel.furrowDepth = getXMLFloat(xmlFile, "vehicle.backLeftWheel#furrowDepth");
	self.backLeftWheel.minTrans = {};
	self.backLeftWheel.minTrans[1] = self.backLeftWheel.jointDefaultPosition.x;
	self.backLeftWheel.minTrans[2] = self.backLeftWheel.jointDefaultPosition.y;
	self.backLeftWheel.minTrans[3] = self.backLeftWheel.jointDefaultPosition.z;
	self.backLeftWheel.maxTrans = {};
	self.backLeftWheel.maxTrans[1] = self.backLeftWheel.jointDefaultPosition.x
	self.backLeftWheel.maxTrans[2] = self.backLeftWheel.jointDefaultPosition.y - self.backLeftWheel.furrowDepth;
	self.backLeftWheel.maxTrans[3] = self.backLeftWheel.jointDefaultPosition.z;
	self.backLeftWheel.bounceTrans = {};
	self.backLeftWheel.bounceTrans[1] = self.backLeftWheel.jointDefaultPosition.x
	self.backLeftWheel.bounceTrans[2] = self.backLeftWheel.jointDefaultPosition.y - (self.backLeftWheel.furrowDepth/4);
	self.backLeftWheel.bounceTrans[3] = self.backLeftWheel.jointDefaultPosition.z;
	self.backLeftWheel.fallSpeed = Utils.getNoNil(getXMLString(xmlFile, "vehicle.backLeftWheel#fallSpeed"), 0.4)*1000;
	self.backLeftWheel.tireWidth = Utils.getNoNil(getXMLString(xmlFile, "vehicle.backLeftWheel#tireWidth"), 0.4)/2;
	self.backLeftWheel.areaOffset = (self.backLeftWheel.tireWidth*2)+0.7;
	
	self.backLeftWheel.innerNode = createTransformGroup("backLeftInnerNode");
	link(self.wheels[self.backLeftWheel.wheelIndex].node, self.backLeftWheel.innerNode);
	setTranslation(self.backLeftWheel.innerNode,self.backLeftWheel.wheelDefaultPosition.x-self.backLeftWheel.areaOffset, self.backLeftWheel.wheelDefaultPosition.y, self.backLeftWheel.wheelDefaultPosition.z);

	self.backLeftWheel.outerNode = createTransformGroup("backLeftOuterNode");
	link(self.wheels[self.backLeftWheel.wheelIndex].node, self.backLeftWheel.outerNode);
	setTranslation(self.backLeftWheel.outerNode,self.backLeftWheel.wheelDefaultPosition.x+self.backLeftWheel.areaOffset, self.backLeftWheel.wheelDefaultPosition.y, self.backLeftWheel.wheelDefaultPosition.z);
	
	-- back right wheel data --
	self.backRightWheel = {}
	self.backRightWheel.wheelIndex = getXMLInt(xmlFile, "vehicle.backRightWheel#wheelIndex");
	self.backRightWheel.jointIndex = getXMLInt(xmlFile, "vehicle.backRightWheel#componentJointIndex");
	self.backRightWheel.jointDefaultPosition = {}
	self.backRightWheel.jointDefaultPosition.x, self.backRightWheel.jointDefaultPosition.y, self.backRightWheel.jointDefaultPosition.z = getTranslation(self.componentJoints[self.backRightWheel.jointIndex].jointNode);
	self.backRightWheel.wheelDefaultPosition = {}
	self.backRightWheel.wheelDefaultPosition.x, self.backRightWheel.wheelDefaultPosition.y, self.backRightWheel.wheelDefaultPosition.z = getTranslation(self.wheels[self.backRightWheel.wheelIndex].repr);
	self.backRightWheel.furrowDepth = getXMLFloat(xmlFile, "vehicle.backRightWheel#furrowDepth");
	self.backRightWheel.minTrans = {};
	self.backRightWheel.minTrans[1] = self.backRightWheel.jointDefaultPosition.x;
	self.backRightWheel.minTrans[2] = self.backRightWheel.jointDefaultPosition.y;
	self.backRightWheel.minTrans[3] = self.backRightWheel.jointDefaultPosition.z;
	self.backRightWheel.maxTrans = {};
	self.backRightWheel.maxTrans[1] = self.backRightWheel.jointDefaultPosition.x
	self.backRightWheel.maxTrans[2] = self.backRightWheel.jointDefaultPosition.y - self.backRightWheel.furrowDepth;
	self.backRightWheel.maxTrans[3] = self.backRightWheel.jointDefaultPosition.z;
	self.backRightWheel.bounceTrans = {};
	self.backRightWheel.bounceTrans[1] = self.backRightWheel.jointDefaultPosition.x
	self.backRightWheel.bounceTrans[2] = self.backRightWheel.jointDefaultPosition.y - (self.backRightWheel.furrowDepth/4);
	self.backRightWheel.bounceTrans[3] = self.backRightWheel.jointDefaultPosition.z;
	self.backRightWheel.fallSpeed = Utils.getNoNil(getXMLString(xmlFile, "vehicle.backRightWheel#fallSpeed"), 0.4)*1000;
	self.backRightWheel.tireWidth = Utils.getNoNil(getXMLString(xmlFile, "vehicle.backRightWheel#tireWidth"), 0.4)/2;
	self.backRightWheel.areaOffset = (self.backRightWheel.tireWidth*2)+0.7;

	self.backRightWheel.innerNode = createTransformGroup("backRightInnerNode");
	link(self.wheels[self.backRightWheel.wheelIndex].node, self.backRightWheel.innerNode);
	setTranslation(self.backRightWheel.innerNode,self.backRightWheel.wheelDefaultPosition.x-self.backRightWheel.areaOffset, self.backRightWheel.wheelDefaultPosition.y, self.backRightWheel.wheelDefaultPosition.z);

	self.backRightWheel.outerNode = createTransformGroup("backRightOuterNode");
	link(self.wheels[self.backRightWheel.wheelIndex].node, self.backRightWheel.outerNode);
	setTranslation(self.backRightWheel.outerNode,self.backRightWheel.wheelDefaultPosition.x+self.backRightWheel.areaOffset, self.backRightWheel.wheelDefaultPosition.y, self.backRightWheel.wheelDefaultPosition.z);
	
	self.bounceTimeLeft = 500;
	self.bounceTimeRight = 300;
	self.bounceTimeLeft2 = 200;
	self.bounceTimeRight2 = 400;
	
	self.bounceLeft = false;
	self.bounceRight = false;
	self.bounceLeft2 = false;
	self.bounceRight2 = false;
	
	self.densFrontLeftActive = false;
	self.densFrontRightActive = false;
	self.densBackLeftActive = false;
	self.densBackRightActive = false;
	
	self.fistTimeRunning = true;
	self.increaseRpmDuringPloughing = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.increaseRpmDuringPloughing#value"), true);
end;

function PloughingSpec:delete()
	Utils.deleteParticleSystem(self.workExhaustParticleSystems);
end;

function PloughingSpec:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PloughingSpec:keyEvent(unicode, sym, modifier, isDown)
end;

function PloughingSpec:update(dt)
	if self.fistTimeRunning and self.motor ~= nil then
		self.saveMinRpm = self.motor.minRpm;
		self.fistTimeRunning = false;
	end;
	local densFrontLeft = 0;
	local densFrontRight = 0;
	local densBackLeft = 0;
	local densBackRight = 0;
	
	--[[
	local densFrontLeftInner = 0;
	local densFrontLeftOuter = 0;
	local densFrontRightInner = 0;
	local densFrontRightOuter = 0;
	local densBackLeftInner = 0;
	local densBackLeftOuter = 0;
	local densBackRightInner = 0;
	local densBackRightOuter = 0;
	]]

	-- looking for plough channel under front left wheel --
	local x,y,z = getWorldTranslation(self.wheels[self.frontLeftWheel.wheelIndex].driveNode);
	densFrontLeft = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.ploughChannel, x+self.frontLeftWheel.tireWidth, z+self.frontLeftWheel.tireWidth, x-self.frontLeftWheel.tireWidth, z+self.frontLeftWheel.tireWidth, x+self.frontLeftWheel.tireWidth, z-self.frontLeftWheel.tireWidth);
	
	--[[
	local x,y,z = getWorldTranslation(self.frontLeftWheel.innerNode);
	densFrontLeftInner = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.ploughChannel, x+self.frontLeftWheel.tireWidth, z+self.frontLeftWheel.tireWidth, x-self.frontLeftWheel.tireWidth, z+self.frontLeftWheel.tireWidth, x+self.frontLeftWheel.tireWidth, z-self.frontLeftWheel.tireWidth);
	local x,y,z = getWorldTranslation(self.frontLeftWheel.outerNode);
	densFrontLeftOuter = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.ploughChannel, x+self.frontLeftWheel.tireWidth, z+self.frontLeftWheel.tireWidth, x-self.frontLeftWheel.tireWidth, z+self.frontLeftWheel.tireWidth, x+self.frontLeftWheel.tireWidth, z-self.frontLeftWheel.tireWidth);
	]]
	
	-- looking for plough channel under front right wheel --
	local x,y,z = getWorldTranslation(self.wheels[self.frontRightWheel.wheelIndex].driveNode);
	densFrontRight = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.ploughChannel, x+self.frontRightWheel.tireWidth, z+self.frontRightWheel.tireWidth, x-self.frontRightWheel.tireWidth, z+self.frontRightWheel.tireWidth, x+self.frontRightWheel.tireWidth, z-self.frontRightWheel.tireWidth);

	--[[
	local x,y,z = getWorldTranslation(self.frontRightWheel.innerNode);
	densFrontRightInner = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.ploughChannel, x+self.frontRightWheel.tireWidth, z+self.frontRightWheel.tireWidth, x-self.frontRightWheel.tireWidth, z+self.frontRightWheel.tireWidth, x+self.frontRightWheel.tireWidth, z-self.frontRightWheel.tireWidth);
	local x,y,z = getWorldTranslation(self.frontRightWheel.outerNode);
	densFrontRightOuter = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.ploughChannel, x+self.frontRightWheel.tireWidth, z+self.frontRightWheel.tireWidth, x-self.frontRightWheel.tireWidth, z+self.frontRightWheel.tireWidth, x+self.frontRightWheel.tireWidth, z-self.frontRightWheel.tireWidth);
	]]
	
	-- looking for plough channel under back left wheel --
	local x,y,z = getWorldTranslation(self.wheels[self.backLeftWheel.wheelIndex].driveNode);
	densBackLeft = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.ploughChannel, x+self.backLeftWheel.tireWidth, z+self.backLeftWheel.tireWidth, x-self.backLeftWheel.tireWidth, z+self.backLeftWheel.tireWidth, x+self.backLeftWheel.tireWidth, z-self.backLeftWheel.tireWidth);

	--[[
	local x,y,z = getWorldTranslation(self.backLeftWheel.innerNode);
	densBackLeftInner = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.ploughChannel, x+self.backLeftWheel.tireWidth, z+self.backLeftWheel.tireWidth, x-self.backLeftWheel.tireWidth, z+self.backLeftWheel.tireWidth, x+self.backLeftWheel.tireWidth, z-self.backLeftWheel.tireWidth);
	local x,y,z = getWorldTranslation(self.backLeftWheel.outerNode);
	densBackLeftOuter = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.ploughChannel, x+self.backLeftWheel.tireWidth, z+self.backLeftWheel.tireWidth, x-self.backLeftWheel.tireWidth, z+self.backLeftWheel.tireWidth, x+self.backLeftWheel.tireWidth, z-self.backLeftWheel.tireWidth);
	]]
	
	-- looking for plough channel under back right wheel --
	local x,y,z = getWorldTranslation(self.wheels[self.backRightWheel.wheelIndex].driveNode);
	densBackRight = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.ploughChannel, x+self.backRightWheel.tireWidth, z+self.backRightWheel.tireWidth, x-self.backRightWheel.tireWidth, z+self.backRightWheel.tireWidth, x+self.backRightWheel.tireWidth, z-self.backRightWheel.tireWidth);
	
	--[[
	local x,y,z = getWorldTranslation(self.backRightWheel.innerNode);
	densBackRightInner = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.ploughChannel, x+self.backRightWheel.tireWidth, z+self.backRightWheel.tireWidth, x-self.backRightWheel.tireWidth, z+self.backRightWheel.tireWidth, x+self.backRightWheel.tireWidth, z-self.backRightWheel.tireWidth);
	local x,y,z = getWorldTranslation(self.backRightWheel.outerNode);
	densBackRightOuter = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.ploughChannel, x+self.backRightWheel.tireWidth, z+self.backRightWheel.tireWidth, x-self.backRightWheel.tireWidth, z+self.backRightWheel.tireWidth, x+self.backRightWheel.tireWidth, z-self.backRightWheel.tireWidth);
	]]
	
	self.densFrontLeftActive = densFrontLeft > 0 --and (densFrontLeftInner < 2 or densFrontLeftOuter < 2);
	self.densFrontRightActive = densFrontRight > 0 --and (densFrontRightInner < 2 or densFrontRightOuter < 2);
	self.densBackLeftActive = densBackLeft > 0 --and (densBackLeftInner < 2 or densBackLeftOuter < 2);
	self.densBackRightActive = densBackRight > 0 --and (densBackRightInner < 2 or densBackRightOuter < 2);
	
	self.hasPloughAttached = false;
		
	for i=1, table.getn(self.attachedImplements) do
		if SpecializationUtil.hasSpecialization(Plough, self.attachedImplements[i].object.specializations) or self.attachedImplements[i].object.ploughSound ~= nil or (self.attachedImplements[i].object.cultivatorSound == nil and self.attachedImplements[i].object.mowerSound == nil and self.attachedImplements[i].object.tedderSound == nil and self.attachedImplements[i].object.windrowerSound == nil and self.attachedImplements[i].object.sowingSound == nil and self.attachedImplements[i].object.spraySound == nil) then
			if self.attachedImplements[i].object:isLowered(false) then
				self.hasPloughAttached = true;
			end;
		end;
	end;
		
	if self.hasPloughAttached and self.lastSpeed*3600 > 5 then
		if self.increaseRpmDuringPloughing then
			self:setVehicleRpmUp(dt, true);
		end;
		Utils.setEmittingState(self.workExhaustParticleSystems, true);
	else
		if self.increaseRpmDuringPloughing then
			self:setVehicleRpmUp(dt, false);
		end;
		Utils.setEmittingState(self.workExhaustParticleSystems, false)
	end;
	
	-- bouncing when driving on plowed terrain --
	if densFrontLeft > 0 and densFrontRight > 0 and densBackLeft > 0 and densBackRight > 0 then
		if self.lastSpeed*3600 > 5 then
			self.bounceSpeeds = {300,400,500,600,700}
			rand = math.random(1,5);
			self.bounceSpeed = self.bounceSpeeds[rand];
			
			self.bounceTimeLeft = self.bounceTimeLeft - dt;
			if self.bounceTimeLeft < 0 then
				self.bounceLeft = not self.bounceLeft;
				self.bounceTimeLeft = 500;
			end;
			
			self.bounceTimeRight = self.bounceTimeRight - dt;
			if self.bounceTimeRight < 0 then
				self.bounceRight = not self.bounceRight;
				self.bounceTimeRight = 300;
			end;
			
			self.bounceTimeLeft2 = self.bounceTimeLeft2 - dt;
			if self.bounceTimeLeft2 < 0 then
				self.bounceLeft2 = not self.bounceLeft2;
				self.bounceTimeLeft2 = 200;
			end;
			
			self.bounceTimeRight2 = self.bounceTimeRight2 - dt;
			if self.bounceTimeRight2 < 0 then
				self.bounceRight2 = not self.bounceRight2;
				self.bounceTimeRight2 = 400;
			end;
		else
			self.bounceLeft = false;
			self.bounceRight = false;
			self.bounceLeft2 = false;
			self.bounceRight2 = false;	
		end;
		
		-- move front left wheel joint index --
		if self.componentJoints[self.frontLeftWheel.jointIndex].jointNode ~= nil and self.wheels[self.frontLeftWheel.wheelIndex].repr ~= nil then
			local x, y, z = getTranslation(self.componentJoints[self.frontLeftWheel.jointIndex].jointNode);
			local trans = {x,y,z};
			if y < self.frontLeftWheel.bounceTrans[2] then
				newTrans = Utils.getMovedLimitedValues(trans, self.frontLeftWheel.maxTrans, self.frontLeftWheel.bounceTrans, 3, self.frontLeftWheel.fallSpeed, dt, true);
			else
				newTrans = Utils.getMovedLimitedValues(trans, self.frontLeftWheel.bounceTrans, self.frontLeftWheel.minTrans, 3, self.frontLeftWheel.fallSpeed, dt, not self.bounceLeft);
			end;
			setTranslation(self.componentJoints[self.frontLeftWheel.jointIndex].jointNode, unpack(newTrans));
			
			-- update front left wheel repr position --
			local positionDiff = self.frontLeftWheel.jointDefaultPosition.y + y;
			setTranslation(self.wheels[self.frontLeftWheel.wheelIndex].repr, 0, self.frontLeftWheel.wheelDefaultPosition.y + positionDiff, 0);
		end;
		
		-- move front right wheel joint index --
		if self.componentJoints[self.frontRightWheel.jointIndex].jointNode ~= nil and self.wheels[self.frontRightWheel.wheelIndex].repr ~= nil then
			local x, y, z = getTranslation(self.componentJoints[self.frontRightWheel.jointIndex].jointNode);
			local trans = {x,y,z};
			if y < self.frontRightWheel.bounceTrans[2] then
				newTrans = Utils.getMovedLimitedValues(trans, self.frontRightWheel.maxTrans, self.frontRightWheel.bounceTrans, 3, self.frontRightWheel.fallSpeed, dt, true);
			else
				newTrans = Utils.getMovedLimitedValues(trans, self.frontRightWheel.bounceTrans, self.frontRightWheel.minTrans, 3, self.frontRightWheel.fallSpeed, dt, not self.bounceRight);
			end;
			setTranslation(self.componentJoints[self.frontRightWheel.jointIndex].jointNode, unpack(newTrans));
			
			-- update front right wheel repr position --
			local positionDiff = self.frontRightWheel.jointDefaultPosition.y + y;
			setTranslation(self.wheels[self.frontRightWheel.wheelIndex].repr, 0, self.frontRightWheel.wheelDefaultPosition.y + positionDiff, 0);
		end;
		
		-- move back left wheel joint index --
		if self.componentJoints[self.backLeftWheel.jointIndex].jointNode ~= nil and self.wheels[self.backLeftWheel.wheelIndex].repr ~= nil then
			local x, y, z = getTranslation(self.componentJoints[self.backLeftWheel.jointIndex].jointNode);
			local trans = {x,y,z};
			if y < self.backLeftWheel.bounceTrans[2] then
				newTrans = Utils.getMovedLimitedValues(trans, self.backLeftWheel.maxTrans, self.backLeftWheel.bounceTrans, 3, self.backLeftWheel.fallSpeed, dt, true);
			else
				newTrans = Utils.getMovedLimitedValues(trans, self.backLeftWheel.bounceTrans, self.backLeftWheel.minTrans, 3, self.backLeftWheel.fallSpeed, dt, not self.bounceLeft2);
			end;
			setTranslation(self.componentJoints[self.backLeftWheel.jointIndex].jointNode, unpack(newTrans));
			
			-- update back left wheel repr position --
			local positionDiff = self.backLeftWheel.jointDefaultPosition.y + y;
			setTranslation(self.wheels[self.backLeftWheel.wheelIndex].repr, 0, self.backLeftWheel.wheelDefaultPosition.y + positionDiff, 0);
		end;
		
		-- move back right wheel joint index --
		if self.componentJoints[self.backLeftWheel.jointIndex].jointNode ~= nil and self.wheels[self.backLeftWheel.wheelIndex].repr ~= nil then
			local x, y, z = getTranslation(self.componentJoints[self.backRightWheel.jointIndex].jointNode);
			local trans = {x,y,z};
			if y < self.backRightWheel.bounceTrans[2] then
				newTrans = Utils.getMovedLimitedValues(trans, self.backRightWheel.maxTrans, self.backRightWheel.bounceTrans, 3, self.backRightWheel.fallSpeed, dt, true);
			else
				newTrans = Utils.getMovedLimitedValues(trans, self.backRightWheel.bounceTrans, self.backRightWheel.minTrans, 3, self.backRightWheel.fallSpeed, dt, not self.bounceRight2);
			end;
			setTranslation(self.componentJoints[self.backRightWheel.jointIndex].jointNode, unpack(newTrans));
			
			-- update back left wheel repr position --
			local positionDiff = self.backRightWheel.jointDefaultPosition.y + y;
			setTranslation(self.wheels[self.backRightWheel.wheelIndex].repr, 0, self.backRightWheel.wheelDefaultPosition.y + positionDiff, 0);
		end;
	else
		-- move front left wheel joint index --
		if self.componentJoints[self.frontLeftWheel.jointIndex].jointNode ~= nil and self.wheels[self.frontLeftWheel.wheelIndex].repr ~= nil then
			local x, y, z = getTranslation(self.componentJoints[self.frontLeftWheel.jointIndex].jointNode);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.frontLeftWheel.maxTrans, self.frontLeftWheel.minTrans, 3, self.frontLeftWheel.fallSpeed, dt, not self.densFrontLeftActive);
			setTranslation(self.componentJoints[self.frontLeftWheel.jointIndex].jointNode, unpack(newTrans));
			
			-- update front left wheel repr position --
			if math.floor(y*100) ~= math.floor(self.frontLeftWheel.jointDefaultPosition.y*100) then
				local positionDiff = self.frontLeftWheel.jointDefaultPosition.y + y;
				setTranslation(self.wheels[self.frontLeftWheel.wheelIndex].repr, 0, self.frontLeftWheel.wheelDefaultPosition.y + positionDiff, 0);
			end;
		end;

		-- move front right wheel joint index --
		if self.componentJoints[self.frontRightWheel.jointIndex].jointNode ~= nil and self.wheels[self.frontRightWheel.wheelIndex].repr ~= nil then
			local x, y, z = getTranslation(self.componentJoints[self.frontRightWheel.jointIndex].jointNode);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.frontRightWheel.maxTrans, self.frontRightWheel.minTrans, 3, self.frontRightWheel.fallSpeed, dt, not self.densFrontRightActive);
			setTranslation(self.componentJoints[self.frontRightWheel.jointIndex].jointNode, unpack(newTrans));
			
			-- update front right wheel repr position --
			if math.floor(y*100) ~= math.floor(self.frontRightWheel.jointDefaultPosition.y*100) then
				local positionDiff = self.frontRightWheel.jointDefaultPosition.y + y;
				setTranslation(self.wheels[self.frontRightWheel.wheelIndex].repr, 0, self.frontRightWheel.wheelDefaultPosition.y + positionDiff, 0);
			end;
		end;
		
		-- move back left wheel joint index --
		if self.componentJoints[self.backLeftWheel.jointIndex].jointNode ~= nil and self.wheels[self.backLeftWheel.wheelIndex].repr ~= nil then
			local x, y, z = getTranslation(self.componentJoints[self.backLeftWheel.jointIndex].jointNode);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.backLeftWheel.maxTrans, self.backLeftWheel.minTrans, 3, self.backLeftWheel.fallSpeed, dt, not self.densBackLeftActive);
			setTranslation(self.componentJoints[self.backLeftWheel.jointIndex].jointNode, unpack(newTrans));
			
			-- update back left wheel repr position --
			if math.floor(y*100) ~= math.floor(self.backLeftWheel.jointDefaultPosition.y*100) then
				local positionDiff = self.backLeftWheel.jointDefaultPosition.y + y;
				setTranslation(self.wheels[self.backLeftWheel.wheelIndex].repr, 0, self.backLeftWheel.wheelDefaultPosition.y + positionDiff, 0);
			end;
		end;
		
		-- move back right wheel joint index --
		if self.componentJoints[self.backRightWheel.jointIndex].jointNode ~= nil and self.wheels[self.backRightWheel.wheelIndex].repr ~= nil then
			local x, y, z = getTranslation(self.componentJoints[self.backRightWheel.jointIndex].jointNode);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.backRightWheel.maxTrans, self.backRightWheel.minTrans, 3, self.backRightWheel.fallSpeed, dt, not self.densBackRightActive);
			setTranslation(self.componentJoints[self.backRightWheel.jointIndex].jointNode, unpack(newTrans));
			
			-- update back left wheel repr position --
			if math.floor(y*100) ~= math.floor(self.backRightWheel.jointDefaultPosition.y*100) then
				local positionDiff = self.backRightWheel.jointDefaultPosition.y + y;
				setTranslation(self.wheels[self.backRightWheel.wheelIndex].repr, 0, self.backRightWheel.wheelDefaultPosition.y + positionDiff, 0);
			end;
		end;
	end;
	
	-- update wheel component joints after moving joint indexes --
	if self.componentJoints[self.frontLeftWheel.jointIndex].jointIndex ~= nil then
		setJointFrame(self.componentJoints[self.frontLeftWheel.jointIndex].jointIndex, 1 ,self.componentJoints[self.frontLeftWheel.jointIndex].jointNode);
	end;
	if self.componentJoints[self.frontRightWheel.jointIndex].jointIndex ~= nil then
		setJointFrame(self.componentJoints[self.frontRightWheel.jointIndex].jointIndex, 1 ,self.componentJoints[self.frontRightWheel.jointIndex].jointNode);
	end;
	if self.componentJoints[self.backLeftWheel.jointIndex].jointIndex ~= nil then
		setJointFrame(self.componentJoints[self.backLeftWheel.jointIndex].jointIndex, 1 ,self.componentJoints[self.backLeftWheel.jointIndex].jointNode);
	end;
	if self.componentJoints[self.backRightWheel.jointIndex].jointIndex ~= nil then
		setJointFrame(self.componentJoints[self.backRightWheel.jointIndex].jointIndex, 1 ,self.componentJoints[self.backRightWheel.jointIndex].jointNode);
	end;
end;

function PloughingSpec:draw()
end;

function PloughingSpec:setVehicleRpmUp(dt, isActive)
	if self.saveMinRpm ~= 0 and self.motor ~= nil then
		if dt ~= nil then
			if isActive == true then
				self.motor.minRpm = math.max(self.motor.minRpm-(dt/2), -1500);
			else
				self.motor.minRpm = math.min(self.motor.minRpm+(dt*2), self.saveMinRpm);
			end;
		else
			self.motor.minRpm = self.saveMinRpm;
		end;
		if self.isMotorStarted and not self.isFuelFilling then
			local fuelUsed = 0.0000011*math.abs(self.motor.minRpm);
			self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);
		end;
	end;
end;

function PloughingSpec:onDeactivate()
	if self.increaseRpmDuringPloughing then
		self:setVehicleRpmUp(nil, false);
	end;
end;