-- SoundSwitcher
--
-- Author RivalBomb

SoundSwitcher = {};
function SoundSwitcher.prerequisitesPresent(specializations)
    return true;
end;

function SoundSwitcher:load(xmlFile)
	local volumeCurveRun = AnimCurve:new(linearInterpolator1);
	local volumeCurveRun2 = AnimCurve:new(linearInterpolator1);
	local pitchCurveRun = AnimCurve:new(linearInterpolator1);
	local pitchCurveRun2 = AnimCurve:new(linearInterpolator1);
	
    local i = 0;
    while true do
        local key = string.format("vehicle.soundSwitcher.motorRunSound.volume(%d)", i);
        local volume = getXMLFloat(xmlFile, key.."#value");
        local rpm = getXMLFloat(xmlFile, key.."#rpm");
        if rpm == nil or volume == nil then
            break;
        end;
        volumeCurveRun:addKeyframe({v=volume, time = rpm});
        i = i +1;
	end;
	self.volumeCurveRun = volumeCurveRun;
	
    local j = 0;
    while true do
        local key = string.format("vehicle.soundSwitcher.motorRunSound2.volume(%d)", j);
        local volume = getXMLFloat(xmlFile, key.."#value");
        local rpm = getXMLFloat(xmlFile, key.."#rpm");
        if rpm == nil or volume == nil then
            break;
        end;
        volumeCurveRun2:addKeyframe({v=volume, time = rpm});
        j = j +1;
	end;
	self.volumeCurveRun2 = volumeCurveRun2;
	
    local k = 0;
    while true do
        local key = string.format("vehicle.soundSwitcher.motorRunSound.pitch(%d)", k);
        local volume = getXMLFloat(xmlFile, key.."#value");
        local rpm = getXMLFloat(xmlFile, key.."#rpm");
        if rpm == nil or volume == nil then
            break;
        end;
        pitchCurveRun:addKeyframe({v=volume, time = rpm});
        k = k +1;
	end;
	self.pitchCurveRun = pitchCurveRun;
	
    local l = 0;
    while true do
        local key = string.format("vehicle.soundSwitcher.motorRunSound2.pitch(%d)", l);
        local volume = getXMLFloat(xmlFile, key.."#value");
        local rpm = getXMLFloat(xmlFile, key.."#rpm");
        if rpm == nil or volume == nil then
            break;
        end;
        pitchCurveRun2:addKeyframe({v=volume, time = rpm});
        l = l +1;
	end;
	self.pitchCurveRun2 = pitchCurveRun2;
	
	self.runSound2playing = false;
	self.motorRunSound2 = Utils.loadSample(xmlFile, {}, "vehicle.soundSwitcher.motorRunSound2", nil, self.baseDirectory, self.components[1].node);
end;
function SoundSwitcher:delete()
	Utils.deleteSample(self.motorRunSound2);
end;

function SoundSwitcher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SoundSwitcher:keyEvent(unicode, sym, modifier, isDown)
end;

function SoundSwitcher:update(dt)
	if self:getIsActiveForSound() then
		if self.runSound2playing == false then
			Utils.playSample(self.motorRunSound2,0,0,0);
			self.runSound2playing = true;
		end;
		local accInput = 0;
        if self.axisForward ~= nil then
            accInput = -self.axisForward;
		end;
		if self.cruiseControl ~= nil and self.cruiseControl.state ~= Drivable.CRUISECONTROL_STATE_OFF then
            accInput = 1;
		end;
		local rpmRunVolume = 1; 
		if math.abs(accInput) < 0.01 then
			rpmRunVolume = 0.6666;
		else
			rpmRunVolume = 1;
		end;
		Utils.setSampleVolume(self.sampleMotorRun, self.volumeCurveRun:get(Utils.clamp(self.motor.lastMotorRpm, self.motor.minRpm, self.motor.maxRpm))*rpmRunVolume);
		Utils.setSampleVolume(self.motorRunSound2, self.volumeCurveRun2:get(Utils.clamp(self.motor.lastMotorRpm, self.motor.minRpm, self.motor.maxRpm))*rpmRunVolume);
		Utils.setSamplePitch(self.sampleMotorRun, self.pitchCurveRun:get(Utils.clamp(self.motor.lastMotorRpm, self.motor.minRpm, self.motor.maxRpm)));
		Utils.setSamplePitch(self.motorRunSound2, self.pitchCurveRun2:get(Utils.clamp(self.motor.lastMotorRpm, self.motor.minRpm, self.motor.maxRpm)));
	end;
end;

function SoundSwitcher:updateTick(dt)
end;

function SoundSwitcher:draw()
end;