
-- caseIH260
-- Specialization for caseIH260 mod
-- Date 17/03/2015
-- Copyright (C) fozzy691
-- Contact via PM @ romuald.brun691@orange.fr


caseIH260 = {};

function caseIH260.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function caseIH260:load(xmlFile)
	self.frontLinkageBottomArmRotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLinkageBottomArm#rotationNode"));
	setRotation(self.frontLinkageBottomArmRotNode, math.rad(-40), math.rad(0), math.rad(0)); 
end;

function caseIH260:delete()
end;

function caseIH260:readStream(streamId, connection)
end;

function caseIH260:writeStream(streamId, connection)
end;

function caseIH260:mouseEvent(posX, posY, isDown, isUp, button)
end;

function caseIH260:keyEvent(unicode, sym, modifier, isDown)
end;

function caseIH260:update(dt)
end;

function caseIH260:updateTick(dt)
end;

function caseIH260:draw()
end;

function caseIH260:onLeave()
end;

function caseIH260:onEnter()
end;

function caseIH260:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;

	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = math.max(self.implementCount - 1, 0);
		end;
		if jointIndex == 2 then
			setRotation(self.frontLinkageBottomArmRotNode, math.rad(0), math.rad(0), math.rad(0)); 
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 3 then
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 4 then
		end;
	end;

	self.updateJoint = true;
end;

function caseIH260:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;

	if implement.object.attacherJoint.jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = self.implementCount + 1;
		end;
		if jointIndex == 2 then
			setRotation(self.frontLinkageBottomArmRotNode, math.rad(-40), math.rad(0), math.rad(0)); 
		end;
	else
	end;
	
	self.updateJoint = true;
end;

function caseIH260:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;
