--
-- Ploughing specialization
--
-- author: Burner
-- date: 24.05.2011
-- total rebuild date: 07.04.2012
--


PloughingSpec = {};

function PloughingSpec.prerequisitesPresent(specializations)
    return true;
end;

function PloughingSpec:load(xmlFile)
	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	
	self.workExhaustParticleSystems = {};
	local exhaustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.workExhaustParticleSystems#count"), 0);
	for i=1, exhaustParticleSystemCount do
		local namei = string.format("vehicle.workExhaustParticleSystems.workExhaustParticleSystem%d", i);
		Utils.loadParticleSystem(xmlFile, self.workExhaustParticleSystems, namei, self.components, false, nil, self.baseDirectory)
	end;
		
	self.fistTimeRunning = true;
	self.increaseRpmDuringPloughing = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.increaseRpmDuringPloughing#value"), true);
end;

function PloughingSpec:delete()
	Utils.deleteParticleSystem(self.workExhaustParticleSystems);
end;

function PloughingSpec:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PloughingSpec:keyEvent(unicode, sym, modifier, isDown)
end;

function PloughingSpec:update(dt)
	if self.fistTimeRunning and self.motor ~= nil then
		self.saveMinRpm = self.motor.minRpm;
		self.fistTimeRunning = false;
	end;
	local densFrontLeft = 0;
	local densFrontRight = 0;
	local densBackLeft = 0;
	local densBackRight = 0;

	self.hasPloughAttached = false;
		
	for i=1, table.getn(self.attachedImplements) do
		if SpecializationUtil.hasSpecialization(Plough, self.attachedImplements[i].object.specializations) or self.attachedImplements[i].object.ploughSound ~= nil or (self.attachedImplements[i].object.cultivatorSound == nil and self.attachedImplements[i].object.mowerSound == nil and self.attachedImplements[i].object.tedderSound == nil and self.attachedImplements[i].object.windrowerSound == nil and self.attachedImplements[i].object.sowingSound == nil and self.attachedImplements[i].object.spraySound == nil) then
			if self.attachedImplements[i].object:isLowered(false) then
				self.hasPloughAttached = true;
			end;
		end;
	end;
	if self.hasPloughAttached and self.lastSpeed*3600 > 5 then
		if self.increaseRpmDuringPloughing then
			self:setVehicleRpmUp(dt, true);
		end;
		
		Utils.setEmittingState(self.workExhaustParticleSystems, true);
	else
		if self.increaseRpmDuringPloughing then
			self:setVehicleRpmUp(dt, false);
		end;
		Utils.setEmittingState(self.workExhaustParticleSystems, false)
	end;
end;

function PloughingSpec:draw()
end;

function PloughingSpec:setVehicleRpmUp(dt, isActive)
	if self.saveMinRpm ~= 0 and self.motor ~= nil then
		if dt ~= nil then
			if isActive == true then
				self.motor.minRpm = math.max(self.motor.minRpm-(dt/2), -1500);
			else
				self.motor.minRpm = math.min(self.motor.minRpm+(dt*2), self.saveMinRpm);
			end;
		else
			self.motor.minRpm = self.saveMinRpm;
		end;
		if self.isMotorStarted and not self.isFuelFilling then
			local fuelUsed = 0.0000001*math.abs(self.motor.minRpm);
			self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);
		end;
	end;
end;

function PloughingSpec:onDeactivate()
	if self.increaseRpmDuringPloughing then
		self:setVehicleRpmUp(nil, false);
	end;
end;