-- displayFunctions
--
-- Author RivalBomb

displayFunctions = {};
function displayFunctions.prerequisitesPresent(specializations)
    return true;
end;

function displayFunctions:load(xmlFile)
	self.displayFunctions = {};
	
	local node = "vehicle.displayFunctions.";
	self.displayFunctions.warning = Utils.indexToObject(self.components, getXMLString(xmlFile, node.."warnLight#index"));
	self.displayFunctions.forward = Utils.indexToObject(self.components, getXMLString(xmlFile, node.."forward#index"));
	self.displayFunctions.reverse = Utils.indexToObject(self.components, getXMLString(xmlFile, node.."reverse#index"));
	self.displayFunctions.blinker1 = Utils.indexToObject(self.components, getXMLString(xmlFile, node.."blinker1#index"));
	self.displayFunctions.blinker2 = Utils.indexToObject(self.components, getXMLString(xmlFile, node.."blinker2#index"));
	
	self.displayFunctions.timer = 0; -- timer for warning light
	self.displayFunctions.warnBlinkSpeed = 500;	-- 0.5 sec
	self.displayFunctions.warningLightActive = true;
	self.hasAttachedTrailers = 0;
	
	-- interior turn lights
	self.interiorTS = {};
	self.interiorTS.t2 = 0;
	self.interiorTS.leftIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnSignals.interiorTurnSignals#left"));
	self.interiorTS.rightIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnSignals.interiorTurnSignals#right"));
	self.interiorTS.warnIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnSignals.interiorTurnSignals#hazard"));
	self.displayFunctions.t = 0;
end;

function displayFunctions:delete()
end;

function displayFunctions:mouseEvent(posX, posY, isDown, isUp, button)
end;

function displayFunctions:keyEvent(unicode, sym, modifier, isDown)
end;

function displayFunctions:update(dt)
	self.interiorTS.t2=self.interiorTS.t2+dt;
	if self.interiorTS.t2 > self.displayFunctions.warnBlinkSpeed then
		self.displayFunctions.warningLightActive = not self.displayFunctions.warningLightActive;
		self.interiorTS.t2=0;
	end;
	
	local mFlickering=Utils.clamp(math.cos( 7.0 * (g_currentMission.time/1000) ) + 0.2, 0, 1);
	if self:getIsActive() then
		if (self.turnSignalState == 1 or self.turnSignalState == 3) and mFlickering == 0  then 	-- Blinker links
			if self.interiorTS.leftIndex ~= nil then
				setVisibility(self.interiorTS.leftIndex, true);
			end;
		else
			if self.interiorTS.leftIndex ~= nil then
				setVisibility(self.interiorTS.leftIndex, false);
			end;
		end;
		if (self.turnSignalState == 2 or self.turnSignalState == 3) and mFlickering == 0 then	-- Blinker rechts
			if self.interiorTS.rightIndex ~= nil then
				setVisibility(self.interiorTS.rightIndex, true);
			end;
		else
			if self.interiorTS.rightIndex ~= nil then
				setVisibility(self.interiorTS.rightIndex, false);
			end;
		end;
		if self.turnSignalState == 3 and mFlickering == 0 then	-- Warnblinker
			if self.interiorTS.warnIndex ~= nil then
				setVisibility(self.interiorTS.warnIndex, true);
			end;
		else
			if self.interiorTS.warnIndex ~= nil then
				setVisibility(self.interiorTS.warnIndex, false);
			end;
		end;
		
		
			-- Forward / Reverse --
		if self:getLastSpeed() * self.speedDisplayScale > 1 and self.movingDirection > 0 then
			if self.displayFunctions.forward ~= nil then
				setVisibility(self.displayFunctions.forward, true);
			end;
		elseif self:getLastSpeed() * self.speedDisplayScale > 1 and self.movingDirection < 0 then
			if self.displayFunctions.reverse ~= nil then
				setVisibility(self.displayFunctions.reverse, true);
			end;
		else
			if self.displayFunctions.forward ~= nil then
				setVisibility(self.displayFunctions.forward, false);
			end;
			if self.displayFunctions.reverse ~= nil then
				setVisibility(self.displayFunctions.reverse, false);
			end;
		end;	
	end;
end;

function displayFunctions:updateTick(dt)

	-- blinker light 1 and 2 --
	if table.getn(self.attachedImplements) > 0 or self.hasAttachedTrailers > 0 then
		self.hasAttachedTrailers = 0;
		for i=1, table.getn(self.attachedImplements) do  
			if self.attachedImplements[i].object.turnSignals.left[1] ~= nil and self.attachedImplements[i].object.turnSignals.right[1] ~= nil then 
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			end;
			if table.getn(self.attachedImplements[i].object.attachedImplements) > 0 then
				for r=1, table.getn(self.attachedImplements[i].object.attachedImplements) do
					if self.attachedImplements[i].object.attachedImplements[r].object.turnSignals.left[1] ~= nil and self.attachedImplements[i].object.attachedImplements[r].object.turnSignals.right[1] ~= nil then 
						self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
					end;
				end;
			end;
		end;
	local mFlickering=Utils.clamp(math.cos( 7.0 * (g_currentMission.time/1000) ) + 0.2, 0, 1);
		if self.displayFunctions.blinker1 ~= nil and self.displayFunctions.blinker2 ~= nil then
			if self.turnSignalState ~= 0 then
				if self.hasAttachedTrailers == 0 then
					setVisibility(self.displayFunctions.blinker1, false);
					setVisibility(self.displayFunctions.blinker2, false);
				elseif self.hasAttachedTrailers == 1 then
					setVisibility(self.displayFunctions.blinker1, mFlickering == 0);
					setVisibility(self.displayFunctions.blinker2, false);
				elseif self.hasAttachedTrailers == 2 then
					setVisibility(self.displayFunctions.blinker1, mFlickering == 0);
					setVisibility(self.displayFunctions.blinker2, mFlickering == 0);
				end;
			else
				setVisibility(self.displayFunctions.blinker1, false);
				setVisibility(self.displayFunctions.blinker2, false);
			end;
		end;
	end;
end;

function displayFunctions:draw()
end;