-- 
-- FSM Iveco Stralis Functions
-- version: 1.0
-- date: 18.09.2015
-- author: [FSM]Chefkoch
-- hp: http://fsm-team.de
-- 
-- Keine Vernderung ohne meine Erlaubnis!
-- No modification without	my permission!
-- 
-- used sources:
-- *cablight Script LS13 - author:? | <cablight realLight="0>0" corona="0>0|1" />
-- *hudLoad Script LS15 - author:? | <onBoardHud screen1Index="0>32|0" screen2Index="0>32|1" screen3Index="0>32|2" screen4Index="0>32|2" />
--

stralis = {};

function stralis.prerequisitesPresent(specializations) 
	return true; 
end;

function stralis:load(xmlFile)
	-- onBoard Display Stuff
	self.speedWaitingMaxTimeHud = 6000; 
	self.speedWaitingTimerHud = 1; 
	self.hudFirst  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Stralis.onBoardHud#screen1Index"));
	self.hudSecond = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Stralis.onBoardHud#screen2Index"));
	self.hudThird  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Stralis.onBoardHud#screen3Index"));
	self.hudFour  = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Stralis.onBoardHud#screen4Index"));
	
	-- Cablight Stuff
	self.setCablight = SpecializationUtil.callSpecializationsFunction("setCablight");
	self.cl = {};
	self.cl.rl = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Stralis.cablight#realLight"));
	self.cl.co = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Stralis.cablight#corona"));
	self.cl.turnOn = false;
	self.cl.isOn = false;
	self.cl.active = false;
	setVisibility( self.cl.rl, false );
	setVisibility( self.cl.co, false );
	
	-- Tankleuchte
	self.tankLeuchte = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Stralis.TankLeuchte#index"));
	self.tankMinWarnLevel = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Stralis.TankLeuchte#minWarnLevel"));
	setVisibility(self.tankLeuchte, false);
	
	-- Ladekontrollleuchte
	self.ladeLeuchte = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Stralis.LadeKontrollLeuchte#index"));
	setVisibility(self.ladeLeuchte, false);
	self.ladeLeuchteOn = 1;
	self.ladeTimer = 10;
	
	-- Temperaturzeiger Wasser
	self.temperaturZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Stralis.TemperaturZeiger#zeigerIndex"));
	self.temperaturZeigerMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Stralis.TemperaturZeiger#maxRotation"));
	self.tempCnt = 0;

end;

function stralis:delete() 
end;

function stralis:mouseEvent(posX, posY, isDown, isUp, button) 
end;

function stralis:keyEvent(unicode, sym, modifier, isDown) 
end;

function stralis:update(dt) 

	if self.isMotorStarted then 
		if self.speedWaitingTimerHud < self.speedWaitingMaxTimeHud then 
			setVisibility(self.hudFirst, true);
			setVisibility(self.hudSecond, false);
			setVisibility(self.hudThird, false);
			setVisibility(self.hudFour, false); 
		end;
		
		if self.speedWaitingTimerHud > 2000 then 
			setVisibility(self.hudFirst, false);
			setVisibility(self.hudSecond, true);
			setVisibility(self.hudThird, false);
			setVisibility(self.hudFour, false); 
		end;
		
		if self.speedWaitingTimerHud > 4000 then
			setVisibility(self.hudFirst, false);
			setVisibility(self.hudSecond, false);
			setVisibility(self.hudThird, true);
			setVisibility(self.hudFour, false); 
		end;
		
		if self.speedWaitingTimerHud > 5999 then 
			setVisibility(self.hudFirst, false);
			setVisibility(self.hudSecond, false);
			setVisibility(self.hudThird, false);
			setVisibility(self.hudFour, true); 
		end;
		
		self.speedWaitingTimerHud = self.speedWaitingTimerHud + dt;
	else
		self.speedWaitingTimerHud = 1;
		setVisibility(self.hudFirst, false);
		setVisibility(self.hudSecond, false);
		setVisibility(self.hudThird, false);
		setVisibility(self.hudFour, false); 
	end;
	
	
	if self:getIsActive() then
		if self.isMotorStarted then
			if self.ladeLeuchteOn == 1 then
				setVisibility(self.ladeLeuchte, true);
				if self.movingDirection ~= 0 then
					self.timerTrue = true;
				end;
				if self.timerTrue then
					self.ladeTimer = math.max(self.ladeTimer - 0.1, 0);
				end;
				if self.ladeTimer == 0 then
					setVisibility(self.ladeLeuchte, false);
					self.timerTrue = nil;
					self.ladeLeuchteOn = 0;
					self.ladeTimer = 10;
				end;
			end;

			local actualTankInhalt = 0;
			if self.fuelCapacity > 0 then
				actualTankInhalt = (self.fuelFillLevel / self.fuelCapacity + 0.0001) * 100;
			end;
			if actualTankInhalt < self.tankMinWarnLevel then
				setVisibility(self.tankLeuchte, true);
			else
				setVisibility(self.tankLeuchte, false);
			end;
			if self.tempCnt < 3000 then
				setRotation(self.temperaturZeiger, 0, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt));
				self.tempCnt = self.tempCnt + 0.8;
			elseif self.tempCnt > 3000 and self.tempCnt < 6000 then
				setRotation(self.temperaturZeiger, 0, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt));
				self.tempCnt = math.min(self.tempCnt + 0.3, 10000);			
			else
				setRotation(self.temperaturZeiger, 0, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt));
				self.tempCnt = math.min(self.tempCnt + 0.04, 10000);
			end;
			else
			self.tempCnt = math.max(self.tempCnt - 0.1, 0);
		end;
	end;

	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.CABLIGHT) then
				self:setCablight(not self.cl.turnOn);
			end;
		end;
	end;
	
	local realLightsActive = false;
	realLightsActive = self:getIsActiveForLights();
	
	if (self.cl.turnOn == true and self.cl.isOn == false) or (self.cl.active ~= realLightsActive) then
		if self.cl.rl ~= nil then
			if realLightsActive then
				setVisibility( self.cl.rl, true );
			else
				setVisibility( self.cl.rl, false );
			end
		end;
		if self.cl.co ~= nil then
			setVisibility( self.cl.co, true );			
		end;
		self.cl.active = realLightsActive;
		self.cl.isOn = true;
	elseif (self.cl.turnOn == false and self.cl.isOn == true) then
		if self.cl.rl ~= nil then
			setVisibility( self.cl.rl, false );
		end;
		if self.cl.be ~= nil then
			setVisibility( self.cl.be, false );
		end;
		if self.cl.co ~= nil then
			setVisibility( self.cl.co, false );		
		end;
		self.cl.isOn = false;
	end;
end;

function stralis:loadFromAttributesAndNodes(xmlFile, key, resetVehicles) 
	return BaseMission.VEHICLE_LOAD_OK; 
end;

function stralis:getSaveAttributesAndNodes(nodeIdent) 
end;

function stralis:readStream(streamId, connection)
	local state = streamReadBool(streamId);
	self:setCablight(state, true);
end;

function stralis:writeStream(streamId, connection)
	streamWriteBool(streamId, self.cl.turnOn);
end;

function stralis:updateTick(dt) 
end;

function stralis:draw()
	if g_currentMission.controlledVehicle ~= nil then
		g_currentMission:addHelpButtonText(g_i18n:getText("CABLIGHTONOFF"), InputBinding.CABLIGHT);
	end;
end;

function stralis:onAttach(attacherVehicle, jointDescIndex) 
end;

function stralis:onDetach() 
end;

function stralis:onDeactivate() 
end;

function stralis:setCablight(state, noEventSend)
	SetCablightEvent.sendEvent(self, state, noEventSend);
	self.cl.turnOn = state;
end;



--
-- iNet Stuff
--
SetCablightEvent = {};
SetCablightEvent_mt = Class(SetCablightEvent, Event);

InitEventClass(SetCablightEvent, "SetCablightEvent");

function SetCablightEvent:emptyNew()
    local self = Event:new(SetCablightEvent_mt);
    self.className="SetCablightEvent";
    return self;
end;

function SetCablightEvent:new(object, state)
    local self = SetCablightEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function SetCablightEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function SetCablightEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function SetCablightEvent:run(connection)
    self.object:setCablight(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetCablightEvent:new(self.object, self.state), nil, connection, self.object);
    end;
end;

function SetCablightEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetCablightEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetCablightEvent:new(vehicle, state));
		end;
	end;
end;

