-- 
-- Trailer Worklight Script
-- version: 1.0
-- date: 27.01.2016
-- author: [FSM]Chefkoch
-- hp: http://fsm-team.de
-- 
-- Keine Vernderung ohne meine Erlaubnis!
-- No modification without	my permission!
-- 
-- used sources:
-- *cablight Script LS13 - author:? | <trailerWorklight realLight="0>0" corona="0>0|1" />


trailerWorklight ={};
trailerWorklight.modDir = g_currentModDirectory;

function trailerWorklight.prerequisitesPresent(specializations)
    return true;
end;

function trailerWorklight:load(xmlFile)
	self.setTrailerworklight = SpecializationUtil.callSpecializationsFunction("setTrailerworklight");
	self.twl = {};
	self.twl.rl = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerWorklight#realLight"));
	self.twl.co = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerWorklight#corona"));
	self.twl.turnOn = false;
	self.twl.isOn = false;
	self.twl.active = false;
	setVisibility( self.twl.rl, false );
	setVisibility( self.twl.co, false );
	
	WorkLightSoundFile = Utils.getFilename("Sounds/blinktick.wav", self.baseDirectory);
	self.WorkLightSoundId = createSample("WorkLightSound");
	loadSample(self.WorkLightSoundId, WorkLightSoundFile, false);
	self.WorkLightSoundPlaying = false;
	
end;

function trailerWorklight:delete()
end;

function trailerWorklight:readStream(streamId, connection)
	local state = streamReadBool(streamId);
	self:setTrailerworklight(state, true);
end;

function trailerWorklight:writeStream(streamId, connection)
	streamWriteBool(streamId, self.twl.turnOn);
end;

function trailerWorklight:readUpdateStream(streamId, timestamp, connection)
end;

function trailerWorklight:writeUpdateStream(streamId, connection, dirtyMask)
end;

function trailerWorklight:mouseEvent(posX, posY, isDown, isUp, button)
end;

function trailerWorklight:keyEvent(unicode, sym, modifier, isDown)
end;

function trailerWorklight:update(dt)
	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.TRAILERWORKLIGHT) then
				self:setTrailerworklight(not self.twl.turnOn);
				playSample(self.WorkLightSoundId,1,1,0);
			end;
		end;
	end;
	
	local realLightsActive = false;
	realLightsActive = self:getIsActiveForLights();
	
	if (self.twl.turnOn == true and self.twl.isOn == false) or (self.twl.active ~= realLightsActive) then
		if self.twl.rl ~= nil then
			if realLightsActive then
				setVisibility( self.twl.rl, true );
			else
				setVisibility( self.twl.rl, false );
			end
		end;
		if self.twl.co ~= nil then
			setVisibility( self.twl.co, true );			
		end;
		self.twl.active = realLightsActive;
		self.twl.isOn = true;
	elseif (self.twl.turnOn == false and self.twl.isOn == true) then
		if self.twl.rl ~= nil then
			setVisibility( self.twl.rl, false );
		end;
		if self.twl.be ~= nil then
			setVisibility( self.twl.be, false );
		end;
		if self.twl.co ~= nil then
			setVisibility( self.twl.co, false );		
		end;
		self.twl.isOn = false;
	end;
end;

function trailerWorklight:updateTick(dt)

end;

function trailerWorklight:draw()
	if g_currentMission.controlledVehicle ~= nil then
		g_currentMission:addHelpButtonText(g_i18n:getText("TRAILERWORKLIGHTONOFF"), InputBinding.TRAILERWORKLIGHT);
	end;
end;

function trailerWorklight:onLeave()

end;

function trailerWorklight:onEnter()

end;

function trailerWorklight:setTrailerworklight(state, noEventSend)
	SetTrailerworklightEvent.sendEvent(self, state, noEventSend);
	self.twl.turnOn = state;
end;
	
--
-- iNet Stuff
--

SetTrailerworklightEvent = {};
SetTrailerworklightEvent_mt = Class(SetTrailerworklightEvent, Event);

InitEventClass(SetTrailerworklightEvent, "SetTrailerworklightEvent");

function SetTrailerworklightEvent:emptyNew()
    local self = Event:new(SetTrailerworklightEvent_mt);
    self.className="SetTrailerworklightEvent";
    return self;
end;

function SetTrailerworklightEvent:new(object, state)
    local self = SetTrailerworklightEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function SetTrailerworklightEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function SetTrailerworklightEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function SetTrailerworklightEvent:run(connection)
    self.object:setTrailerworklight(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetTrailerworklightEvent:new(self.object, self.state), nil, connection, self.object);
    end;
end;

function SetTrailerworklightEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetTrailerworklightEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetTrailerworklightEvent:new(vehicle, state));
		end;
	end;
end;

