-- ##########################################
-- #	ShowObjectOnAttach					#
-- #	version: 1.0						#
-- #	Date: 29.07.2013					#
-- #	author: [FSM]Chefkoch				#
-- #	hp: http://fsm-team.de				#
-- #										#
-- # 	Keine Vernderung ohne				# 
-- # 	meine Erlaubnis!					#
-- # 	No modification without				# 
-- # 	my permission!						#
-- #										#
-- #	THX 2:								#
-- #	Bluebaby210							#
-- #	for helping me with this script		#
-- #										#
-- #	history:							#
-- #	v1.0	Project started				#
-- #										#
-- ########################################## 

ShowObjectOnAttach = {};

function ShowObjectOnAttach.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowObjectOnAttach:load(xmlFile)
	self.Object = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ShowObjectOnAttach#Object"));
	
	setVisibility(self.Object, false);
end;

function ShowObjectOnAttach:draw()
end;

function ShowObjectOnAttach:delete()
end;

function ShowObjectOnAttach:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowObjectOnAttach:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowObjectOnAttach:update()
end;

function ShowObjectOnAttach:attachImplement()
	for k,v in pairs(self.attachedImplements) do
		if v.object.attacherVehicle ~= nil then
			if v.object.attacherVehicle.attacherJoints[v.jointDescIndex] == self.attacherJoints[2] then
				setVisibility(self.Object, true);
			end;
		end;
	end;
end;

function ShowObjectOnAttach:detachImplement()
	setVisibility(self.Object, false);
end;