--
-- VariableBody
-- This is a specialization for trailers, which have a extra bodywork for loading chaff/grass?
-- 
--
-- @author:		fruktor (wwww.modding-society.de) Convertit to LS15 by Sabo.D "AoM"
-- @version:	v1.0
-- @date:		08/12/10
-- @history:	v0.1 - inital implementation
--
-- Copyright (C) 
--

VariableBody = {};

function VariableBody.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations) and 
		SpecializationUtil.hasSpecialization(Attachable, specializations) and
		SpecializationUtil.hasSpecialization(Fillable, specializations) 
end;

function VariableBody:load(xmlFile)
	
	self.changeVariableBody = SpecializationUtil.callSpecializationsFunction("changeVariableBody");
	
	--get VariableBody attributes
	self.varBody = {};

	local activeIdx = getXMLInt(xmlFile, "vehicle.variableBody#activeIdx");
	if activeIdx ~= nil then
		self.varBody.activeIdx = activeIdx;
	else
		self.varBody.activeIdx = 1;
	end;
	
	local activeIdx = getXMLInt(xmlFile, "vehicle.variableBody#activeSubIdx");
	if activeIdx ~= nil then
		self.varBody.activeSubIdx = activeSubIdx;
	else
		self.varBody.activeSubIdx = 1;
	end;

	self.varBody.nodes = {};
	
	
	local i=0;
	local j=0;
	while true do

		local path = string.format("vehicle.variableBody.node(%d)", i);
	
		local name = getXMLString(xmlFile, path .. "#name");
		if name == nil then
			break;
		end;
		local capacity = getXMLInt(xmlFile, path .. "#capacity");
		--print("VariableBody:load(). name="..name.." cap="..capacity);
			
		--####
		local fillTypes = {};
		local fruitTypes = getXMLString(xmlFile, path .. "#fruitTypes");
		if fruitTypes ~= nil then
			local types = Utils.splitString(" ", fruitTypes);
			for k,v in pairs(types) do
				--print(v);
				local fillType = Fillable.fillTypeNameToInt[v];
				if fillType ~= nil then
					fillTypes[fillType] = true;
				else
					print("Warning: '"..self.configFileName.. "' has invalid fillType '"..v.."'.");
				end;
			end;
		end;
		
		--#### 
		local parts = {};
		
		j=0;
		local k=1;
		local str = getXMLString(xmlFile, string.format("vehicle.variableBody.node(%d).part(%d)#index%d", i, j, k));
		
		--[[if str == nil and string.match("roof", name) then
			local subparts = {};
			subparts.allowFill = 1;
			subparts.objects = {};
			subparts.subPartCount = 0;
			table.insert(parts, subparts);
			j=j+1;
		else]]--		
			while str ~= nil do
				
				local subparts = {};
				
				local allowFill = getXMLInt(xmlFile, string.format("vehicle.variableBody.node(%d).part(%d)#allowFill", i, j));
				if allowFill ~= nil then
					subparts.allowFill = allowFill;
				else
					subparts.allowFill = 1;
				end;			
				
				--local objects = {};
				subparts.objects = {};
				while str ~= nil do 
					local tmpIdx = Utils.indexToObject(self.components, str)
					--print("------------>str="..str.."   tmpIdx="..tmpIdx);
					k=k+1;
					table.insert(subparts.objects, tmpIdx);
					str = getXMLString(xmlFile, string.format("vehicle.variableBody.node(%d).part(%d)#index%d", i, j, k));
				end;
				--table.insert(, objects);
				
				subparts.subPartCount = k-1;
				if subparts ~= nil then
					table.insert(parts, subparts);
				else	
					break;
				end;
				j=j+1;
				k=1;
				str = getXMLString(xmlFile, string.format("vehicle.variableBody.node(%d).part(%d)#index%d", i, j, k));
				
			end;
		--end;
		
		if j == 0 then
			local subparts = {};
			subparts.objects = nil;
			subparts.allowFill = 1;
			subparts.subPartCount = 0;
			table.insert(parts, subparts);
		end;

		
		--####
		
		fillVolumes = {};
        k = 0;
		while true do
			local key = string.format("vehicle.variableBody.node(%d).fillVolumes.fillVolume(%d)", i, k);
			if not hasXMLProperty(xmlFile, key) then
				--print("k="..k);
				break;
			end;
			local fillVolume = {};
            fillVolume.baseNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
            fillVolume.allSidePlanes = Utils.getNoNil(getXMLBool(xmlFile, key.."#allSidePlanes"), true);
            local defaultFillType = getXMLString(xmlFile, key.."#defaultFillType");
            if defaultFillType ~= nil then
                local fillType = Fillable.fillTypeNameToInt[defaultFillType];
                if fillType ~= nil then
                    fillVolume.defaultFillType = fillType;
                else
                    print("Warning: Invalid defaultFillType '"..tostring(defaultFillType).."' in '"..self.configFileName.."'");
                end;
            end;
            fillVolume.maxDelta = Utils.getNoNil(getXMLFloat(xmlFile, key.."#maxDelta"), 1.0);
            fillVolume.maxSurfaceAngle = math.rad( Utils.getNoNil(getXMLFloat(xmlFile, key.."#maxAllowedHeapAngle"), 35) );
            local maxPhysicalSurfaceAngle = math.rad(35);
            fillVolume.maxSubDivEdgeLength = Utils.getNoNil(getXMLFloat(xmlFile, key.."#maxSubDivEdgeLength"), 0.9);
            fillVolume.volume = createFillPlaneShape(fillVolume.baseNode, "fillPlane", capacity, fillVolume.maxDelta, fillVolume.maxSurfaceAngle, maxPhysicalSurfaceAngle, fillVolume.maxSubDivEdgeLength, fillVolume.allSidePlanes);
            fillVolume.deformers = {};
            if fillVolume.volume ~= nil then
                local m = 0;
                while true do
                    local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key..".deformNode("..m..")#index"));
                    if node == nil then
                        break;
                    end;
                    local initPos = { localToLocal(node, fillVolume.baseNode, 0,0,0) };
                    local polyline = findPolyline(fillVolume.volume, initPos[1],initPos[3]);
                    self.fillVolumeDeformers[node] = {node=node, initPos=initPos, posX=initPos[1], posZ=initPos[3], polyline=polyline, volume=fillVolume.volume, baseNode=fillVolume.baseNode};
                    m = m + 1;
                end;
            end;
            fillVolume.scrollSpeedDischarge = { Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, key.."#scrollSpeedDischarge"), "0 0 0")) };
            fillVolume.scrollSpeedLoad = { Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, key.."#scrollSpeedLoad"), "0 0 0")) };
            for k=1,3 do
                fillVolume.scrollSpeedDischarge[k] = fillVolume.scrollSpeedDischarge[k] / 1000;
                fillVolume.scrollSpeedLoad[k] = fillVolume.scrollSpeedLoad[k] / 1000;
            end;
            fillVolume.uvPosition = {0, 0, 0};
            if fillVolume.volume ~= nil and fillVolume.volume ~= 0 then
                link(fillVolume.baseNode, fillVolume.volume);
                table.insert(self.fillVolumes, fillVolume);
            end;
            k = k + 1;
        end;
				
		--####
		local entry={};
		entry.name = name;
		entry.capacity = capacity;
		entry.index = index; 
		entry.parts = parts;
		entry.partCount = j;
		entry.fillTypes = fillTypes;
		entry.fillVolumes = fillVolumes;
		table.insert(self.varBody.nodes, entry);
		
		--for x,v in pairs(parts) do
			--print("VariableBody:load(xmlFile):: name="..name.." cap="..capacity.." partCount="..entry.partCount.." allowFill="..v.allowFill.." subPartCount="..v.subPartCount);
		--end;
		i=i+1;
		
		
	end;
	--print("i="..i);
	
	if self.varBody.activeIdx > i then
		self.varBody.activeIdx = i;
	end;
	self.varBody.nodeCount=table.getn(self.varBody.nodes);
	
	self.varBody.origFillVolumes = {};
	for i,j in pairs(self.fillVolumes) do
		self.varBody.origFillVolumes[i] = j;
	end;
	
	--self:changeVariableBody(self.varBody.activeIdx, self.varBody.activeSubIdx, true);

end;

function VariableBody:readStream(streamId, connection)
	local state = streamReadInt8(streamId);
	local state2 = streamReadInt8(streamId);
	self:changeVariableBody(state, state2, true);
end;

function VariableBody:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.varBody.activeIdx);
	streamWriteInt8(streamId, self.varBody.activeSubIdx);
end;

function VariableBody:delete()
end;

function VariableBody:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VariableBody:keyEvent(unicode, sym, modifier, isDown)
end;

function VariableBody:update(dt)

	if self.varTip ~= nil then
		if self.varTip.activeTrailerIdx ~= self.varTip.trailerNr then
			return;
		end;
	end;
		

	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if self.tipState == Trailer.TIPSTATE_CLOSED then
				--and self.varBody.nodeCount > 1 then
			
				if self.fillLevel == 0 and self:getAllowFillFromAir(false) then
					if InputBinding.hasEvent(InputBinding.VARIABLEBODY_change) then
						if self.fillLevel == 0 then
							local idx = self.varBody.activeIdx + 1;
							if idx > self.varBody.nodeCount then
								idx = 1
							end;
							local idx2 = self.varBody.activeSubIdx;
							if idx2 > self.varBody.nodes[idx].partCount then
								idx2 = 1;
							end
							self:changeVariableBody(idx, idx2);
						end;
					end;
				end;
				
				if string.match("roof", self.varBody.nodes[self.varBody.activeIdx].name) then 
					if InputBinding.hasEvent(InputBinding.VARIABLEBODY_changePart) then
						local idx = self.varBody.activeSubIdx + 1;
						if idx > self.varBody.nodes[self.varBody.activeIdx].partCount then
							idx = 1
						end;
						self:changeVariableBody(self.varBody.activeIdx, idx);
					end;
				end;
			else
				--print("trailer not closed");
			end;				
		end;
	end;	
end;

function VariableBody:updateTick(dt)
end;

function VariableBody:draw()

	if self.varTip ~= nil then
		if self.varTip.activeTrailerIdx ~= self.varTip.trailerNr then
			return;
		end;
	end;

	if self.tipState == Trailer.TIPSTATE_CLOSED then
			--self.varBody.nodeCount> 1 then
			
		if self.fillLevel == 0 and self:getAllowFillFromAir(false) then
			if self.varBody.nodeCount> 1 then
				g_currentMission:addHelpButtonText( 
					string.format(g_i18n:getText("VARIABLEBODY_display"),
					self.varBody.activeIdx, 
					self.varBody.nodeCount ),
					InputBinding.VARIABLEBODY_change );
					--[[string.format(g_i18n:getText("VARIABLEBODY_display"), 	
					self.varBody.activeIdx, 
					self.varBody.nodeCount, 
					self.varBody.nodes[self.varBody.activeIdx].name, 
					self.varBody.nodes[self.varBody.activeIdx].capacity), 
					InputBinding.VARIABLEBODY_change ) ;]]--
			end;
		end;
		
		if string.match("roof", self.varBody.nodes[self.varBody.activeIdx].name) then 
			g_currentMission:addHelpButtonText( 
			--[[string.format(g_i18n:getText("VARIABLEBODY_displayPart"), 	
				self.varBody.activeSubIdx, 
				self.varBody.nodes[self.varBody.activeIdx].partCount,
				self.varBody.nodes[self.varBody.activeIdx].parts[self.varBody.activeSubIdx].allowFill), 
			InputBinding.VARIABLEBODY_changePart ) ;	]]--
			g_i18n:getText("VARIABLEBODY_displayPart"), InputBinding.VARIABLEBODY_changePart ) ;					
		end;
		
	end;

end;

function VariableBody:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local idx = Utils.getNoNil(getXMLInt(xmlFile,key.."#varBody.activeIdx"),1);
		if idx > table.getn(self.varBody.nodes) then
			idx = 1;
		end;
		local idx2 = Utils.getNoNil(getXMLInt(xmlFile,key.."#varBody.activeSubIdx"),1);
		if idx2 > table.getn(self.varBody.nodes[idx].parts) then
			idx2 = 1;
		end;
		self:changeVariableBody(idx, idx2, true);
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function VariableBody:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ' varBody.activeIdx="'..tostring(self.varBody.activeIdx)..' "varBody.activeSubIdx="'..tostring(self.varBody.activeSubIdx)..'"';
    local node = nil;
    return attributes, node;
end;

function VariableBody:changeVariableBody(state, state2, noEventSend)

	VariableBodyEvent.sendEvent(self, state, state2, noEventSend);
	
	for i=1, table.getn(self.varBody.nodes) do 
		if self.varBody.nodes[i].partCount > 0 then
			for j=1, table.getn(self.varBody.nodes[i].parts) do 
				if i ~= state or j ~= state2 then
					for k=1,table.getn(self.varBody.nodes[i].parts[j].objects) do
						setVisibility(self.varBody.nodes[i].parts[j].objects[k], false);				
					end;
				end
			end;
		end;
	end;	
	
	if self.varBody.nodes[state] ~= nil then
		if self.varBody.nodes[state].partCount > 0 then
			if self.varBody.nodes[state].parts[state2].subPartCount > 0 then
				for k=1,table.getn(self.varBody.nodes[state].parts[state2].objects) do
					setVisibility(self.varBody.nodes[state].parts[state2].objects[k], true);
				end;
			end;
		end;
	end;

	--if state ~= self.varBody.activeIdx then
		for i,j in pairs(self.fillTypes) do
			if self.varBody.nodes[state].fillTypes[i] == true then
				self.fillTypes[i] = true;
			else
				self.fillTypes[i] = false;
			end;
		end;
		--self:setFillLevel(self.fillLevel, self.currentFillType);
		
		for i,j in pairs(self.fillVolumes) do
			if self.varBody.nodes[state].fillVolumes[i] ~= nil then
				self.fillVolumes[i] = self.varBody.nodes[state].fillVolumes[i];
			else
				self.fillVolumes[i] = self.varBody.origFillVolumes[i];
			end;
		end;
		---self:setFillLevel(self.fillLevel, self.currentFillType);
	--end;
	
	
	if self.varBody.nodes[state].parts[state2].allowFill == 1 then
		self.allowFillFromAir = true;
	else
		self.allowFillFromAir = false;
	end;
	
	self.capacity = self.varBody.nodes[state].capacity;
	self:setFillLevel(self.fillLevel, self.currentFillType);

	self.varBody.activeIdx = state;
	self.varBody.activeSubIdx = state2;	

end;