--
-- ELVTS
--
-- edit 01/10/2015

ELVTS = {};

function ELVTS.prerequisitesPresent(specializations)
	return true;
end;

function ELVTS:load(xmlFile)
		
	self.isSelectable = true;
	self.setRpmUp = SpecializationUtil.callSpecializationsFunction("setRpmUp");
	
	self.firstAttachOnLoad = false;
	self.firstAttachTime = 4000;
	self.attachableObject = nil;
	self.saveMinRpm = 0;
	
	self.tipState = 0;
				
end;

function ELVTS:delete()
end;

function ELVTS:readStream(streamId, connection)

end;

function ELVTS:writeStream(streamId, connection)

end;

function ELVTS:mouseEvent(posX, posY, isDown, isUp, button)

end;

function ELVTS:keyEvent(unicode, sym, modifier, isDown)

end;

function ELVTS:update(dt)
	
	if self:getIsActiveForInput() and self:getIsActive() then
		local isKeyEvent = false;
		if self.tipState == 0 then
			if InputBinding.isPressed(InputBinding.ELVT_UP) and self:getIsActiveForInput() then
				self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet*(dt/10)));
				isKeyEvent = true;
			elseif InputBinding.isPressed(InputBinding.ELVT_DOWN) and self:getIsActiveForInput() then
				self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet*(dt/10)));
				isKeyEvent = true;
			end;
		end;
		self:setRpmUp(dt, isKeyEvent);
	end;
end;

function ELVTS:updateTick(dt)
end;

function ELVTS:setRpmUp(dt, isActive)
	if self.attacherVehicle ~= nil and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-dt, -1000);
			else
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+dt*2, self.saveMinRpm);
			end;
		else
			self.attacherVehicle.motor.minRpm = self.saveMinRpm;
		end;
	end;
end;

function ELVTS:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy == nil then
		self.attacherVehicleCopy = self.attacherVehicle;
	end;
	self.saveMinRpm = self.attacherVehicle.motor.minRpm;
end;

function ELVTS:onDetach()
	if self.deactivateOnDetach then
        self:onDeactivate(self);
    else
        self:onDeactivateSounds(self);
    end;
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.saveMinRpm;
			self.attacherVehicleCopy = nil;
		end;
	end;
end;

function ELVTS:draw()
	
    if self.isClient and self:getIsActiveForInput(true) then 
	    if self.animationParts[1].clip then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("ELVT_DOWN")), InputBinding.ELVT_DOWN);
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("ELVT_UP")), InputBinding.ELVT_UP);
	    end;
	end;
end;

function ELVTS:validateAttacherJoint(jointDesc, dt)
    return true;
end;
