--
-- ELVT
--
-- edit 01/10/2015

ELVT = {};

function ELVT.prerequisitesPresent(specializations)
	return true;
end;

function ELVT:load(xmlFile)
	
	self.getAllowFillFromAir = Utils.overwrittenFunction(self.getAllowFillFromAir, ELVT.getAllowFillFromAir);
	
	self.isSelectable = true;
	self.setRpmUp = SpecializationUtil.callSpecializationsFunction("setRpmUp");
	
	self.firstAttachOnLoad = false;
	self.firstAttachTime = 4000;
	self.attachableObject = nil;
	self.saveMinRpm = 0;
	
	self.tipState = 0;
	
	self.OpenCo = false;
			
end;

function ELVT:delete()
end;

function ELVT:readStream(streamId, connection)

end;

function ELVT:writeStream(streamId, connection)

end;

function ELVT:mouseEvent(posX, posY, isDown, isUp, button)

end;

function ELVT:keyEvent(unicode, sym, modifier, isDown)

end;

function ELVT:update(dt)
	
	if self:getIsActiveForInput() and self:getIsActive() then
		local isKeyEvent = false;
		if self.tipState == 0 then
			if InputBinding.isPressed(InputBinding.ELVT_UP) and self:getIsActiveForInput() then
				self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet*(dt/10)));
				isKeyEvent = true;
			elseif InputBinding.isPressed(InputBinding.ELVT_DOWN) and self:getIsActiveForInput() then
				self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet*(dt/10)));
				isKeyEvent = true;
			end;
		end;
		self:setRpmUp(dt, isKeyEvent);
	end;
	if self:getIsActiveForInput() and self:getIsActive() then
		local isKeyEvent = false;
		if self.tipState == 0 and self.varBody.activeIdx == 4 then
			if InputBinding.hasEvent(InputBinding.BACHE_UP) and self:getIsActiveForInput() then 
				self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet*(dt/0)));
			    self.OpenCo = true;
				isKeyEvent = true;
			elseif InputBinding.hasEvent(InputBinding.BACHE_DOWN) and self:getIsActiveForInput() then
				self:setAnimationTime(2, self.animationParts[2].currentPosition-(self.animationParts[2].offSet*(dt/0)));
			    self.OpenCo = false;			
				isKeyEvent = true;
			end;
		end;
	end;	
end;

function ELVT:updateTick(dt)
end;

function ELVT:setRpmUp(dt, isActive)
	if self.attacherVehicle ~= nil and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-dt, -1000);
			else
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+dt*2, self.saveMinRpm);
			end;
		else
			self.attacherVehicle.motor.minRpm = self.saveMinRpm;
		end;
	end;
end;

function ELVT:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy == nil then
		self.attacherVehicleCopy = self.attacherVehicle;
	end;
	self.saveMinRpm = self.attacherVehicle.motor.minRpm;
end;

function ELVT:onDetach()
	if self.deactivateOnDetach then
        self:onDeactivate(self);
    else
        self:onDeactivateSounds(self);
    end;
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.saveMinRpm;
			self.attacherVehicleCopy = nil;
		end;
	end;
end;

function ELVT:draw()
	
    if self.isClient and self:getIsActiveForInput(true) then 
	    if self.animationParts[1].clip then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("ELVT_DOWN")), InputBinding.ELVT_DOWN);
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("ELVT_UP")), InputBinding.ELVT_UP);
	    end;
		if self.tipState == 0 and self.varBody.activeIdx == 4 then
	        if self.animationParts[2].clip then
                if self.OpenCo then
		    	    g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BACHE_UP")), InputBinding.BACHE_DOWN);
		        else	
		    	    g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BACHE_DOWN")), InputBinding.BACHE_UP);
				end;
	        end;
		end;
	end;
end;

function ELVT:validateAttacherJoint(jointDesc, dt)
    return true;
end;

function ELVT:getAllowFillFromAir(superFunc)
    if self.OpenCo then
        return false;
    end
    return superFunc(self);
end