--[[
PickUp Particlesystem fr Pressen oder Ladewagen.

Vorlage war hier die Claas3200.lua von TTM!

Anpassungen:				Ifko[nator]
Erstellt/angepasst am:		25.06.2013

Fix: Nun wird kein PS mehr erzeugt wenn man einen Ladewagen entleert.

Gefixt von Ifko[nator] am:	03.07.2013

Edit: 18.08.2013

Gendert wurde: StaticParticleSystem fr die KronePickupParticleSystems direkt eigebunden damit keine extra lua mehr notwendig ist.

Gendert von: Ifko[nator]

Dieses Script ist Freiverwendbar! Sollt es ja auch nutzen.. ^^

Fr fragen bin ich via PN: 

auf www.ls-mapsource.de als "Ifko" 

oder auf www.modding-welt.com als "Ifkonator" zu erreichen.
]]

KronePickupParticleSystems = {};

function  KronePickupParticleSystems.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function  KronePickupParticleSystems:load(xmlFile)
	self.wheatParticleSystems = {};
	local i=0;
	while true do
		local key = string.format("vehicle.KronePickupParticleSystems.Straw(%d)", i);
		local node = getXMLString(xmlFile, key.. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key.. "#file");
			local wheatParticleSystem = {};
			wheatParticleSystem.particleSystem = {};
			StaticParticleSystem.loadParticleSystem(xmlFile, wheatParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.wheatParticleSystems, wheatParticleSystem);
		end;
		i = i+1;
	end;
	
	self.grassParticleSystems = {};
	local i=0;
	while true do
		local key = string.format("vehicle.KronePickupParticleSystems.Grass(%d)", i);
		local node = getXMLString(xmlFile, key.. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key.. "#file");
			local grassParticleSystem = {};
			grassParticleSystem.particleSystem = {};
			StaticParticleSystem.loadParticleSystem(xmlFile, grassParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.grassParticleSystems, grassParticleSystem);
		end;
		i = i+1;
	end;
	
	self.dryGrassParticleSystems = {};
	local i=0;
	while true do
		local key = string.format("vehicle.KronePickupParticleSystems.dryGrass(%d)", i);
		local node = getXMLString(xmlFile, key.. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key.. "#file");
			local dryGrassParticleSystem = {};
			dryGrassParticleSystem.particleSystem = {};
			StaticParticleSystem.loadParticleSystem(xmlFile, dryGrassParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.dryGrassParticleSystems, dryGrassParticleSystem);
		end;
		i = i+1;
	end;
	
	self.previousLevel = self.fillLevel;
	self.pickUpAktiv = false;
	self.grassPickUpPs = false;
	self.dryGrassPickUpPs = false;
	self.strawPickUpPs = false;
end;

function  KronePickupParticleSystems:delete()
	for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
		Utils.setEmittingState(wheatParticleSystem.particleSystem, false);
	end;
	for k, grassParticleSystem in pairs(self.grassParticleSystems) do
		Utils.setEmittingState(grassParticleSystem.particleSystem, false);
	end;
	for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
		Utils.setEmittingState(dryGrassParticleSystem.particleSystem, false);
	end;
end;

function  KronePickupParticleSystems:mouseEvent(posX, posY, isDown, isUp, button)
end;

function  KronePickupParticleSystems:keyEvent(unicode, sym, modifier, isDown)
end;

function  KronePickupParticleSystems:updateTick(dt)
	if self:getIsActive() then -- Gert am Trecker angekoppelt und Spieler im Trecker
		if self.lastSpeedReal > 5/3600 then -- Fahrtrichtung nach vorn ist ger als ~5 km/h - Kleiner Trick um zuverhindern, dass das Particlesystem erzeugt wird, wenn man einen Ladewagen von oben befllt, (Radlader, Frderband an einem Futterlager oder hnlichem), und dieser angeschaltet ist
			if self.previousLevel ~= self.fillLevel then -- vorheriger Fllstand ist anders als aktueller Fllstand
				if self.previousLevel < self.fillLevel then -- vorheriger Fllstand ist kleiner als aktueller Fllstand
					if self.isTurnedOn then -- Gert ist angeschalten
						self.pickUpAktiv = true; -- Wenn alle vorherigen Abfragen zustimmen, ist self.pickUpAktiv 'true'
					else
						self.pickUpAktiv = false; -- sonst 'false'
					end;
				else
					self.pickUpAktiv = false; -- sonst 'false'
				end;
				self.previousLevel = self.fillLevel;
			else
				self.pickUpAktiv = false; -- sonst 'false'
			end;
		else
			self.pickUpAktiv = false; -- sonst 'false'
		end;
	else
		self.pickUpAktiv = false; -- sonst 'false'
	end;
end;

function  KronePickupParticleSystems:update(dt)
	if self.pickUpAktiv then -- Abfrage ob self.pickUpAktiv 'true' ist
		if (self.currentFillType == Fillable.FILLTYPE_WHEAT_WINDROW or self.currentFillType == Fillable.FILLTYPE_BARLEY_WINDROW) then -- Abfrage ob Weizen oder Gestrenstroh geladen ist
			self.strawPickUpPs = true; -- Wenn vorherige Abfrage zustimmt, ist self.strawPickUpPs 'true'
		else
			self.strawPickUpPs = false; -- sonst 'false'
		end;
		if (self.currentFillType == Fillable.FILLTYPE_GRASS_WINDROW) then -- Abfrage ob Grasschwad geladen ist
			self.grassPickUpPs = true; -- Wenn vorherige Abfrage zustimmt, ist self.grassPickUpPs 'true'
		else
			self.grassPickUpPs = false; -- sonst 'false'
		end;
		if (self.currentFillType == Fillable.FILLTYPE_DRYGRASS_WINDROW) then -- Abfrage ob Heuschwad geladen ist (Das ist eigendlich nur bei Pressen der Fall [Ausgehend von den Standardsachen versteht sich.. Gut mglich das es Ladewagen als Mod gibt, die das Heu nicht in Gras umwandelt..])
			self.dryGrassPickUpPs = true; -- Wenn vorherige Abfrage zustimmt, ist self.dryGrassPickUpPs 'true'
		else
			self.dryGrassPickUpPs = false; -- sonst 'false'
		end;
	else -- self.pickUpAktiv ist 'false'
		self.strawPickUpPs = false;
		self.grassPickUpPs = false;
		self.dryGrassPickUpPs = false;
	end;
	
	for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
		Utils.setEmittingState(wheatParticleSystem.particleSystem, self.strawPickUpPs); -- Wenn self.strawPickUpPs 'true' ist, dann wird dieses ParticleSystem erzeugt.
	end;
	for k, grassParticleSystem in pairs(self.grassParticleSystems) do
		Utils.setEmittingState(grassParticleSystem.particleSystem, self.grassPickUpPs); -- Wenn self.grassPickUpPs 'true' ist, dann wird dieses ParticleSystem erzeugt.
	end;
	for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
		Utils.setEmittingState(dryGrassParticleSystem.particleSystem, self.dryGrassPickUpPs); -- Wenn self.dryGrassPickUpPs 'true' ist, dann wird dieses ParticleSystem erzeugt.
	end;
end;
	
function  KronePickupParticleSystems:draw()
end;

-------------------------------------------------------------------------------------------------------------------------------------
-- StaticParticleSystem fr die KronePickupParticleSystems

StaticParticleSystem = {};

function StaticParticleSystem.loadParticleSystem(xmlFile, particleSystemTable, baseString, component, currentEmittingState, defaultParticleSystem, directory)
	local defaultLinkNode = component;
	local isStatic = Utils.getNoNil(isStaticParticle, false);
	local posStr = getXMLString(xmlFile, baseString .. "#position");
    local rotStr = getXMLString(xmlFile, baseString .. "#rotation");
	if type(component) == "table" then
		defaultLinkNode = component[1].node;
	end;
	local linkNode = Utils.getNoNil(Utils.indexToObject(component, getXMLString(xmlFile, baseString .. "#node")), defaultLinkNode);
	local psFile = getXMLString(xmlFile, baseString .. "#file");
	if psFile == nil then
		psFile = defaultParticleSystem;
	end
	if psFile == nil then
		return;
	end
	psFile = Utils.getFilename(psFile, directory);
	local rootNode = loadI3DFile(psFile);
	if rootNode == 0 then
		print("[ERROR der PickupParticleSystems.lua]: Das ParticleSystem '"..psFile.."' konnte nicht geladen werden. Dieses ParticleSystem ist daher inakiv.");
		return;
	end
	link(linkNode, rootNode);
	if posStr ~= nil and rotStr ~= nil then
		local posX, posY, posZ = Utils.getVectorFromString(posStr);
		local rotX, rotY, rotZ = Utils.getVectorFromString(rotStr);
		if posStr ~= nil and rotStr ~= nil then
			rotX = Utils.degToRad(rotX);
			rotY = Utils.degToRad(rotY);
			rotZ = Utils.degToRad(rotZ);
			setTranslation(rootNode, posX, posY, posZ);
			setRotation(rootNode, rotX, rotY, rotZ);
		end;
	end;
	for i=0, getNumOfChildren(rootNode)-1 do
		local child = getChildAt(rootNode, i);
		if getClassName(child) == "Shape" then
			local geometry = getGeometry(child);
			if geometry ~= 0 then
				if getClassName(geometry) == "ParticleSystem" then
					table.insert(particleSystemTable, {geometry = geometry, shape = child});
					if currentEmittingState ~= nil then
						setEmittingState(geometry, currentEmittingState);
					end;
				end;
			end;
		end;
	end;
	return rootNode;
end;