--[[

|=================================================|
|-------------------------------------------------|
|---------------Script do Unia Ares---------------|
|-----------------by maciusboss1------------------|
|----------------Skrypt BY Burner-----------------|
|----------------Data: 10.08.2013-----------------|
|-------------------M & B Team--------------------|
|--------------------No Edit!!!-------------------|
|-------------------------------------------------|
|=================================================|

]]--

UniaAres = {};

function UniaAres.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Cultivator, specializations);
end;

function UniaAres:load(xmlFile)
	self.jointRotLimit = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.jointRotLimit#index"));
	self.onSetLowered = Utils.appendedFunction(self.onSetLowered, UniaAres.onSetLowered);
	self.attachedObjectMass = {}
	self.extraSpeedRotatingParts = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.extraSpeedRotatingParts.extraSpeedRotatingPart(%d)", i);
		local index = getXMLString(xmlFile, baseName.. "#index");
		if index == nil then
			break;
		end;
		local node = Utils.indexToObject(self.components, index);
		if node ~= nil then
			local entry = {};
			entry.node = node;
			entry.rotationSpeedScale = getXMLFloat(xmlFile, baseName.."#rotationSpeedScale");
			if entry.rotationSpeedScale == nil then
				entry.rotationSpeedScale = 1.0/Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#radius"), 1);
			end;
			entry.foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMinLimit"), 0);
			entry.foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMaxLimit"), 1);
			table.insert(self.extraSpeedRotatingParts, entry);
		end;
		i = i+1;
	end;
end;

function UniaAres:delete()
end;

function UniaAres:readStream(streamId, connection)
end;

function UniaAres:writeStream(streamId, connection)
end;

function UniaAres:readUpdateStream(streamId, timestamp, connection)
end;

function UniaAres:writeUpdateStream(streamId, connection, dirtyMask)
end;

function UniaAres:mouseEvent(posX, posY, isDown, isUp, button)
end;

function UniaAres:keyEvent(unicode, sym, modifier, isDown)
end;

function UniaAres:update(dt)
	if self.jointRotLimit ~= nil and table.getn(self.attachedImplements) > 0 then
		local x,y,z = getRotation(self.jointRotLimit);
		self:setComponentJointRotLimit(self.componentJoints[3], 1, x);
	end;
end;

function UniaAres:updateTick(dt)
	if table.getn(self.attachedImplements) > 0 then
		local hasGroundContact = self.cultivatorHasGroundContact;
		local doGroundManipulation = (hasGroundContact and (not self.onlyActiveWhenLowered or self:isLowered(false)) and self.startActivationTime <= self.time);
		local implement = self.attachedImplements[1];
		local object = implement.object;
		if object.needsActivation then
			object.isTurnedOn = doGroundManipulation;
		end;
		self.attacherJoints[1].moveDown = doGroundManipulation;
		setVisibility(self.attacherJoints[1].topArm.rotationNode, true)
	else
		setVisibility(self.attacherJoints[1].topArm.rotationNode, false)
	end
	for k,v in pairs(self.extraSpeedRotatingParts) do
		rotate(v.node, v.rotationSpeedScale * self.lastSpeedReal * self.movingDirection * dt, 0, 0);
	end;
end;

function UniaAres:draw()
end;

function UniaAres:onAttach(attacherVehicle)
end;

function UniaAres:attachImplement(implement)
	local object = implement.object
	for k,v in pairs(object.components) do
		self.attachedObjectMass[k] = getMass(object.components[k].node);
		setMass(object.components[k].node, self.attachedObjectMass[k]/4);
	end;
end

function UniaAres:detachImplement(implementIndex)
	local object = self.attachedImplements[implementIndex].object;
	for k,v in pairs(object.components) do
		setMass(object.components[k].node, self.attachedObjectMass[k]);
	end;
	self:setComponentJointRotLimit(self.componentJoints[3], 1, 0);
	self.attachedObject = {};
end;

function UniaAres:onSetLowered(lowered)
end;

function UniaAres:onDetach()
end;

function UniaAres:onLeave()
end;

function UniaAres:onDeactivate()
end;