

dt75 = {};

function dt75.prerequisitesPresent(specializations)
    Vehicle.registerJointType("tractor");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function dt75:load(xmlFile)

      self.thenlight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.thenlight#index"));
      self.thenlightActive = false;

-- door

local rotationPartNoderightdoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rightdoor#index"));
    if rotationPartNoderightdoor ~= nil then
        self.rotationPartrightdoor = {};
        self.rotationPartrightdoor.node = rotationPartNoderightdoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#minRot"));
        self.rotationPartrightdoor.minRot = {};
        self.rotationPartrightdoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#maxRot"));
        self.rotationPartrightdoor.maxRot = {};
        self.rotationPartrightdoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrightdoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#rotTime"), 2)*1000;
        self.rotationPartrightdoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#touchRotLimit"), 10));
    end;
	local rotationPartNodeleftDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.leftDoor#index"));
    if rotationPartNodeleftDoor ~= nil then
        self.rotationPartleftDoor = {};
        self.rotationPartleftDoor.node = rotationPartNodeleftDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#minRot"));
        self.rotationPartleftDoor.minRot = {};
        self.rotationPartleftDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#maxRot"));
        self.rotationPartleftDoor.maxRot = {};
        self.rotationPartleftDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleftDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#rotTime"), 2)*1000;
        self.rotationPartleftDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#touchRotLimit"), 10));
    end;
	local rotationPartNodekozyrek = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kozyrek#index"));
    if rotationPartNodekozyrek ~= nil then
        self.rotationPartkozyrek = {};
        self.rotationPartkozyrek.node = rotationPartNodekozyrek;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kozyrek#minRot"));
        self.rotationPartkozyrek.minRot = {};
        self.rotationPartkozyrek.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkozyrek.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkozyrek.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kozyrek#maxRot"));
        self.rotationPartkozyrek.maxRot = {};
        self.rotationPartkozyrek.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkozyrek.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkozyrek.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartkozyrek.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kozyrek#rotTime"), 2)*1000;
        self.rotationPartkozyrek.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.kozyrek#touchRotLimit"), 10));
    end;
	local translationPartNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;
    local translationPartNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translationPart2#index"));
    if translationPartNode2 ~= nil then
        self.translationPart2 = {};
        self.translationPart2.node = translationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#minTrans"));
        self.translationPart2.minTrans = {};
        self.translationPart2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#maxTrans"));
        self.translationPart2.maxTrans = {};
        self.translationPart2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#transTime"), 2)*1000;
        self.translationPart2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#touchTransLimit"), 10);
    end;

-- tahometr

	local rotationPartNodeTahometr = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartTahometr#index"));
    if rotationPartNodeTahometr ~= nil then
        self.rotationPartTahometr = {};
        self.rotationPartTahometr.node = rotationPartNodeTahometr;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTahometr#minRot"));
        self.rotationPartTahometr.minRot = {};
        self.rotationPartTahometr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTahometr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTahometr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTahometr#maxRot"));
        self.rotationPartTahometr.maxRot = {};
        self.rotationPartTahometr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTahometr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTahometr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTahometr.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTahometr#rotTime"), 2)*1000;
        self.rotationPartTahometr.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTahometr#touchRotLimit"), 10));
    end;

-- toplivo

	local rotationPartNodeTanknadel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;

-- voda

local rotationPartNodevoda1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda1#index"));
    if rotationPartNodevoda1 ~= nil then
        self.rotationPartvoda1 = {};
        self.rotationPartvoda1.node = rotationPartNodevoda1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda1#minRot"));
        self.rotationPartvoda1.minRot = {};
        self.rotationPartvoda1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda1#maxRot"));
        self.rotationPartvoda1.maxRot = {};
        self.rotationPartvoda1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda1#rotTime"), 2)*1000;
        self.rotationPartvoda1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda1#touchRotLimit"), 10));
    end;
local rotationPartNodevoda2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda2#index"));
    if rotationPartNodevoda2 ~= nil then
        self.rotationPartvoda2 = {};
        self.rotationPartvoda2.node = rotationPartNodevoda2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda2#minRot"));
        self.rotationPartvoda2.minRot = {};
        self.rotationPartvoda2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda2#maxRot"));
        self.rotationPartvoda2.maxRot = {};
        self.rotationPartvoda2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda2#rotTime"), 2)*1000;
        self.rotationPartvoda2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda2#touchRotLimit"), 10));
    end;
local rotationPartNodevoda3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda3#index"));
    if rotationPartNodevoda3 ~= nil then
        self.rotationPartvoda3 = {};
        self.rotationPartvoda3.node = rotationPartNodevoda3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda3#minRot"));
        self.rotationPartvoda3.minRot = {};
        self.rotationPartvoda3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda3#maxRot"));
        self.rotationPartvoda3.maxRot = {};
        self.rotationPartvoda3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda3#rotTime"), 2)*1000;
        self.rotationPartvoda3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda3#touchRotLimit"), 10));
    end;
local rotationPartNodevoda4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda4#index"));
    if rotationPartNodevoda4 ~= nil then
        self.rotationPartvoda4 = {};
        self.rotationPartvoda4.node = rotationPartNodevoda4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda4#minRot"));
        self.rotationPartvoda4.minRot = {};
        self.rotationPartvoda4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda4#maxRot"));
        self.rotationPartvoda4.maxRot = {};
        self.rotationPartvoda4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda4#rotTime"), 2)*1000;
        self.rotationPartvoda4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda4#touchRotLimit"), 10));
    end;
local rotationPartNodevoda5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda5#index"));
    if rotationPartNodevoda5 ~= nil then
        self.rotationPartvoda5 = {};
        self.rotationPartvoda5.node = rotationPartNodevoda5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda5#minRot"));
        self.rotationPartvoda5.minRot = {};
        self.rotationPartvoda5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda5#maxRot"));
        self.rotationPartvoda5.maxRot = {};
        self.rotationPartvoda5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda5#rotTime"), 2)*1000;
        self.rotationPartvoda5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda5#touchRotLimit"), 10));
    end;
local rotationPartNodevoda6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda6#index"));
    if rotationPartNodevoda6 ~= nil then
        self.rotationPartvoda6 = {};
        self.rotationPartvoda6.node = rotationPartNodevoda6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda6#minRot"));
        self.rotationPartvoda6.minRot = {};
        self.rotationPartvoda6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda6#maxRot"));
        self.rotationPartvoda6.maxRot = {};
        self.rotationPartvoda6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda6#rotTime"), 2)*1000;
        self.rotationPartvoda6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda6#touchRotLimit"), 10));
    end;

--ampermetr

local rotationPartNodeamper1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper1#index"));
    if rotationPartNodeamper1 ~= nil then
        self.rotationPartamper1 = {};
        self.rotationPartamper1.node = rotationPartNodeamper1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper1#minRot"));
        self.rotationPartamper1.minRot = {};
        self.rotationPartamper1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper1#maxRot"));
        self.rotationPartamper1.maxRot = {};
        self.rotationPartamper1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper1#rotTime"), 2)*1000;
        self.rotationPartamper1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper1#touchRotLimit"), 10));
    end;
local rotationPartNodeamper2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper2#index"));
    if rotationPartNodeamper2 ~= nil then
        self.rotationPartamper2 = {};
        self.rotationPartamper2.node = rotationPartNodeamper2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper2#minRot"));
        self.rotationPartamper2.minRot = {};
        self.rotationPartamper2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper2#maxRot"));
        self.rotationPartamper2.maxRot = {};
        self.rotationPartamper2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper2#rotTime"), 2)*1000;
        self.rotationPartamper2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper2#touchRotLimit"), 10));
    end;
local rotationPartNodeamper3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper3#index"));
    if rotationPartNodeamper3 ~= nil then
        self.rotationPartamper3 = {};
        self.rotationPartamper3.node = rotationPartNodeamper3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper3#minRot"));
        self.rotationPartamper3.minRot = {};
        self.rotationPartamper3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper3#maxRot"));
        self.rotationPartamper3.maxRot = {};
        self.rotationPartamper3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper3#rotTime"), 2)*1000;
        self.rotationPartamper3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper3#touchRotLimit"), 10));
    end;
local rotationPartNodeamper4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper4#index"));
    if rotationPartNodeamper4 ~= nil then
        self.rotationPartamper4 = {};
        self.rotationPartamper4.node = rotationPartNodeamper4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper4#minRot"));
        self.rotationPartamper4.minRot = {};
        self.rotationPartamper4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper4#maxRot"));
        self.rotationPartamper4.maxRot = {};
        self.rotationPartamper4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper4#rotTime"), 2)*1000;
        self.rotationPartamper4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper4#touchRotLimit"), 10));
    end;
local rotationPartNodeamper5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper5#index"));
    if rotationPartNodeamper5 ~= nil then
        self.rotationPartamper5 = {};
        self.rotationPartamper5.node = rotationPartNodeamper5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper5#minRot"));
        self.rotationPartamper5.minRot = {};
        self.rotationPartamper5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper5#maxRot"));
        self.rotationPartamper5.maxRot = {};
        self.rotationPartamper5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper5#rotTime"), 2)*1000;
        self.rotationPartamper5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper5#touchRotLimit"), 10));
    end;
local rotationPartNodeamper6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper6#index"));
    if rotationPartNodeamper6 ~= nil then
        self.rotationPartamper6 = {};
        self.rotationPartamper6.node = rotationPartNodeamper6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper6#minRot"));
        self.rotationPartamper6.minRot = {};
        self.rotationPartamper6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper6#maxRot"));
        self.rotationPartamper6.maxRot = {};
        self.rotationPartamper6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper6#rotTime"), 2)*1000;
        self.rotationPartamper6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper6#touchRotLimit"), 10));
    end;

-- Wiper

	self.wiper1Active = false;
    self.wiper2Active = false;
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayWischer1 = 0;
    self.delayWischer2 = 0;
    self.delayOn = 0;
    self.delayOff = 0;
    self.deltafo = 0;
	local wiper1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper1#index"));
    if wiper1Node ~= nil then
        self.wiper1 = {};
        self.wiper1.node = wiper1Node;
    local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wiper1#minRot"));
        self.wiper1.minRot = {};
        self.wiper1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wiper1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wiper1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wiper1#maxRot"));
        self.wiper1.maxRot = {};
        self.wiper1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wiper1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wiper1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.wiper1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wiper1#rotTime"), 2)*1000;
        self.wiper1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.wiper1#touchRotLimit"), 10));
    end;

	local wiper2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper2#index"));
    if wiper2Node ~= nil then
        self.wiper2 = {};
        self.wiper2.node = wiper2Node;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wiper2#minRot"));
        self.wiper2.minRot = {};
        self.wiper2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wiper2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wiper2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wiper2#maxRot"));
        self.wiper2.maxRot = {};
        self.wiper2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wiper2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wiper2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.wiper2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wiper2#rotTime"), 2)*1000;
        self.wiper2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.wiper2#touchRotLimit"), 10));
    end;
	self.movingFlag = self:getNextDirtyFlag();
end;

function dt75:delete()
end;

function dt75:mouseEvent(posX, posY, isDown, isUp, button)
end;

function dt75:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_KP_0 then
		self.helpPanel = not self.helpPanel;
	end;
    if isDown and sym == Input.KEY_KP_9 then
		if self.isServer then
			self.rotationMaxrightdoor = not self.rotationMaxrightdoor;
			self:raiseDirtyFlags(self.movingFlag);
		else
			g_client:getServerConnection():sendEvent(dt75Event:new(9, self));
		end;
    end;
	if isDown and sym == Input.KEY_KP_7 then
		if self.isServer then
			self.rotationMaxleftDoor = not self.rotationMaxleftDoor;
			self:raiseDirtyFlags(self.movingFlag);
		else
			g_client:getServerConnection():sendEvent(dt75Event:new(7, self));
		end;
    end;
	if isDown and sym == Input.KEY_KP_8 then
		if self.isServer then
			self.rotationMaxkozyrek = not self.rotationMaxkozyrek;
			self:raiseDirtyFlags(self.movingFlag);
		else
			g_client:getServerConnection():sendEvent(dt75Event:new(5, self));
		end;
    end;
     if isDown and sym == Input.KEY_KP_divide then
		if self.isServer then
			self.wiper1Active = not self.wiper1Active;
			self.wiper2Active = not self.wiper2Active;
			self:raiseDirtyFlags(self.movingFlag);
		else
			g_client:getServerConnection():sendEvent(dt75Event:new(1, self));
		end;
	 end;
	if isDown and sym == Input.KEY_KP_4 then
		if self.isServer then
			self.translationMax = not self.translationMax;
			self:raiseDirtyFlags(self.movingFlag);
		else
			g_client:getServerConnection():sendEvent(dt75Event:new(4, self));
		end;
    end;
	if isDown and sym == Input.KEY_KP_5 then
		if self.isServer then
			self.translationMax2 = not self.translationMax2;
			self:raiseDirtyFlags(self.movingFlag);
		else
			g_client:getServerConnection():sendEvent(dt75Event:new(5, self));
		end;
    end;
end;

function dt75:readUpdateStream(streamId, timestamp, connection)
	if connection:getIsServer() then
		self.rotationMaxrightdoor = streamReadBool(streamId);
		self.rotationMaxleftDoor = streamReadBool(streamId);
		self.rotationMaxkozyrek = streamReadBool(streamId);
		self.wiper1Active = streamReadBool(streamId);
		self.wiper2Active = streamReadBool(streamId);
		self.translationMax = streamReadBool(streamId);
		self.translationMax2 = streamReadBool(streamId);
	end;
end;

function dt75:writeUpdateStream(streamId, connection, dirtyMask)
	if not connection:getIsServer() then
		streamWriteBool(streamId, self.rotationMaxrightdoor);
		streamWriteBool(streamId, self.rotationMaxleftDoor);
		streamWriteBool(streamId, self.rotationMaxkozyrek);
		streamWriteBool(streamId, self.wiper1Active);
		streamWriteBool(streamId, self.wiper2Active);
		streamWriteBool(streamId, self.translationMax);
		streamWriteBool(streamId, self.translationMax2);
	end;
end;

function dt75:update(dt)

--other to motor started

if self.isMotorStarted then
self.rotationMaxvoda1 = true;
self.rotationMaxvoda2 = false;
self.rotationMaxvoda3 = true;
self.rotationMaxvoda4 = false;
self.rotationMaxvoda5 = true;
self.rotationMaxvoda6 = false;
self.rotationMaxamper1 = true;
self.rotationMaxamper2 = true;
self.rotationMaxamper3 = true;
self.rotationMaxamper4 = false;
self.rotationMaxamper5 = false;
self.rotationMaxamper6 = false;
         else
self.rotationMaxvoda1 = false;
self.rotationMaxvoda2 = true;
self.rotationMaxvoda3 = false;
self.rotationMaxvoda4 = true;
self.rotationMaxvoda5 = false;
self.rotationMaxvoda6 = true;
self.rotationMaxamper1 = false;
self.rotationMaxamper2 = false;
self.rotationMaxamper3 = false;
self.rotationMaxamper4 = true;
self.rotationMaxamper5 = true;
self.rotationMaxamper6 = true;
end;

-- door

        if self.rotationPartrightdoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartrightdoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrightdoor.maxRot, self.rotationPartrightdoor.minRot, 3, self.rotationPartrightdoor.rotTime, dt, not self.rotationMaxrightdoor);
		   setRotation(self.rotationPartrightdoor.node, unpack(newRot));
        end;
		if self.rotationPartleftDoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartleftDoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleftDoor.maxRot, self.rotationPartleftDoor.minRot, 3, self.rotationPartleftDoor.rotTime, dt, not self.rotationMaxleftDoor);
		   setRotation(self.rotationPartleftDoor.node, unpack(newRot));
        end;
		if self.rotationPartkozyrek ~= nil then
		   local x, y, z = getRotation(self.rotationPartkozyrek.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartkozyrek.maxRot, self.rotationPartkozyrek.minRot, 3, self.rotationPartkozyrek.rotTime, dt, not self.rotationMaxkozyrek);
		   setRotation(self.rotationPartkozyrek.node, unpack(newRot));
        end;
	if self.translationPart ~= nil then
		local x, y, z = getTranslation(self.translationPart.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax);
		setTranslation(self.translationPart.node, unpack(newTrans));
	end;
	if self.translationPart2 ~= nil then
		local x, y, z = getTranslation(self.translationPart2.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart2.maxTrans, self.translationPart2.minTrans, 3, self.translationPart2.transTime, dt, not self.translationMax2);
		setTranslation(self.translationPart2.node, unpack(newTrans));
	end;

-- tahometr

		local maxDrehzahl = 1300;
	if self.rotationPartTahometr ~= nil then
		local x, y, z = getRotation(self.rotationPartTahometr.node);
		y = ((self.rotationPartTahometr.maxRot[2] - self.rotationPartTahometr.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartTahometr.minRot[2];
		setRotation(self.rotationPartTahometr.node, x, y ,z);
	end;

-- toplivo

	if self.rotationPartTanknadel ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel.node);
		y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
		setRotation(self.rotationPartTanknadel.node, x, y ,z);
	end;

-- voda

if self.rotationMaxvoda1 == true then
if self.rotationPartvoda1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda1.maxRot, self.rotationPartvoda1.minRot, 3, self.rotationPartvoda1.rotTime, dt, not self.rotationMaxvoda1);
		   setRotation(self.rotationPartvoda1.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda2 == true then
if self.rotationPartvoda2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda2.maxRot, self.rotationPartvoda2.minRot, 3, self.rotationPartvoda2.rotTime, dt, not self.rotationMaxvoda2);
		   setRotation(self.rotationPartvoda2.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda3 == true then
if self.rotationPartvoda3 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda3.maxRot, self.rotationPartvoda3.minRot, 3, self.rotationPartvoda3.rotTime, dt, not self.rotationMaxvoda3);
		   setRotation(self.rotationPartvoda3.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda4 == true then
if self.rotationPartvoda4 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda4.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda4.maxRot, self.rotationPartvoda4.minRot, 3, self.rotationPartvoda4.rotTime, dt, not self.rotationMaxvoda4);
		   setRotation(self.rotationPartvoda4.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda5 == true then
if self.rotationPartvoda5 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda5.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda5.maxRot, self.rotationPartvoda5.minRot, 3, self.rotationPartvoda5.rotTime, dt, not self.rotationMaxvoda5);
		   setRotation(self.rotationPartvoda5.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda6 == true then
if self.rotationPartvoda6 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda6.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda6.maxRot, self.rotationPartvoda6.minRot, 3, self.rotationPartvoda6.rotTime, dt, not self.rotationMaxvoda6);
		   setRotation(self.rotationPartvoda6.node, unpack(newRot));
       end;
   end;

-- ampermetr

if self.rotationMaxamper1 == true then
if self.rotationPartamper1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper1.maxRot, self.rotationPartamper1.minRot, 3, self.rotationPartamper1.rotTime, dt, not self.rotationMaxamper1);
		   setRotation(self.rotationPartamper1.node, unpack(newRot));
       end;
   end;
if self.rotationMaxamper2 == true then
if self.rotationPartamper2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper2.maxRot, self.rotationPartamper2.minRot, 3, self.rotationPartamper2.rotTime, dt, not self.rotationMaxamper2);
		   setRotation(self.rotationPartamper2.node, unpack(newRot));
       end;
   end;
if self.rotationMaxamper3 == true then
if self.rotationPartamper3 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper3.maxRot, self.rotationPartamper3.minRot, 3, self.rotationPartamper3.rotTime, dt, not self.rotationMaxamper3);
		   setRotation(self.rotationPartamper3.node, unpack(newRot));
       end;
   end;
if self.rotationMaxamper4 == true then
if self.rotationPartamper4 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper4.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper4.maxRot, self.rotationPartamper4.minRot, 3, self.rotationPartamper4.rotTime, dt, not self.rotationMaxamper4);
		   setRotation(self.rotationPartamper4.node, unpack(newRot));
       end;
   end;
if self.rotationMaxamper5 == true then
if self.rotationPartamper5 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper5.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper5.maxRot, self.rotationPartamper5.minRot, 3, self.rotationPartamper5.rotTime, dt, not self.rotationMaxamper5);
		   setRotation(self.rotationPartamper5.node, unpack(newRot));
       end;
   end;
if self.rotationMaxamper6 == true then
if self.rotationPartamper6 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper6.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper6.maxRot, self.rotationPartamper6.minRot, 3, self.rotationPartamper6.rotTime, dt, not self.rotationMaxamper6);
		   setRotation(self.rotationPartamper6.node, unpack(newRot));
       end;
   end;

-- Wiper

        if self.wiper1Active then
		if self.delayWischer1 >= 0 then
			self.delayWischer1 = self.delayWischer1 -dt;
		end;
		if self.delayWischer2 >= 0 then
			self.delayWischer2 = self.delayWischer2 -dt;
		end;
		if not self.wiper1Max then
		   if self.delayWischer1 < 0 then
				self.delayWischer2 = 1000;
				self.wiper1Max = true;
				self.wiper2Max = true;
			end;
		end;
		if self.wiper1Max then
			if self.delayWischer2 < 0 then
				self.delayWischer1 = 1000;
				self.wiper1Max = false;
				self.wiper2Max = false;
			end;
		end;
	else
		self.wiper1Max = false;
		self.wiper2Max = false;
	end;

    if self.wiper1 ~= nil then
       	local x, y, z = getRotation(self.wiper1.node);
       	local rot = {x,y,z};
       	local newRot = Utils.getMovedLimitedValues(rot, self.wiper1.maxRot, self.wiper1.minRot, 3, self.wiper1.rotTime, dt, not self.wiper1Max);
       	setRotation(self.wiper1.node, unpack(newRot));
    end;

	if self.wiper2 ~= nil then
       	local x, y, z = getRotation(self.wiper2.node);
       	local rot = {x,y,z};
       	local newRot = Utils.getMovedLimitedValues(rot, self.wiper2.maxRot, self.wiper2.minRot, 3, self.wiper2.rotTime, dt, not self.wiper2Max);
       	setRotation(self.wiper2.node, unpack(newRot));
    end;
end;

function dt75:draw()

	if not self.helpPanel then
			g_currentMission:addExtraPrintText(g_i18n:getText("Info_ON"));
		else
			g_currentMission:addExtraPrintText(g_i18n:getText("Info_OFF"));
			g_currentMission:addExtraPrintText(g_i18n:getText("Lev_dver"));
			g_currentMission:addExtraPrintText(g_i18n:getText("Prav_dver"));
			g_currentMission:addExtraPrintText(g_i18n:getText("Lev_okno"));
			g_currentMission:addExtraPrintText(g_i18n:getText("Prav_okno"));
			g_currentMission:addExtraPrintText(g_i18n:getText("Wiper"));
		end;
		if self.helpPanel then
			--renderText(0.84, 0.60, 0.018, g_i18n:getText("Info_avto"));
		      --        renderText(0.82, 0.56, 0.015, g_i18n:getText("Lev_dver"));
		        --      renderText(0.82, 0.54, 0.015, g_i18n:getText("Prav_dver"));
		          --    renderText(0.82, 0.52, 0.015, g_i18n:getText("Lev_okno"));
		            --  renderText(0.82, 0.50, 0.015, g_i18n:getText("Prav_okno"));
		              --renderText(0.82, 0.48, 0.015, g_i18n:getText("Wiper"));
					  --renderText(0.82, 0.46, 0.015, g_i18n:getText("Zerkala"));
	end;
end;

function dt75:onEnter()
end;

function dt75:onLeave()
end;

function dt75:attachImplement(implement)

	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;

	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if jointIndex == 1 then
	setVisibility(self.thenlight, self.thenlightActive);
	self.thenlightActive = true;
    else
    setVisibility(self.thenlight, self.thenlightActive);
	self.thenlightActive = false;
	end;
   end;
end;

function dt75:detachImplement(implementIndex)

	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;

	if jointIndex == 1 then
	setVisibility(self.thenlight, self.thenlightActive);
	self.thenlightActive = false;
	end;
end;

function dt75:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;


dt75Event = {};
dt75Event_mt = Class(dt75Event, Event);

InitEventClass(dt75Event, "dt75Event");

function dt75Event:emptyNew()
	local self = Event:new(dt75Event_mt);
	print("emptyNew");
    return self;
end;

function dt75Event:new(numKey, object)
	local self = dt75Event:emptyNew();
	self.numKey = numKey;
	self.object = object;
	return self;
end;

function dt75Event:readStream(streamId, connection)
	local numKey = streamReadInt8(streamId);
	local id = streamReadInt32(streamId);
    local object = networkGetObject(id);
	if object ~= nil then
		if numKey == 9 then object.rotationMaxrightdoor = not object.rotationMaxrightdoor; end;
		if numKey == 7 then object.rotationMaxleftDoor = not object.rotationMaxleftDoor; end;
		if numKey == 8 then object.rotationMaxkozyrek = not object.rotationMaxkozyrek; end;
		if numKey == 1 then object.wiper1Active = not object.wiper1Active; object.wiper2Active = not object.wiper2Active; end;
		if numKey == 4 then object.translationMax = not object.translationMax; end;
		if numKey == 5 then object.translationMax2 = not object.translationMax2; end;
	end;
end;

function dt75Event:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.numKey);
	streamWriteInt32(streamId, networkGetObjectId(self.object));
end;
