--
-- Trac Anim
--


TracAnim = {};


function TracAnim.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function TracAnim:load(xmlFile)

	self.numTrackWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.TrackWheels#count"), 0);
    self.Tracks = {};
    for i=1, self.numTrackWheels do
        local Tracksnamei = string.format("vehicle.TrackWheels.TTWheel" .. "%d", i);
        self.Tracks[i] = {};
		self.Tracks[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, Tracksnamei .. "#index"));
		self.Tracks[i].refWheel = Utils.getNoNil(getXMLInt(xmlFile,  Tracksnamei .. "#referenceWheel"), 1);
		self.Tracks[i].different = Utils.getNoNil(getXMLFloat(xmlFile,  Tracksnamei .. "#differentRatio"), 1);
    end;

	self.charIdAnim = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animTracLeft#Node"));
	self.clipIndexAnim = getXMLString(xmlFile, "vehicle.animTracLeft#animationClip");

	self.charIdAnim1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animTracRight#Node"));
	self.clipIndexAnim1 = getXMLString(xmlFile, "vehicle.animTracRight#animationClip");

	self.spedTracLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spedTracLeft#index"));
	self.spedTracRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spedTracRight#index"));

		self.charId = getAnimCharacterSet(self.charIdAnim);
		local clipIndex = getAnimClipIndex(self.charId, self.clipIndexAnim);
		assignAnimTrackClip(self.charId , 0, clipIndex);
		setAnimTrackLoopState(self.charId, 0, true);

		self.charId1 = getAnimCharacterSet(self.charIdAnim1);
		local clipIndex1 = getAnimClipIndex(self.charId1, self.clipIndexAnim1);
		assignAnimTrackClip(self.charId1 , 0, clipIndex1);
		setAnimTrackLoopState(self.charId1, 0, true);

	self.lastTranslation1 = nil; -- = {0,0,0};
	self.lastSpeedReal1 = 0;
	self.lastMovedDistance1 = 0;
	self.speedDisplayDt1 = 0;
	self.movingDirection1 = 0;
	self.speedDisplayScale1 = 1;

	self.lastTranslation2 = nil; -- = {0,0,0};
	self.lastSpeedReal2 = 0;
	self.lastMovedDistance2 = 0;
	self.speedDisplayDt2 = 0;
	self.movingDirection2 = 0;
	self.speedDisplayScale2 = 1;
	self.lastRot,_,_ = getRotation(self.wheels[1].repr);
end;

function TracAnim:delete()
end;

function TracAnim:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TracAnim:keyEvent(unicode, sym, modifier, isDown)
end;

function TracAnim:update(dt)
	self.speedDisplayDt1 = self.speedDisplayDt1 + dt;
	if self.speedDisplayDt1 > 100 then
		local newX1, newY1, newZ1 = getWorldTranslation(self.spedTracLeft);
		if self.lastTranslation1 == nil then
			self.lastTranslation1 = {newX1, newY1, newZ1};
		end;
		local dx1, dy1, dz1 = worldDirectionToLocal(self.spedTracLeft, newX1-self.lastTranslation1[1], newY1-self.lastTranslation1[2], newZ1-self.lastTranslation1[3]);
		self.lastMovedDistance1 = Utils.vector3Length(dx1, dy1, dz1);
		self.lastSpeedReal1 = (self.lastMovedDistance1/10);
		self.lastTranslation1 = {newX1, newY1, newZ1};
		self.speedDisplayDt1 = self.speedDisplayDt1 - 100;
	end;

	self.speedDisplayDt2 = self.speedDisplayDt2 + dt;
	if self.speedDisplayDt2 > 100 then
		local newX2, newY2, newZ2 = getWorldTranslation(self.spedTracRight);
		if self.lastTranslation2 == nil then
			self.lastTranslation2 = {newX2, newY2, newZ2};
		end;
		local dx2, dy2, dz2 = worldDirectionToLocal(self.spedTracRight, newX2-self.lastTranslation2[1], newY2-self.lastTranslation2[2], newZ2-self.lastTranslation2[3]);
		self.lastMovedDistance2 = Utils.vector3Length(dx2, dy2, dz2);
		self.lastSpeedReal2 = (self.lastMovedDistance2/10);
		self.lastTranslation2 = {newX2, newY2, newZ2};
		self.speedDisplayDt2 = self.speedDisplayDt2 - 100;
    end;

	for i=1, self.numTrackWheels do
		local q = self.Tracks[i].refWheel
		local TTDifferent = self.Tracks[i].different;
		local x,_,_ = getRotation(self.wheels[q].repr);
		local TTWheel = self.Tracks[i].index;
		setRotation(TTWheel, x*TTDifferent,0,0);
	end;

		local tx1,ty1,tz1 = getRotation(self.wheels[1].repr);
		if tx1 > self.lastRot then self.movingDirection1 = 1; self.movingDirection2 = 1; end;
		if tx1 == self.lastRot then self.movingDirection1 = 0; self.movingDirection2 = 0; end;
		if tx1 < self.lastRot then self.movingDirection1 = -1; self.movingDirection2 = -1; end;
		self.lastRot = tx1;
		if ty1 < 1 then
			setAnimTrackSpeedScale(self.charId, 0, 25 * self.lastSpeedReal1 * self.movingDirection1);
			enableAnimTrack(self.charId, 0);
		else
			disableAnimTrack(self.charId, 0);
		end;
		if ty1 > -1 then
			setAnimTrackSpeedScale(self.charId1, 0, 25 * self.lastSpeedReal2 * self.movingDirection2);
			enableAnimTrack(self.charId1, 0);
		else
			disableAnimTrack(self.charId1, 0);
		end;
end;

function TracAnim:onLeave()
end;

function TracAnim:draw()
end;
