-- версия 05.01.2016
-- Автор Кирюха Тельтевской
-- http://vk.com/besedka_fermera

rotator = {};
rotator.modDir = g_currentModDirectory;

local rpm_hud_state = false;
local animator_input;

function rotator.prerequisitesPresent(specializations)
    return true;
end;

function rotator:load(xmlFile)
	self.rotator_count = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.rotators#rotatorCount"));
	if self.rotator_count ~= nil then
		self.new_image = Overlay:new("new_image", (rotator.modDir.."scripts/bg.dds"), 0.826, 0.13, 0.2, 0.03);
		self.table_rotator_index = {};
		self.table_rotator_axis = {};
		self.table_rotator_spin = {};
		self.table_rotator_speed = {};
		self.table_rotator_rpm_depend = {};
		local string_rot_parts;
		local rotator_index;
		local rotator_axis;
		local rotator_spin;
		local rotator_rpm_depend;
		for i = 1, self.rotator_count do
			string_rot_parts = string.format("vehicle.rotators.rotatorPart%d", i);
			rotator_index = Utils.indexToObject(self.components, getXMLString(xmlFile, string_rot_parts .. "#index"));
			rotator_axis = Utils.getNoNil(getXMLFloat(xmlFile, string_rot_parts .. "#rotatorAxis"));
			rotator_spin = Utils.getNoNil(getXMLFloat(xmlFile, string_rot_parts .. "#rotatorSpin"));
			rotator_speed = Utils.getNoNil(getXMLFloat(xmlFile, string_rot_parts .. "#rotatorSpeed"));
			rotator_rpm_depend = Utils.getNoNil(getXMLFloat(xmlFile, string_rot_parts .. "#rotatorRpmDepend"));
			
			table.insert(self.table_rotator_index, rotator_index);
			table.insert(self.table_rotator_axis, rotator_axis);
			table.insert(self.table_rotator_spin, rotator_spin);
			table.insert(self.table_rotator_speed, rotator_speed);
			table.insert(self.table_rotator_rpm_depend, rotator_rpm_depend);
			i = i + 1;
		end;
	end;
	
	self.animator_count = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animators#animatorCount"));
	if self.animator_count ~= nil then
		self.table_animator_name = {};
		self.table_animator_state = {};
		self.table_animator_help = {};
		local string_animators;
		local animator_name;
		local animator_help;
		for a = 1, self.animator_count do
			string_animators = string.format("vehicle.animators.animator%d", a);
			animator_name = getXMLString(xmlFile, string_animators .. "#name");
			animator_help = getXMLBool(xmlFile, string_animators .. "#helpText");
			animator_state = false;
			table.insert(self.table_animator_name, animator_name);
			table.insert(self.table_animator_state, animator_name);
			table.insert(self.table_animator_help, animator_help);
			a = a + 1;
		end;
	end;
end;

function rotator:delete()
end;

function rotator:mouseEvent(posX, posY, isDown, isUp, button)
end;

function rotator:keyEvent(unicode, sym, modifier, isDown)
end;

function rotator:update(dt)
	if self.rotator_count ~= nil then
		if self.isMotorStarted then
			if g_currentMission.controlledVehicle == self then
				if rpm_hud_state then
					text_1 = string.format("RPM: %d об/мин", self.motor.lastMotorRpm);
					setTextBold(false);
					setTextAlignment(text_1.ALIGN_LEFT);
					renderText(0.84 ,0.14, 0.015, text_1);
				end;
			end;
			local rot_speed;
			local rot_axis;
			local rot_rpm_depend;
			for i = 1, self.rotator_count do
				rot_axis = self.table_rotator_axis[i];
				rot_rpm_depend = self.table_rotator_rpm_depend[i];
				if rot_rpm_depend == 1 then
					rot_speed = self.motor.lastMotorRpm*0.0003*self.table_rotator_spin[i]*self.table_rotator_speed[i];
				elseif rot_rpm_depend == 0 then
					rot_speed = dt*0.01*self.table_rotator_spin[i]*self.table_rotator_speed[i];
				end;
				if rot_axis == 1 then
					rotate(self.table_rotator_index[i], rot_speed, 0, 0);
				elseif rot_axis == 2 then
					rotate(self.table_rotator_index[i], 0, rot_speed, 0);
				elseif rot_axis == 3 then
					rotate(self.table_rotator_index[i], 0, 0, rot_speed);
				end;
				i = i + 1;
			end;
		end;
		if InputBinding.hasEvent(InputBinding.rpmHudVisibility) then
			if rpm_hud_state then
				rpm_hud_state = false;
			else
				rpm_hud_state = true;
			end;
		end;
	end;
	
	if self.animator_count ~= nil then
		for a = 1, self.animator_count do
			animator_input = string.format("animator%d", a);
			local animator_state;
			if InputBinding.hasEvent(InputBinding[animator_input]) then
				if self.table_animator_state[a] then
					self:playAnimation(self.table_animator_name[a], 1, nil, true);
					self.table_animator_state[a] = false;
				else
					self:playAnimation(self.table_animator_name[a], -1, nil, true);
					self.table_animator_state[a] = true;
				end;
			end;
			a = a + 1;
		end;
	end;
end;

function rotator:draw()
	if self.rotator_count ~= nil then
		if self.isMotorStarted then
			if rpm_hud_state then
				self.new_image:render();
			end;
		end;
		g_currentMission:addHelpButtonText(g_i18n:getText("rpmHudVisibility"), InputBinding.rpmHudVisibility);
	end;
	if self.animator_count ~= nil then
		local help_text_button;
		for a = 1, self.animator_count do
			if self.table_animator_help[a] then
				help_text_button = string.format("animator%d", a);
				g_currentMission:addHelpButtonText(g_i18n:getText(help_text_button), InputBinding[help_text_button]);
			end;
		end;
	end;
end;