indoorSound15 = {};

function indoorSound15.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(TurnOnVehicle, specializations);
end;

function indoorSound15:load(xmlFile)
	self.swapSounds = SpecializationUtil.callSpecializationsFunction("swapSounds");

	self.stopSoundsOnThreshing = true;	-- set this to false if the normal motor sounds should be played while threshing
	self.soundSwitched = false;
	self.internalSoundFactor = 0.5;
	
	self.threshingStartSoundInside = Utils.loadSample(xmlFile, {}, "vehicle.threshingStartSoundInside", nil, self.baseDirectory, self.components[1].node);
	self.threshingSoundInside = Utils.loadSample(xmlFile, {}, "vehicle.threshingSoundInside", nil, self.baseDirectory, self.components[1].node);
	self.threshingStopSoundInside = Utils.loadSample(xmlFile, {}, "vehicle.threshingStopSoundInside", nil, self.baseDirectory, self.components[1].node);
	self.threshingStartSoundOutside = Utils.loadSample(xmlFile, {}, "vehicle.threshingStartSound", nil, self.baseDirectory, self.components[1].node);
	self.threshingSoundOutside = Utils.loadSample(xmlFile, {}, "vehicle.threshingSound", nil, self.baseDirectory, self.components[1].node);
	self.threshingStopSoundOutside = Utils.loadSample(xmlFile, {}, "vehicle.threshingStopSound", nil, self.baseDirectory, self.components[1].node);
end;

function indoorSound15:delete()
end;

function indoorSound15:mouseEvent(posX, posY, isDown, isUp, button)
end;

function indoorSound15:keyEvent(unicode, sym, modifier, isDown)
end;

function indoorSound15:update(dt)
	if self.isEntered then
		if g_currentMission.driveControl ~= nil and g_currentMission.driveControl.useModules.inDoorSound then
			g_currentMission.driveControl.useModules.inDoorSound = false;
		end;
		
		if self:getIsActiveForSound() then
			if self.sampleMotor ~= nil then
				local samples = {self.sampleMotor, self.sampleMotorRun, self.sampleMotorStart, self.sampleMotorStop, self.sampleThreshingStop, self.sampleHonk, self.sampleRefuel, self.samplePipe, self.sampleThreshingStart, self.sampleReverseDrive, self.sampleThreshing, self.sampleCompression, self.sampleHydraulic, self.sampleCompressedAir, self.sampleCylinderedHydraulic};
				for _,sample in pairs(samples) do
					if sample ~= nil then
						local targetVolume = sample.volume;
						if self.cameras[self.camIndex].isInside then
							targetVolume = self.internalSoundFactor*targetVolume;
						end;
						if sample.sample ~= nil then
							setSampleVolume(sample.sample,targetVolume);
						end;
					end;
				end;
			end;
		end;
	end;
	if self:getIsActive() then
		if self.stopSoundsOnThreshing then
			if Utils.isSamplePlaying(self.sampleThreshing) then
				Utils.stopSample(self.sampleMotor, true);
				Utils.stopSample(self.sampleMotorRun, true);
				Utils.stop3DSample(self.sampleMotor, true);
				Utils.stop3DSample(self.sampleMotorRun, true);
			else
				if self.isMotorStarted and self.isEntered then
					if not Utils.isSamplePlaying(self.sampleMotorStart) and (not Utils.isSamplePlaying(self.sampleMotor) or not Utils.isSamplePlaying(self.sampleMotorRun)) then
						Utils.playSample(self.sampleMotor, 0, 0, nil);
						Utils.playSample(self.sampleMotorRun, 0, 0, 0);
					end;
				end;
			end;
		end;
		if (self.cameras[self.camIndex].isInside) and (not self.soundSwitched) and (self.isEntered) then
			self:swapSounds("inside");
			self.soundSwitched = true;
		elseif (not self.cameras[self.camIndex].isInside and self.soundSwitched) or (self.isEntered == false and self.soundSwitched) then
			self:swapSounds("outside");
			self.soundSwitched = false;
		end;
	end;
end;

function indoorSound15:updateTick(dt)
end;

function indoorSound15:draw()
end;

function indoorSound15:swapSounds(camInOut)
	if Utils.isSamplePlaying(self.sampleThreshing) then
		Utils.stopSample(self.sampleThreshing, true);
	end;

	if camInOut == "outside" then
		self.sampleThreshingStart = self.threshingStartSoundOutside;
		self.sampleThreshingStop = self.threshingStopSoundOutside;
		self.sampleThreshing = self.threshingSoundOutside;
	elseif camInOut == "inside" then
		self.sampleThreshingStart = self.threshingStartSoundInside;
		self.sampleThreshingStop = self.threshingStopSoundInside;
		self.sampleThreshing = self.threshingSoundInside;
	end;
	if self.isClient and self:getIsTurnedOn() and self.isEntered then
		Utils.playSample(self.sampleThreshing, 0, 0, nil);
	end;
end;