-- displayFunctions
--
-- Author RivalBomb

displayFunctions = {};
function displayFunctions.prerequisitesPresent(specializations)
    return true;
end;

function displayFunctions:load(xmlFile)
	self.displayFunctions = {};
	
	local key = "vehicle.displayFunctions.";
	self.displayFunctions.preHeating = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."preHeating#index"));
	self.displayFunctions.battery = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."battery#index"));
	self.displayFunctions.handbrake = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."handbrake#index"));
	self.displayFunctions.piepSound = Utils.loadSample(xmlFile, {}, "vehicle.piepSound", nil, self.baseDirectory, self.components[1].node);
	self.startUpAnimation = getXMLString(xmlFile, "vehicle.startUpAnimation#name");
	self.firstrun = false;
end;

function displayFunctions:delete()
	if self.displayFunctions.piepSound ~= nil then
		Utils.deleteSample(self.displayFunctions.piepSound);
	end;
end;

function displayFunctions:mouseEvent(posX, posY, isDown, isUp, button)
end;

function displayFunctions:keyEvent(unicode, sym, modifier, isDown)
end;

function displayFunctions:update(dt)
	local mFlickering=Utils.clamp(math.cos( 7.0 * (g_currentMission.time/1000) ) + 0.2, 0, 1);
	
		if self.displayFunctions.handbrake ~= nil then
			if g_currentMission.driveControl ~= nil and g_currentMission.driveControl.useModules ~= nil and g_currentMission.driveControl.useModules.handBrake ~= nil and g_currentMission.driveControl.useModules.handBrake and self.driveControl ~= nil and self.driveControl.handBrake ~= nil and self.driveControl.handBrake.isActive ~= nil then
				if self.driveControl.handBrake.isActive then
					setVisibility(self.displayFunctions.handbrake, true);
				else
					setVisibility(self.displayFunctions.handbrake, false);
				end;
			end;
		end;
		
		-- preHeating --
		if (self.ignitionMode ~= nil and self.ignitionMode == ManualIgnition.STAGE_PRE_HEAT) or (self.driveControl ~=nil and self.driveControl.manMotorStart.isMotorStarted ~= nil and self.driveControl.manMotorStart.isMotorStarted == false and self.driveControl.manMotorStart.startCnt ~= nil and self.driveControl.manMotorStart.startCnt < 800 and self.driveControl.manMotorStart.startCnt > 0) then 
			self.displayFunctions.t=self.displayFunctions.t+dt;
			if self.displayFunctions.preHeating ~= nil then
				if self.displayFunctions.t <= 2000 then
					setVisibility(self.displayFunctions.preHeating, true);
				else
					setVisibility(self.displayFunctions.preHeating, false);
				end;
			end;
			if self.displayFunctions.battery ~= nil then
				setVisibility(self.displayFunctions.battery, true);
			end;
			
			if self.displayFunctions.piepSound ~= nil then
				if not Utils.isSamplePlaying(self.displayFunctions.piepSound) then
					Utils.playSample(self.displayFunctions.piepSound,0,1,nil);
				end;
			end;
			if self.startUpAnimation ~= nil and self.playAnimation ~= nil and not self.firstrun then
				self:playAnimation(self.startUpAnimation, 1, nil, true);
			end;
			self.firstrun = true;
		else
			self.firstrun = false;
			if self.displayFunctions.piepSound ~= nil then
				if Utils.isSamplePlaying(self.displayFunctions.piepSound) then
					Utils.stopSample(self.displayFunctions.piepSound, true);
				end;
			end;
			if self.displayFunctions.preHeating ~= nil then
				setVisibility(self.displayFunctions.preHeating, false);
				self.displayFunctions.t=0;
			end;
			if self.displayFunctions.battery ~= nil then
				setVisibility(self.displayFunctions.battery, false);
			end;
			
		if (self.ignitionMode ~= nil and not self.ignitionMode == ManualIgnition.STAGE_OFF) or (self.driveControl ~=nil and self.driveControl.manMotorStart.isMotorStarted ~= nil and not self.driveControl.manMotorStart.isMotorStarted) then
			if self.startUpAnimation ~= nil and self.playAnimation ~= nil and (self.animations[self.startUpAnimation].currentTime > 0) and not self.firstrun then
				self:playAnimation(self.startUpAnimation, -100, nil, true);
			end;
		end;
	end;
end;

function displayFunctions:updateTick(dt)

	
end;

function displayFunctions:draw()
end;