--
-- ManorFarm
--
-- @author  Stefan Geiger
-- @date  12/07/10
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

ManorFarm = {}

local ManorFarm_mt = Class(ManorFarm, Mission00);


function ManorFarm:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = ManorFarm_mt;
    end;
    local self = ManorFarm:superClass():new(baseDirectory, mt);

    return self;
end;

function ManorFarm:delete()
    ManorFarm:superClass().delete(self);
end;

function ManorFarm:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableGoldCoinsObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/ManorFarm.i3d", self.baseDirectory), true, self.loadCareerMap01Finished, self);
end;

function ManorFarm:loadCareerMap01Finished(node, arguments)
    if self.cancelLoading then
        return;
    end
    local startedRepeat = startFrameRepeatMode();
    trcScreenFlip();
    self:loadMapXMLFile(Utils.getFilename("ManorFarm.xml", self.baseDirectory));
    trcScreenFlip();
    self:loadTyreTrackSystem(Utils.getFilename("$data/vehicles/shared/tyreTrackMaterialHolder.i3d", self.baseDirectory));
    trcScreenFlip();
    self:loadI3D("$data/vehicles/particleAnimations/particle_materialHolder.i3d");
    trcScreenFlip();
    self:loadI3D("$data/vehicles/fillPlanes/fillPlane_materialHolder.i3d");
	trcScreenFlip();
    self.ingameMap:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

	trcScreenFlip();
    g_statisticView:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

	trcScreenFlip();
	
	trcScreenFlip();
    ManorFarm:superClass().load(self);

	trcScreenFlip();

    if startedRepeat then
        endFrameRepeatMode();
    end
    self:finishLoadingTask();
end;

function ManorFarm:onStartMission()
    ManorFarm:superClass().onStartMission(self);
end;

function ManorFarm:mouseEvent(posX, posY, isDown, isUp, button)
    ManorFarm:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function ManorFarm:keyEvent(unicode, sym, modifier, isDown)
    ManorFarm:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function ManorFarm:update(dt)
    ManorFarm:superClass().update(self, dt);
end;

function ManorFarm:draw()
    ManorFarm:superClass().draw(self);
end;
