--
-- silageklappe1a
--
-- M@D Author:  Heady
-- M@D date: 24.11.2010
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

silageklappe1a = {};

function silageklappe1a.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function silageklappe1a:load(xmlFile)

	self.updateSendEvent = SpecializationUtil.callSpecializationsFunction("updateSendEvent");

	local silageklappe1a = {};
    silageklappe1a.name = getXMLString(xmlFile, "vehicle.silageklappe1a#name");
    silageklappe1a.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.silageklappe1a#upSpeedScale"), 1);
    silageklappe1a.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.silageklappe1a#downSpeedScale"), -silageklappe1a.openSpeedScale);
    if silageklappe1a.name ~= nil then
        self.silageklappe1a = silageklappe1a;
    end;
	self.silageklappe1a.active = false;
	
	
	self.jointmove = false;

	
end;

function silageklappe1a:delete()
end;

function silageklappe1a:mouseEvent(posX, posY, isDown, isUp, button)
end;

function silageklappe1a:keyEvent(unicode, sym, modifier, isDown)
end;

function silageklappe1a:readStream(streamId, connection)
	-- update animation on synchroninzation --
	local silageklappe1aAnimTime = streamReadFloat32(streamId);
	
	if silageklappe1aAnimTime ~= nil then
		local currentTime = self:getAnimationTime(self.silageklappe1a.name);
		local speed = 1;
		if currentTime > silageklappe1aAnimTime then
			speed = -1;
		end;
		self:playAnimation(self.silageklappe1a.name, speed, currentTime, true);
		self:setAnimationStopTime(self.silageklappe1a.name, silageklappe1aAnimTime);
	end;

	AnimatedVehicle.updateAnimations(self, 50);		

end;

function silageklappe1a:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self:getAnimationTime(self.silageklappe1a.name));
end;

function silageklappe1a:update(dt)
	
	local movejoint = self.jointmove;

	if self:getIsActiveForInput() then	
		
		local issilageklappe1aActive = false;
		if InputBinding.isPressed(InputBinding.Seeder1a_OPEN) then
			self.jointmove = true;		
			issilageklappe1aActive = true;
			if InputBinding.hasEvent(InputBinding.Seeder1a_OPEN) then
				self:playAnimation(self.silageklappe1a.name, self.silageklappe1a.openSpeedScale, self:getAnimationTime(self.silageklappe1a.name)); 
			end;
		elseif InputBinding.isPressed(InputBinding.Seeder1a_CLOSE) then
			self.jointmove = true;	
			issilageklappe1aActive = true;	
			if InputBinding.hasEvent(InputBinding.Seeder1a_CLOSE) then
				self:playAnimation(self.silageklappe1a.name, self.silageklappe1a.closeSpeedScale, self:getAnimationTime(self.silageklappe1a.name)); 
			end;			
		end;
			
		if self.silageklappe1a.active and not issilageklappe1aActive then
			self:stopAnimation(self.silageklappe1a.name);	
			self.jointmove = false;
		end;
		self.silageklappe1a.active = issilageklappe1aActive;
		
	end;
	
	if movejoint ~= self.jointmove then -- wenn gendert dann sende an server/client (minimierung der bertragungsrate) --
		self:updateSendEvent();
	end;
	
	if self:getIsActive() then
	
		if self.isServer then
			if self.attacherVehicle ~= nil and self.jointmove then
				for k, implement in pairs(self.attacherVehicle.attachedImplements) do
					local jointDesc = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
					if k == self.attacherVehicle.selectedImplement  then
						setJointFrame(jointDesc.jointIndex, 1, self.attacherJoint.node);
					end;
				end;
			end;
		end;
		
	end;

end;

function silageklappe1a:updateTick(dt)
	--[[if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;	
	end;]]--
end;

function silageklappe1a:draw()	

	g_currentMission:addExtraPrintText(InputBinding.getKeyNamesOfDigitalAction(InputBinding.Seeder1a_OPEN).." / "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.Seeder1a_CLOSE)..": Sprayer auf / zu");
	
end;

function silageklappe1a:updateSendEvent()	

	if g_server ~= nil then
		g_server:broadcastEvent(MPEvent:new(self));
	else
		g_client:getServerConnection():sendEvent(MPEvent:new(self));
	end;

end;


