-- by modelleicher
--
-- www.schwabenmodding.bplaced.net

RadsturzV2 = {};

function RadsturzV2.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function RadsturzV2:load(xmlFile)

	self.sv2 = {}; -- ich packe meine Variablen in jeder LUA erst mal in einen Table, da es mittlerweile so viele Scripts gibt dass es sonst gern zu berschneidungen kommt.
	-- Indexe der FenderTransforms die spter rotiert werden
	self.sv2.fenderLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Radsturz.Links#index"));
	self.sv2.fenderRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Radsturz.Rechts#index"));
	-- funktioniert auch mit den XML Angaben der lteren LUA
	if self.sv2.fenderLeft == nil then
		self.sv2.fenderLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Fenders.FenderLK#index"));
	end;
	if self.sv2.fenderRight == nil then
		self.sv2.fenderRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Fenders.FenderRK#index"));
	end;
	
	-- Werte die fr die Berechnung notwendig sind. Optionale Angabe in der XML, ansonsten standartwerde.
	self.sv2.berDiv = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Radsturz#multiplicator"), 50);
	self.sv2.leftRightDifference = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Radsturz#linksRechtsDifferenz"), 0.8);
end;

function RadsturzV2:delete()
end;

function RadsturzV2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RadsturzV2:keyEvent(unicode, sym, modifier, isDown)
end;

function RadsturzV2:update(dt)
    if self:getIsActive() then
		-- Rotation vom Lenkrad abgreifen
		local rx, ry, rz = getRotation(self.steering);
		local rw1 = (ry / self.sv2.berDiv);
		
		-- Nachdem die Rotation durch den vorgegebenen Wert berDiv (Standart 45) geteitl wurde folgt die Aufteilung in Links und Rechts Werte
		local rwLeft = 0;
		local rwRight = 0;
		if ry > 0 then -- positive Rotation d. Lenkrads --> Links mehr Sturz als Rechts
			rwLeft = rw1 
			rwRight = rw1*self.sv2.leftRightDifference
		elseif ry < 0 then -- negative Rotation d. Lenkrads --> Rechts mehr Sturz als Links
			rwLeft = rw1*self.sv2.leftRightDifference		 
			rwRight = rw1
		end;
		-- und die Umsetzung der Rotation
		setRotation(self.sv2.fenderLeft, 0, 0, -rwLeft);
		setRotation(self.sv2.fenderRight, 0, 0, -rwRight);
	end;
end;

function RadsturzV2:draw()
end;

