﻿ <?xml version="1.0" encoding="utf-8" standalone="no" ?>
<vehicle type="trailer">
	<annotation>Copyright (C) GIANTS Software GmbH, All Rights Reserved.</annotation>
	<name>
		<en>Gator Trailer</en>
		<de>Gator Anhänger</de>
	</name>
	<filename>textures/gatorTrailer.dae</filename>
	<typeDesc>$l10n_TypeDesc_Tipper</typeDesc>
	
	<size width="3" length="5" lengthOffset="0.2" />
	
	<wheels autoRotateBackSpeed="2.0">
		<wheel driveMode="0" repr="0" radius="0.2632" deltaY="0.18" suspTravel="0.25" spring="5" damper="30" mass="2" lateralStiffness="5" />
		<wheel driveMode="0" repr="1" radius="0.2632" deltaY="0.18" suspTravel="0.25" spring="5" damper="30" mass="2" lateralStiffness="5" />
	</wheels>
	
	<brakeForce>1</brakeForce>
	
	<groundDropArea startIndex="8" widthIndex="9" heightIndex="10" />
	<massScale value="0.25" />
	
	<cylinderedHydraulicSound file="$data/vehicles/shared/hydraulicUp.wav" pitchOffset="0.9" volume="1.0" />
	<fillSound file="$data/maps/sounds/siloFillSound.wav" pitchOffset="1.0" volume="1.5" />
 
	<inputAttacherJoints>
        <inputAttacherJoint index="0>2" jointType="trailer" rootNode="0>" />
		<inputAttacherJoint index="0>2" jointType="trailerLow" rootNode="0>" />
    </inputAttacherJoints>	
	
	<AttacherJoints>
		<AttacherJoint index="0>4" jointType="trailerLow" maxRotLimit="10 80 80" />
		<AttacherJoint index="0>4" jointType="trailer" maxRotLimit="10 80 80" />
	</AttacherJoints>
	
	<lights>
        <light decoration="0>11|0|0|0|2" lightType="0"/>
	</lights>
	
	<brakeLights>
		<brakeLight index="0>11|0|0|0|3" />
	</brakeLights>
	
	<turnSignals>
        <turnSignalLeft index="0>11|0|0|0|5" />
        <turnSignalRight index="0>11|0|0|0|6" />
    </turnSignals>

    <reverseLights>
        <reverseLight index="0>11|0|0|0|4" />
    </reverseLights>
	
	<tipReferencePoints>
		<tipReferencePoint index="0>3" />
	</tipReferencePoints>
	<capacity>2000</capacity>
	<massPerFillLevel value="0.00005" />
	
	<fillTypes fruitTypes="wheat barley rape maize potato sugarBeet grass grass_windrow dryGrass_windrow chaff forage silage wheat_windrow barley_windrow manure"/>
	
	<fillPlanes>
		<fillPlane type="wheat">
			<node index="0>11|1|0">
				<key time="0" y="0.05" scale="0.336 0 0.279"/>
				<key time="1" y="0.33" scale="0.336 0.365 0.279"/>
			</node>
		</fillPlane>
		<fillPlane type="barley">
			<node index="0>11|1|0">
				<key time="0" y="0.05" scale="0.336 0 0.279"/>
				<key time="1" y="0.33" scale="0.336 0.365 0.279"/>
			</node>
		</fillPlane>
		<fillPlane type="rape">
			<node index="0>11|1|1">
				<key time="0" y="0.05" scale="0.336 0 0.279"/>
				<key time="1" y="0.33" scale="0.336 0.365 0.279"/>
			</node>
		</fillPlane>
		<fillPlane type="maize">
			<node index="0>11|1|2">
				<key time="0" y="0.05" scale="0.336 0 0.279"/>
				<key time="1" y="0.33" scale="0.336 0.365 0.279"/>
			</node>
		</fillPlane>
		<fillPlane type="potato">
			<node index="0>11|1|3">
				<key time="0" y="0.05" scale="0.336 0 0.279"/>
				<key time="1" y="0.33" scale="0.336 0.365 0.279"/>
			</node>
		</fillPlane>
		<fillPlane type="sugarBeet">
			<node index="0>11|1|4">
				<key time="0" y="0.05" scale="0.336 0 0.279"/>
				<key time="1" y="0.33" scale="0.336 0.365 0.279"/>
			</node>
		</fillPlane>
		<fillPlane type="grass">
			<node index="0>11|1|5">
				<key time="0" y="0.05" scale="0.336 0 0.279"/>
				<key time="1" y="0.33" scale="0.336 0.365 0.279"/>
			</node>
		</fillPlane>
		<fillPlane type="grass_windrow">
			<node index="0>11|1|5">
				<key time="0" y="0.05" scale="0.336 0 0.279"/>
				<key time="1" y="0.33" scale="0.336 0.365 0.279"/>
			</node>
		</fillPlane>
		<fillPlane type="dryGrass_windrow">
			<node index="0>11|1|5">
				<key time="0" y="0.05" scale="0.336 0 0.279"/>
				<key time="1" y="0.33" scale="0.336 0.365 0.279"/>
			</node>
		</fillPlane>
		<fillPlane type="chaff">
			<node index="0>11|1|6">
				<key time="0" y="0.05" scale="0.336 0 0.279"/>
				<key time="1" y="0.33" scale="0.336 0.365 0.279"/>
			</node>
		</fillPlane>
		<fillPlane type="forage">
			<node index="0>11|1|6">
				<key time="0" y="0.05" scale="0.336 0 0.279"/>
				<key time="1" y="0.33" scale="0.336 0.365 0.279"/>
			</node>
		</fillPlane>
		<fillPlane type="silage">
			<node index="0>11|1|6">
				<key time="0" y="0.05" scale="0.336 0 0.279"/>
				<key time="1" y="0.33" scale="0.336 0.365 0.279"/>
			</node>
		</fillPlane>
		<fillPlane type="wheat_windrow">
			<node index="0>11|1|7">
				<key time="0" y="0.05" scale="0.336 0 0.279"/>
				<key time="1" y="0.33" scale="0.336 0.365 0.279"/>
			</node>
		</fillPlane>
		<fillPlane type="barley_windrow">
			<node index="0>11|1|7">
				<key time="0" y="0.05" scale="0.336 0 0.279"/>
				<key time="1" y="0.33" scale="0.336 0.365 0.279"/>
			</node>
		</fillPlane>
		<fillPlane type="manure">
			<node index="0>11|1|8">
				<key time="0" y="0.05" scale="0.336 0 0.279"/>
				<key time="1" y="0.33" scale="0.336 0.365 0.279"/>
			</node>
		</fillPlane>
	</fillPlanes>
	
	<tipAnimations>
		<tipAnimation speedScale="1" animationName="tipAnimationBack" dischargeStartTime="1" dischargeEndTime="10" >
			<dischargeParticleSystems>
				<dischargeParticleSystem type="wheat" node="0>11|3" position="0 0 0" rotation="0 0 0" file="particleSystems/trailerDPSSmall.i3d" />
				<dischargeParticleSystem type="barley" node="0>11|3" position="0 0 0" rotation="0 0 0" file="particleSystems/trailerDPSSmall.i3d" />
				<dischargeParticleSystem type="maize" node="0>11|3" position="0 0 0" rotation="0 0 0" file="particleSystems/trailerDPSSmall.i3d" />    
				<dischargeParticleSystem type="rape" node="0>11|3" position="0 0 0" rotation="0 0 0" file="particleSystems/trailerDPSSmallRape.i3d" />
				<dischargeParticleSystem type="potato" node="0>11|3" position="0 0 0" rotation="0 0 0" file="particleSystems/trailerDPSSmallPotato.i3d" />
				<dischargeParticleSystem type="sugarBeet" node="0>11|3" position="0 0 0" rotation="0 0 0" file="particleSystems/trailerDPSSmallSugarBeet.i3d" />
				<dischargeParticleSystem type="chaff" node="0>11|3" position="0 0 0" rotation="0 0 0" file="particleSystems/trailerDPSSmallChaff.i3d" />
				<dischargeParticleSystem type="forage" node="0>11|3" position="0 0 0" rotation="0 0 0" file="particleSystems/trailerDPSSmallChaff.i3d" />
				<dischargeParticleSystem type="silage" node="0>11|3" position="0 0 0" rotation="0 0 0" file="particleSystems/trailerDPSSmallChaff.i3d" />
				<dischargeParticleSystem type="manure" node="0>11|3" position="0 0 0" rotation="0 0 0" file="particleSystems/trailerDPSSmallChaff.i3d" />
				<dischargeParticleSystem type="grass" node="0>11|3" position="0 0 0" rotation="0 0 0" file="particleSystems/trailerDPSSmallGrass.i3d" />
				<dischargeParticleSystem type="grass_windrow" node="0>11|3" position="0 0 0" rotation="0 0 0" file="particleSystems/trailerDPSSmallGrass.i3d" />
				<dischargeParticleSystem type="dryGrass_windrow" node="0>11|3" position="0 0 0" rotation="0 0 0" file="particleSystems/trailerDPSSmallGrass.i3d" />
				<dischargeParticleSystem type="wheat_windrow" node="0>11|3" position="0 0 0" rotation="0 0 0" file="particleSystems/trailerDPSSmall.i3d" />
				<dischargeParticleSystem type="barley_windrow" node="0>11|3" position="0 0 0" rotation="0 0 0" file="particleSystems/trailerDPSSmall.i3d" />
			</dischargeParticleSystems>
		</tipAnimation>
	</tipAnimations>

	<fillRootNode index="0>" />
	<exactFillRootNode index="0>5" />
	<fillAutoAimTargetNode index="0>6" />
	<fillMassNode index="0>" />
	
	<movingTools>
		<!-- support -->
		<movingTool index="0>7" componentJointIndex="0" anchorActor="0" />
		<!-- backTipping -->
		<movingTool index="0>11|0">
		</movingTool>
		<movingTool index="0>11">
			<dependentPart index="0>15|0" />
			<dependentPart index="0>15|0|0" />
		</movingTool>
	</movingTools>
	
	<movingParts>
		<movingPart index="0>15|0" referencePoint="0>11|2" referenceFrame="0>" lockAxis="1"/>
		<movingPart index="0>15|0|0" referencePoint="0>11|2" referenceFrame="0>" lockAxis="1">
			<translatingPart index="0>15|0|0|0" />
			<translatingPart index="0>15|0|0|0|0" />
			<translatingPart index="0>15|0|0|0|0|0" />
		</movingPart>
	</movingParts>
	
	<animations>
		<!-- backtipping -->
		<animation name="tipAnimationBack">
			<part node="0>11|0" startTime="0" endTime="4" startRot="0 0 0" endRot="75 0 0" />
			<part node="0>11" startTime="2" endTime="10" startRot="0 0 0" endRot="-22 0 0" />
		</animation>
		<!-- move support wheel down/up -->
		<animation name="moveSupport">
			<part node="0>7" startTime="0" duration="0.6" startTrans="0.12404 0.285 1.18562" endTrans="0.12404 0 1.18562" />
		</animation>
	</animations>

	<support animationName="moveSupport" />

	<components count="2">
		<component1 centerOfMass="0.0 0.0 0.0" solverIterationCount="4" />
		<component2 solverIterationCount="8" />
			<joint component1="0" component2="1" index="0>7|0" rotLimit="0 0 0" transLimit="0 0 0" />
	</components>
	
	<driveGroundParticleSystems>
        <driveGroundParticleSystem file="$data/vehicles/particleAnimations/shared/drivingParticleSystem.i3d" wheel="1" />
        <driveGroundParticleSystem file="$data/vehicles/particleAnimations/shared/drivingParticleSystem.i3d" wheel="2" />
    </driveGroundParticleSystems>
  
	<schemaOverlay file="implementSchema.png" fileSelected="implementSchemaSelected.png" width="0.45" height="0.45" attacherJointPosition="0 0">
		<attacherJoint position="1 0" rotation="0" invertX="false" />
		<attacherJoint position="1 0" rotation="0" invertX="false" />
		<attacherJoint position="1 0" rotation="0" invertX="false" />
	</schemaOverlay>

</vehicle>
