<?xml version="1.0" encoding="UTF-8"?>
<vehicle type="tractor">
	<annotation>Amarlich, CarolinaBoy, Arctic Wolf Modding</annotation>
	<name>
		<en>Gator 825i</en>
		<de>Gator 825i</de>
	</name>
	<description>Gator 825i</description>
	<filename>textures/gator825i.dae</filename>
	<typeDesc>$l10n_TypeDesc_tractor</typeDesc>
	<size width="3.5" length="5.5" lengthOffset="-0.4" />
	
	<wheels autoRotateBackSpeed="2">
        <wheel rotSpeed="70" restLoad="7.12" repr="0>2" forcePointRatio="0.2" driveNode="0>2"   radius="0.36" width="0.42" initialCompression="50" suspTravel="0.2" spring="30" damper="20"                       maxLatStiffness="20" mass="1" hasTyreTracks="true" tyreTrackAtlasIndex="1" tireType="street" />
        <wheel rotSpeed="70" restLoad="7.12" repr="0>3" forcePointRatio="0.2" driveNode="0>3"   radius="0.36" width="0.42" initialCompression="50" suspTravel="0.2" spring="30" damper="20"                       maxLatStiffness="20" mass="1" hasTyreTracks="true" tyreTrackAtlasIndex="1" tireType="street" />
        <wheel rotSpeed="0" restLoad="8.12" repr="0>0" forcePointRatio="0.3"  driveNode="0>0"  radius="0.36" width="0.52" initialCompression="50" suspTravel="0.2" spring="30" damper="20" maxLongStiffness="10" maxLatStiffness="40" mass="2" hasTyreTracks="true" tyreTrackAtlasIndex="1" tireType="street" />
        <wheel rotSpeed="0" restLoad="8.12" repr="0>1" forcePointRatio="0.3"  driveNode="0>1"  radius="0.36" width="0.52" initialCompression="50" suspTravel="0.2" spring="30" damper="20" maxLongStiffness="10" maxLatStiffness="40" mass="2" hasTyreTracks="true" tyreTrackAtlasIndex="1" tireType="street" />
    </wheels>
	
	<ackermannSteering rotSpeed="60" rotMax="47" rotCenterWheel1="3" rotCenterWheel2="4" />

    <differentials>
        <differential torqueRatio="0.5" maxSpeedRatio="1.3" wheelIndex1="0" wheelIndex2="1" /> <!-- front left-right -->
        <differential torqueRatio="0.5" maxSpeedRatio="1.4" wheelIndex1="2" wheelIndex2="3" /> <!-- back left-right -->
        <differential torqueRatio="0.5" maxSpeedRatio="1.2" differentialIndex1="0" differentialIndex2="1" /> <!-- front-back -->
    </differentials>
	
	<motor minRpm="300" maxRpm="600 950 1200" brakeForce="1" forwardGearRatio="4.0 3.0 2.2" backwardGearRatio="1.8" differentialRatio="3.4" rpmFadeOutRange="20">
        <torque rpm="500" torque="5.5"/>
        <torque rpm="900" torque="7.3"/>
        <torque rpm="1300" torque="7.8"/>
        <torque rpm="1750" torque="8.8"/>
        <torque rpm="1800" torque="8.3"/>
    </motor>
	
	<fuelCapacity>100</fuelCapacity>
	<fuelUsage>5</fuelUsage>

	<motorStartDuration>2500</motorStartDuration>
	<attachSound file="$data/vehicles/shared/attach.wav" pitchOffset="1" />
	<motorStartSound file="sounds/gator_start.wav" pitchOffset="1" volume="0.75" />
	<motorSound file="sounds/gator_run.wav" pitchOffset="1" pitchScale="0.02" pitchMax="1.45" volume="1" radius="50" innerRadius="20" />
	<motorSoundRun file="sounds/gator_run.wav" pitchOffset="0.5" pitchScale="0.033" pitchMax="1.4" volume="1.25" />
	<motorStopSound file="sounds/lanzout.wav" pitchOffset="1" volume="1" />
	<compressedAirSound file="$data/vehicles/shared/brakeSmall.wav" pitchOffset="1" volume="1"/>
	<compressionSound file="$data/vehicles/shared/compressorWork.wav" pitchOffset="1" volume="1.5"/>
	<honkSound file="$dataS2/sounds/horn.wav" volume="1" radius="80" innerRadius="35" />
	<reverseDriveSound file="sounds/reverseDrivingBeep.wav" volume="0.5" />

	<lights>
        <light realLight="0>11|7" decoration="0>11|0|3" lightType="0"/>
		<light realLight="0>8" lightType="1"/>
		<light realLight="0>9" lightType="2"/>
		<light realLight="0>11|8" lightType="3"/>
	</lights>
	
	<brakeLights>
		<brakeLight index="0>11|0|4" />
	</brakeLights>

	<turnSignals>
        <turnSignalLeft index="0>11|0|6|0" />
        <turnSignalRight index="0>11|0|6|1" />
    </turnSignals>

    <reverseLights>
        <reverseLight index="0>11|0|5" />
    </reverseLights>

	<AttacherJoints>
		<AttacherJoint index="0>14" low="true" />
		<attacherJoint index="14" jointType="trailer" maxRotLimit="10 50 50" minRotRotationOffset="0" allowsJointLimitMovement="false" />
        <attacherJoint index="14" jointType="trailerLow" maxRotLimit="10 50 50" minRotRotationOffset="0" allowsJointLimitMovement="false" />
   	</AttacherJoints>
	
	<exhaustEffects>
        <exhaustEffect index="0>13" filename="$data/vehicles/particleAnimations/shared/exhaust.i3d" minRpmColor="0.9 0.9 0.9 0.05" maxRpmColor="0.9 0.9 0.9 0.2" minRpmScale="0.08" maxRpmScale="0.6" forwardXRotations="-300 50 50" forwardZRotations="-100 0 0" steerXRotations="0 0 0" steerZRotations="-100 0 100" />
    </exhaustEffects>
	
	<cameras count="2">
		<camera1 index="0>4|0" rotatable="true" rotateNode="4" limit="true" useWorldXZRotation="true" rotMinX="-1.4" rotMaxX="1" transMin="4" transMax="35" />
		<camera2 index="0>5" rotatable="true" limit="true" rotMinX="-1.1" rotMaxX="0.4" transMin="0" transMax="0" />
	</cameras>

	<steering index="0>7|0" rotationSpeed="6" />
	<enterReferenceNode index="0>" />
	<exitPoint index="0>6" />
	<characterNode index="10" cameraMinDistance="1.5" />
	<aiTrafficCollisionTrigger index="0>15" />

	<animParts>
		<animPart index="0>11|0" id="dump" showHelp="true" rotMin="45 0 0" rotMax="0 0 0" moveTime="3" />
		<animPart index="0>11|0|1" id="doorback" showHelp="true" rotMin="90 0 0" rotMax="0 0 0" moveTime="3" />
	</animParts>
	
	<driveGroundParticleSystems>
        <driveGroundParticleSystem file="$data/vehicles/particleAnimations/shared/drivingParticleSystem.i3d" wheel="1" />
        <driveGroundParticleSystem file="$data/vehicles/particleAnimations/shared/drivingParticleSystem.i3d" wheel="2" />
        <driveGroundParticleSystem file="$data/vehicles/particleAnimations/shared/drivingParticleSystem.i3d" wheel="3" />
        <driveGroundParticleSystem file="$data/vehicles/particleAnimations/shared/drivingParticleSystem.i3d" wheel="4" />
    </driveGroundParticleSystems>
	
	<components count="1">
		<component1 centerOfMass="0 -0.015 0.005" solverIterationCount="10" />
	</components>
	
	<schemaOverlay file="vehicleSchema.png" fileSelected="vehicleSchemaSelected.png" width="0.5" height="0.5" attacherJointPosition="0.5 0">
		<attacherJoint position="1 0" rotation="0" invertX="false" />
		<attacherJoint position="1 0" rotation="0" invertX="false" />
		<attacherJoint position="1 0" rotation="0" invertX="false" />
	</schemaOverlay>

</vehicle>