--
-- Copyright � 2013 Joacim Sigfridsson <joxxer@msn.com>
-- This work is free. You can redistribute it and/or modify it under the
-- terms of the Do What The Fuck You Want To Public License, Version 2,
-- as published by Sam Hocevar. See http://www.wtfpl.net/ for more details.
--
--
-- JohnDeere6R
-- Specialization for JohnDeere6R mod
--
-- @author  	JoXXer
-- @date  		01/08/13
--

JohnDeere6R = {};

function JohnDeere6R.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function JohnDeere6R:load(xmlFile)
	self.frontLinkageTopLinkNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLinkageTopLinkNode#rotationNode"));
	
	self.frontLinkageBottomArmRotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLinkageBottomArm#rotationNode"));

	
	self.frontLinkage = {};
	
	self.frontLinkage.armLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLinkage#armLeft"));
	self.frontLinkage.armRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLinkage#armRight"));
	self.frontLinkage.ballLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLinkage#ballLeft"));
	self.frontLinkage.ballRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLinkage#ballRight"));
	self.frontLinkage.transportRot = math.rad(Utils.getNoNil(getXMLInt(xmlFile, "vehicle.frontLinkage#transportRot"), 0));
	
	self.frontLinkage.topArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLinkage#topArm"));
	
	if self.frontLinkage.armLeft ~= nil then
		self.frontLinkage.armLeftOrigRot = {getRotation(self.frontLinkage.armLeft)};
		local x, y, z = unpack(self.frontLinkage.armLeftOrigRot);
		setRotation(self.frontLinkage.armLeft, self.frontLinkage.transportRot, y, z);
	end;
	if self.frontLinkage.armRight ~= nil then
		self.frontLinkage.armRightOrigRot = {getRotation(self.frontLinkage.armRight)};
		local x, y, z = unpack(self.frontLinkage.armRightOrigRot);
		setRotation(self.frontLinkage.armRight, self.frontLinkage.transportRot, y, z);
	end;
	
	if self.frontLinkage.ballLeft ~= nil and self.frontLinkage.ballRight ~= nil then
		setVisibility(self.frontLinkage.ballLeft, false);
		setVisibility(self.frontLinkage.ballRight, false);
	end;
	
	if self.frontLinkage.topArm ~= nil then
		self.frontLinkage.topArmOrigRot = {getRotation(self.frontLinkage.topArm)};
		self.frontLinkage.topArmOrigTrans = {getTranslation(self.frontLinkage.topArm)};
		
		self.frontLinkage.topArmTransportRot = Utils.getRadiansFromString(getXMLString(xmlFile,  "vehicle.frontLinkage#topArmTransportRot"), 3);
		self.frontLinkage.topArmTransportTrans = Utils.getVectorNFromString(getXMLString(xmlFile,  "vehicle.frontLinkage#topArmTransportTrans"), 3);
			
		setRotation(self.frontLinkage.topArm, unpack(self.frontLinkage.topArmTransportRot));
		setTranslation(self.frontLinkage.topArm, unpack(self.frontLinkage.topArmTransportTrans));
	end;
	
	self.rearLinkageBalls = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearLinkageBalls#index"));
	
	if self.rearLinkageBalls ~= nil then
		setVisibility(self.rearLinkageBalls, false);
	end;
	
	self.cabSuspensionCylinders = {};
	
	self.cabSuspensionCylinders.left = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cabSuspensionCylinders#left"));
	self.cabSuspensionCylinders.right = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cabSuspensionCylinders#right"));
	
	if self.cabSuspensionCylinders.left ~= nil and self.cabSuspensionCylinders.right ~= nil then
		self.cabSuspensionCylinders.leftOrigRot = {getRotation(self.cabSuspensionCylinders.left)};
		self.cabSuspensionCylinders.rightOrigRot = {getRotation(self.cabSuspensionCylinders.right)};
	end;
	
	self.doGraciousLiftOnJoint = nil;
	self.implementNoLowering = false;
	
	self.steeringColumn = {};
	self.steeringColumn.anim = getXMLString(xmlFile, "vehicle.steeringColumn#animName");
	self.steeringColumn.speed = getXMLFloat(xmlFile, "vehicle.steeringColumn#speed");
	
	self.moveDownIntervall = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.moveDownIntervall#ms"), 1000);
	self.updateJoint = false;
	self.doLowering = false;
	self.loweringDone = false;
	self.nextAction = false;
	self.delay = 0;
	self.implementCount = 0;
end;

function JohnDeere6R:delete()
end;

function JohnDeere6R:readStream(streamId, connection)
end;

function JohnDeere6R:writeStream(streamId, connection)
end;

function JohnDeere6R:readUpdateStream(streamId, timestamp, connection)
end;

function JohnDeere6R:writeUpdateStream(streamId, connection, dirtyMask)
end;

function JohnDeere6R:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JohnDeere6R:keyEvent(unicode, sym, modifier, isDown)
end;

function JohnDeere6R:update(dt)
	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.LOWER_ALL_IMPLEMENTS) then
				if self.implementCount == 2 then			
					self.loweringDone = false;
					self.delay = self.moveDownIntervall;
					self.doLowering = true;
					self.nextAction = not self.attacherJoints[1].moveDown;
					if self.attacherJoints[2].moveDown ~= not self.nextAction then 
						self.nextAction = false;
					end;
				end;
			end;		
		end;
	end;
	
	-- Make parts move, magic
	if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			Cylindered.setDirty(self, part);
		end;
		
		-- Silly fix to prevent cab cylinders from going mental
		if self.cabSuspensionCylinders.left ~= nil and self.cabSuspensionCylinders.right ~= nil then
			setRotation(self.cabSuspensionCylinders.left, unpack(self.cabSuspensionCylinders.leftOrigRot));
			setRotation(self.cabSuspensionCylinders.right, unpack(self.cabSuspensionCylinders.rightOrigRot));
		end;
	end;
end;

function JohnDeere6R:updateTick(dt)
	if self:getIsActive() then	
		if self.doLowering then	
			local back = self.attacherJoints[1];
			local front = self.attacherJoints[2];	
			if not self.loweringDone then
				self:setJointMoveDown(2, self.nextAction);
				self.loweringDone = true;
			end;			
			if self.loweringDone then
				self.delay = self.delay - dt;				
				if self.delay <= 0 then
					self:setJointMoveDown(1, self.nextAction);
					self.doLowering = false;
				end;
			end;
		end;
		if self.doGraciousLiftOnJoint ~= nil then
			local x, y, z = getRotation(self.attacherJoints[self.doGraciousLiftOnJoint].rotationNode);
			local x2, y2, z2 = getRotation(self.attacherJoints[self.doGraciousLiftOnJoint].rotationNode2);
			if x < math.rad(20) then
				setRotation(self.attacherJoints[self.doGraciousLiftOnJoint].rotationNode, x + (0.0005 * dt), 0, 0);
				if x2 > math.rad(-20) then
					setRotation(self.attacherJoints[self.doGraciousLiftOnJoint].rotationNode2, x2 - (0.0005 * dt), 0, 0);
				end;
				self.updateJoint = true;
			else
				self.doGraciousLiftOnJoint = nil;
			end;
		end;
	end;
end;

function JohnDeere6R:draw()
	if self.implementNoLowering and self.implementCount == 2 then
		g_currentMission:addHelpButtonText(g_i18n:getText("LOWER_FRONT_IMPLEMENT"), InputBinding.LOWER_ALL_IMPLEMENTS);
	elseif self.implementCount == 2 then
		g_currentMission:addHelpButtonText(g_i18n:getText("LOWER_ALL_IMPLEMENTS"), InputBinding.LOWER_ALL_IMPLEMENTS);
	end;
end;

function JohnDeere6R:onLeave()
	self:playAnimation(self.steeringColumn.anim, -self.steeringColumn.speed, Utils.clamp(self:getAnimationTime(self.steeringColumn.anim), 0, 1), true);
end;

function JohnDeere6R:onEnter()
	self:playAnimation(self.steeringColumn.anim, self.steeringColumn.speed, Utils.clamp(self:getAnimationTime(self.steeringColumn.anim), 0, 1), true);
end;

function JohnDeere6R:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;

	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = self.implementCount + 1;
		end;
		if jointIndex == 1 then
			setVisibility(self.rearLinkageBalls, true);
			if not implement.object.allowsLowering then
				self.doGraciousLiftOnJoint = jointIndex;
				self.implementNoLowering = true;
			end;
		elseif jointIndex == 2 then
			if self.frontLinkage.armLeft ~= nil then
				setRotation(self.frontLinkage.armLeft, unpack(self.frontLinkage.armLeftOrigRot));
			end;
			if self.frontLinkage.armRight ~= nil then
				setRotation(self.frontLinkage.armRight, unpack(self.frontLinkage.armRightOrigRot));
			end;
			if self.frontLinkage.ballLeft ~= nil and self.frontLinkage.ballRight ~= nil then
				setVisibility(self.frontLinkage.ballLeft, true);
				setVisibility(self.frontLinkage.ballRight, true);
			end;
			
			if self.frontLinkage.topArm ~= nil then
				setRotation(self.frontLinkage.topArm, unpack(self.frontLinkage.topArmOrigRot));
				setTranslation(self.frontLinkage.topArm, unpack(self.frontLinkage.topArmOrigTrans));
			end;
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 3 then
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 4 then
		end;
	end;

	self.updateJoint = true;
end;

function JohnDeere6R:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;

	if implement.object.attacherJoint.jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = math.max(self.implementCount - 1, 0);
		end;
		if jointIndex == 1 then
			setVisibility(self.rearLinkageBalls, false);
			self.doGraciousLiftOnJoint = nil;
			self.implementNoLowering = false;
		elseif jointIndex == 2 then
			if self.frontLinkage.armLeft ~= nil then
				local x, y, z = unpack(self.frontLinkage.armLeftOrigRot);
				setRotation(self.frontLinkage.armLeft, self.frontLinkage.transportRot, y, z);
			end;
			if self.frontLinkage.armRight ~= nil then
				local x, y, z = unpack(self.frontLinkage.armRightOrigRot);
				setRotation(self.frontLinkage.armRight, self.frontLinkage.transportRot, y, z);
			end;
			if self.frontLinkage.ballLeft ~= nil and self.frontLinkage.ballRight ~= nil then
				setVisibility(self.frontLinkage.ballLeft, false);
				setVisibility(self.frontLinkage.ballRight, false);
			end;
			
			if self.frontLinkage.topArm ~= nil then
				setRotation(self.frontLinkage.topArm, unpack(self.frontLinkage.topArmTransportRot));
				setTranslation(self.frontLinkage.topArm, unpack(self.frontLinkage.topArmTransportTrans));
			end;
		end;
	else
	end;
end;

function JohnDeere6R:validateAttacherJoint(implement, jointDesc, dt)
	if self.doGraciousLiftOnJoint == implement.jointDescIndex then
        return true;
    elseif self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;
