Einblendung1 = {};

function Einblendung1.prerequisitesPresent(specializations)
    return true;
end;
function Einblendung1:load(xmlFile)

	self.setblends3Visibility = SpecializationUtil.callSpecializationsFunction("setblends3Visibility");
	self.setblends4Visibility = SpecializationUtil.callSpecializationsFunction("setblends4Visibility");
	
      self.blends3 = {};
      local i = 0;
      while true do
          local key = string.format("vehicle.blends3.blend3(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              setVisibility(node, false);
              table.insert(self.blends3, {node=node});
          end;
          i = i + 1;
      end;

      self.blends4 = {};
      local i = 0;
      while true do
          local key = string.format("vehicle.blends4.blend4(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              setVisibility(node, false);
              table.insert(self.blends4, {node=node});
          end;
          i = i + 1;
      end;
end;
function Einblendung1:delete()
end;
function Einblendung1:readStream(streamId, connection)
	self.isLoading = true;
	local visibility = streamReadBool(streamId);
	self:setblends3Visibility(visibility, true);
	local visibility = streamReadBool(streamId);
	self:setblends4Visibility(visibility, true);
end;

function Einblendung1:writeStream(streamId, connection)
	streamWriteBool(streamId, self.blends3Active);
	streamWriteBool(streamId, self.blends4Active);
end;
function Einblendung1:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Einblendung1:keyEvent(unicode, sym, modifier, isDown)
end;
function Einblendung1:update(dt)

      if self:getIsActiveForInput() and self.isClient then
          if InputBinding.hasEvent(InputBinding.EinblendungDrai) then
              self:setblends3Visibility(not self.blends3Active);
          end;
          if InputBinding.hasEvent(InputBinding.EinblendungVier) then
              self:setblends4Visibility(not self.blends4Active);
          end;
	end;
end;
function Einblendung1:onLeave()
end;
function Einblendung1:draw()
end;
function Einblendung1:setblends3Visibility(visibility, noEventSend)
      if visibility ~= self.blends3Active then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(Setblends3Event:new(self, visibility), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(Setblends3Event:new(self, visibility));
              end;
          end;
  
          self.blends3Active = visibility;
  
          for _, blend3 in pairs(self.blends3) do
             setVisibility(blend3.node, visibility);
          end;
          for _,v in pairs(self.specializations) do
              if v.setblend3Visibility ~= nil then
                 v.setblend3Visibility(self, visibility);
              end;
          end;
      end;
end;
function Einblendung1:setblends4Visibility(visibility, noEventSend)
      if visibility ~= self.blends4Active then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(Setblends4Event:new(self, visibility), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(Setblends4Event:new(self, visibility));
              end;
          end;
  
          self.blends4Active = visibility;
  
          for _, blend4 in pairs(self.blends4) do
             setVisibility(blend4.node, visibility);
          end;
          for _,v in pairs(self.specializations) do
              if v.setblend4Visibility ~= nil then
                 v.setblend4Visibility(self, visibility);
              end;
          end;
      end;
end;

