Feraboli = {};

function Feraboli.prerequisitesPresent(specializations) return true; end;

function Feraboli:load(xmlFile)
	self.axle1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.axis#index1"));
	self.axle2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.axis#index2")); end;

function Feraboli:delete() end;

function Feraboli:mouseEvent(posX, posY, isDown, isUp, button) end;

function Feraboli:keyEvent(unicode, sym, modifier, isDown) end;

function Feraboli:update(dt)	
	if self:getIsActive() then
		xr1,_,_ = getRotation(self.axle1); xr2,_,_ = getRotation(self.axle2);
		xrw1,yrw1,zrw1 = getRotation(self.wheels[1].driveNode);
		xrw2,yrw2,zrw2 = getRotation(self.wheels[2].driveNode);
		xrw3,yrw3,zrw3 = getRotation(self.wheels[3].driveNode);
		xrw4,yrw4,zrw4 = getRotation(self.wheels[4].driveNode);
		self.newRot1 = zrw1 - xr1; self.newRot2 = zrw3 - xr2;
		setRotation(self.wheels[1].driveNode, xrw1,yrw1,self.newRot1)
		setRotation(self.wheels[2].driveNode, xrw2,yrw2,self.newRot1)
		setRotation(self.wheels[3].driveNode, xrw3,yrw3,self.newRot2)
		setRotation(self.wheels[4].driveNode, xrw4,yrw4,self.newRot2) end; end;

function Feraboli:loadFromAttributesAndNodes(xmlFile, key, resetVehicles) return BaseMission.VEHICLE_LOAD_OK; end;

function Feraboli:getSaveAttributesAndNodes(nodeIdent) end;

function Feraboli:updateTick(dt) end;

function Feraboli:draw() end;

function Feraboli:onAttach(attacherVehicle, jointDescIndex) end;
		
function Feraboli:onDetach()	end;

function Feraboli:onDeactivate() end;