InteractiveActions = {};

function InteractiveActions.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function InteractiveActions:load(xmlFile)

	local i=0;
	while true do
		local actionName = string.format("vehicle.interactiveComponents.actions.action(%d)", i);	
		if not hasXMLProperty(xmlFile, actionName) then
			break;
		end;
		local name = Utils.getNoNil(g_i18n:getText(getXMLString(xmlFile, actionName .. "#name")), "ERROR");
		local mark = Utils.indexToObject(self.components, getXMLString(xmlFile, actionName .. "#mark"));
		local highlight = getChildAt(mark, 0);
		local size = Utils.getNoNil(getXMLFloat(xmlFile, actionName .. "#size"), 0.1);
		local event = getXMLString(xmlFile, actionName .. "#event");
		local onMessage = g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, actionName .. "#onMessage"), "ic_action_on"));
		local offMessage =  g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, actionName .. "#offMessage") , "ic_action_off"));
	
		local action = action:new(nil, highlight, name, mark, size, event, self, onMessage, offMessage, self.infoBar);
		
		action.synch = Utils.getNoNil(getXMLBool(xmlFile, actionName .. "#synch"), true);

		table.insert(self.interactiveObjects, action);
		i = i + 1;
	end;
end;

function InteractiveActions:delete()
end;

function InteractiveActions:mouseEvent(posX, posY, isDown, isUp, action)
end;

function InteractiveActions:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveActions:update(dt)	
end;

function InteractiveActions:draw()
end;

action = {};

function action:new(node, highlight, name, mark, size, event, vehicle, onMessage, offMessage, infobar)

	local action_mt = Class(action, InteractiveComponentInterface);	
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, onMessage, offMessage, infobar, action_mt);

	instance.vehicle = vehicle;
	instance.event = event;
	
	return instance;	
end;

function action:delete()
	InteractiveComponentInterface.delete(self);
end;

function action:mouseEvent(posX, posY, isDown, isUp, action)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, action);
end;

function action:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function action:update(dt)
	if self.vehicle ~= nil then
		if self.event == "wheelwight" then
			self.isOpen = self.vehicle.cl.turnOn;

		end;
	end;
	InteractiveComponentInterface.update(self, dt);
end;

function action:draw()
	InteractiveComponentInterface.draw(self);
end;

function action:doAction(noEventSend, forceAction)
	if self.vehicle ~= nil then
		if self.event == "wheelwight" then
			if forceAction == nil then
				local state = not self.vehicle.cl.turnOn;
				self.vehicle:setCablight(state, true);
			end;


		end;	
	end;
end;

function action:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function action:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function action:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function action:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;