--
-- Cabsuspension
-- Specialization for Cabsuspension
--
-- @author  JoXXer
-- @date  17/09/11
-- @version 1.0 - JoXXer
--			1.1	- fruktor
--

Cabsuspension = {};

function Cabsuspension.prerequisitesPresent(specializations)
    return true;
end;

function Cabsuspension:load(xmlFile)
	-- Cabsuspension animation
	self.maxTranslationPrCycleCabin = 0.00006;
	self.cab = {};
	self.cab.rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cab#rotNode"));

	if self.cab.rotNode~=nil then
		local x,y,z = getTranslation(self.cab.rotNode);
		self.startCabXTranslation = x;
		self.startCabYTranslation = y;
		self.startCabZTranslation = z;

		local xRot,yRot,zRot = getRotation(self.cab.rotNode);
		self.cabXRot = xRot;
		self.cabZrot = zRot;
	end;

	if self.wheels[3].repr ~= nil and self.wheels[4].repr ~= nil and self.wheels[1].repr ~= nil and self.wheels[2].repr ~= nil then
		local x,y,z = getTranslation(self.wheels[3].repr);
		local x2,y2,z2 = getTranslation(self.wheels[4].repr);
		local x3,y3,z3 = getTranslation(self.wheels[1].repr);
		local x4,y4,z4 = getTranslation(self.wheels[2].repr);

		self.wheelYTranslationDifference = self.startCabYTranslation - y;
		self.frontAndRearWheelYTranslationDifference = y - y4;
		self.averageYTranslationCab = (y + y2)/2;
		self.averageYTranslationCabFront = (y3 + y4)/2;
	end;

	self.cabTranslation = self.averageYTranslationCab;
end;

function Cabsuspension:delete()
end;

function Cabsuspension:readStream(streamId, connection)
end;

function Cabsuspension:writeStream(streamId, connection)
end;

function Cabsuspension:readUpdateStream(streamId, timestamp, connection)
end;

function Cabsuspension:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Cabsuspension:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Cabsuspension:keyEvent(unicode, sym, modifier, isDown)
end;

function Cabsuspension:update(dt)
	-- Cabsuspension animation
	if self.cab.rotNode ~= nil and self.wheels[3].repr ~= nil and self.wheels[4].repr ~= nil then
		local ax, ay, az = getTranslation(self.wheels[3].repr);
        local bx, by, bz = getTranslation(self.wheels[4].repr);
		local cx, cy, cz = getTranslation(self.wheels[1].repr);
		local dx, dy, dz = getTranslation(self.wheels[2].repr);

		local rotX, rotY, rotZ = getRotation(self.cab.rotNode);

		self.averageYTranslationCab = (ay + by)/2;
		self.averageYTranslationCabFront = (cy + dy)/2;

		self.averageYTranslationCabFront = self.averageYTranslationCabFront + self.frontAndRearWheelYTranslationDifference;

		if self.cabTranslation > self.averageYTranslationCab then
			self.cabTranslation = self.cabTranslation - self.maxTranslationPrCycleCabin * dt;
		elseif self.cabTranslation < self.averageYTranslationCab then
			self.cabTranslation = self.cabTranslation + self.maxTranslationPrCycleCabin * dt;
			if self.cabTranslation > self.averageYTranslationCab then
				self.cabTranslation = self.averageYTranslationCab;
			end;
		end;
		
		if self.cabXRot > -(math.atan2(self.averageYTranslationCab, self.averageYTranslationCabFront) - math.rad(45)) then
			self.cabXRot = self.cabXRot - self.maxTranslationPrCycleCabin * dt;
			if self.cabXRot < -(math.atan2(self.averageYTranslationCab, self.averageYTranslationCabFront) - math.rad(45)) then
				self.cabXRot = -(math.atan2(self.averageYTranslationCab, self.averageYTranslationCabFront) - math.rad(45));
			end;			
		elseif self.cabXRot < -(math.atan2(self.averageYTranslationCab, self.averageYTranslationCabFront) - math.rad(45)) then
			self.cabXRot = self.cabXRot + self.maxTranslationPrCycleCabin * dt;
			if self.cabXRot > -(math.atan2(self.averageYTranslationCab, self.averageYTranslationCabFront) - math.rad(45)) then
				self.cabXRot = -(math.atan2(self.averageYTranslationCab, self.averageYTranslationCabFront) - math.rad(45));
			end;			
		end;
		
		if self.cabZrot > -(math.atan2(ay, by) - math.rad(45)) then 
			self.cabZrot = self.cabZrot - self.maxTranslationPrCycleCabin * dt;
			if self.cabZrot < -(math.atan2(ay, by) - math.rad(45)) then 
				self.cabZrot = -(math.atan2(ay, by) - math.rad(45));
			end;
		elseif self.cabZrot < -(math.atan2(ay, by) - math.rad(45)) then 
			self.cabZrot = self.cabZrot + self.maxTranslationPrCycleCabin * dt;
			if self.cabZrot > -(math.atan2(ay, by) - math.rad(45)) then 
				self.cabZrot = -(math.atan2(ay, by) - math.rad(45));
			end;
		end;
			
		if self.cab.rotNode ~= nil then
			setTranslation(self.cab.rotNode, self.startCabXTranslation, self.cabTranslation + self.wheelYTranslationDifference, self.startCabZTranslation);
			self.cabXRot = math.max( Utils.degToRad(-4), math.min( Utils.degToRad(4), self.cabXRot ) );
			self.cabZrot = math.max( Utils.degToRad(-4), math.min( Utils.degToRad(4), self.cabZrot ) );
			setRotation(self.cab.rotNode, self.cabXRot, rotY, self.cabZrot);
		end;
	end;
end;

function Cabsuspension:updateTick(dt)

end;

function Cabsuspension:draw()
end;

function Cabsuspension:onLeave()

end;

function Cabsuspension:onEnter()

end;
