-- displayControl
--
-- Author RivalBomb
-- edit by STv-Modding in displayControl

displayControl = {};
function displayControl.prerequisitesPresent(specializations)
    return true;
end;

function displayControl:load(xmlFile)
	self.displayControl = {};
	
	local node = "vehicle.displayControl.";
	self.displayControl.warning = Utils.indexToObject(self.components, getXMLString(xmlFile, node.."warnLight#index"));
	self.displayControl.forward = Utils.indexToObject(self.components, getXMLString(xmlFile, node.."forward#index"));
	self.displayControl.reverse = Utils.indexToObject(self.components, getXMLString(xmlFile, node.."reverse#index"));
	self.displayControl.preHeating = Utils.indexToObject(self.components, getXMLString(xmlFile, node.."preHeating#index"));
	self.displayControl.battery = Utils.indexToObject(self.components, getXMLString(xmlFile, node.."battery#index"));
	self.displayControl.blinker1 = Utils.indexToObject(self.components, getXMLString(xmlFile, node.."blinker1#index"));
	self.displayControl.blinker2 = Utils.indexToObject(self.components, getXMLString(xmlFile, node.."blinker2#index"));
	
	self.displayControl.timer = 0; -- timer for warning light
	self.displayControl.warnBlinkSpeed = 500;	-- 0.5 sec
	self.displayControl.warningLightActive = true;
	self.hasAttachedTrailers = 0;
	
	-- interior turn lights
	self.interiorTS = {};
	self.interiorTS.t2 = 0;
	self.interiorTS.leftIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnSignals.interiorTurnSignals#left"));
	self.interiorTS.rightIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnSignals.interiorTurnSignals#right"));
	self.interiorTS.warnIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnSignals.interiorTurnSignals#hazard"));
	self.displayControl.t = 0;
end;

function displayControl:delete()
end;

function displayControl:mouseEvent(posX, posY, isDown, isUp, button)
end;

function displayControl:keyEvent(unicode, sym, modifier, isDown)
end;

function displayControl:update(dt)
	self.interiorTS.t2=self.interiorTS.t2+dt;
	if self.interiorTS.t2 > self.displayControl.warnBlinkSpeed then
		self.displayControl.warningLightActive = not self.displayControl.warningLightActive;
		self.interiorTS.t2=0;
	end;
	
	local mFlickering=Utils.clamp(math.cos( 7.0 * (g_currentMission.time/1000) ) + 0.2, 0, 1);
	if self:getIsActive() then
		if (self.turnSignalState == 1 or self.turnSignalState == 3) and mFlickering == 0  then 	-- Blinker links
			if self.interiorTS.leftIndex ~= nil then
				setVisibility(self.interiorTS.leftIndex, true);
			end;
		else
			if self.interiorTS.leftIndex ~= nil then
				setVisibility(self.interiorTS.leftIndex, false);
			end;
		end;
		if (self.turnSignalState == 2 or self.turnSignalState == 3) and mFlickering == 0 then	-- Blinker rechts
			if self.interiorTS.rightIndex ~= nil then
				setVisibility(self.interiorTS.rightIndex, true);
			end;
		else
			if self.interiorTS.rightIndex ~= nil then
				setVisibility(self.interiorTS.rightIndex, false);
			end;
		end;
		if self.turnSignalState == 3 and mFlickering == 0 then	-- Warnblinker
			if self.interiorTS.warnIndex ~= nil then
				setVisibility(self.interiorTS.warnIndex, true);
			end;
		else
			if self.interiorTS.warnIndex ~= nil then
				setVisibility(self.interiorTS.warnIndex, false);
			end;
		end;
		
		
			-- Forward / Reverse --
		if self:getLastSpeed() * self.speedDisplayScale > 1 and self.movingDirection > 0 then
			if self.displayControl.forward ~= nil then
				setVisibility(self.displayControl.forward, true);
			end;
		elseif self:getLastSpeed() * self.speedDisplayScale > 1 and self.movingDirection < 0 then
			if self.displayControl.reverse ~= nil then
				setVisibility(self.displayControl.reverse, true);
			end;
		else
			if self.displayControl.forward ~= nil then
				setVisibility(self.displayControl.forward, false);
			end;
			if self.displayControl.reverse ~= nil then
				setVisibility(self.displayControl.reverse, false);
			end;
		end;
		
		-- preHeating --
		if (self.ignitionMode ~= nil and self.ignitionMode == ManualIgnition.STAGE_PRE_HEAT) or (self.driveControl ~=nil and self.driveControl.manMotorStart.isMotorStarted ~= nil and self.driveControl.manMotorStart.isMotorStarted == false and self.driveControl.manMotorStart.startCnt ~= nil and self.driveControl.manMotorStart.startCnt < 800 and self.driveControl.manMotorStart.startCnt > 0) then 
			self.displayControl.t=self.displayControl.t+dt;
			if self.displayControl.preHeating ~= nil then
				if self.displayControl.t <= 2000 then
					setVisibility(self.displayControl.preHeating, true);
				else
					setVisibility(self.displayControl.preHeating, false);
				end;
			end;
			if self.displayControl.battery ~= nil then
				setVisibility(self.displayControl.battery, true);
			end;
			self.displayControl.timer = self.interiorTS.t2;
			if self.displayControl.timer >= self.displayControl.warnBlinkSpeed then
				self.displayControl.warningLightActive = not self.displayControl.warningLightActive;
				self.displayControl.timer=0;
			end;
			if self.displayControl.warning ~= nil then
				setVisibility(self.displayControl.warning, self.displayControl.warningLightActive);
				--setVisibility(self.displayControl.warning, true);
			end;
		else
			if self.displayControl.preHeating ~= nil then
				setVisibility(self.displayControl.preHeating, false);
				self.displayControl.t=0;
			end;
			if self.displayControl.battery ~= nil then
				setVisibility(self.displayControl.battery, false);
			end;
			if self.displayControl.warning ~= nil then
				self.displayControl.warningLightActive = false;
				setVisibility(self.displayControl.warning, self.displayControl.warningLightActive);
				--setVisibility(self.displayControl.warning, false);
			end;
		end;	
	end;
end;

function displayControl:updateTick(dt)

	-- blinker light 1 and 2 --
	if table.getn(self.attachedImplements) > 0 or self.hasAttachedTrailers > 0 then
		self.hasAttachedTrailers = 0;
		for i=1, table.getn(self.attachedImplements) do  
			if self.attachedImplements[i].object.turnSignals.left[1] ~= nil and self.attachedImplements[i].object.turnSignals.right[1] ~= nil then 
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			end;
			if table.getn(self.attachedImplements[i].object.attachedImplements) > 0 then
				for r=1, table.getn(self.attachedImplements[i].object.attachedImplements) do
					if self.attachedImplements[i].object.attachedImplements[r].object.turnSignals.left[1] ~= nil and self.attachedImplements[i].object.attachedImplements[r].object.turnSignals.right[1] ~= nil then 
						self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
					end;
				end;
			end;
		end;
	local mFlickering=Utils.clamp(math.cos( 7.0 * (g_currentMission.time/1000) ) + 0.2, 0, 1);
		if self.displayControl.blinker1 ~= nil and self.displayControl.blinker2 ~= nil then
			if self.turnSignalState ~= 0 then
				if self.hasAttachedTrailers == 0 then
					setVisibility(self.displayControl.blinker1, false);
					setVisibility(self.displayControl.blinker2, false);
				elseif self.hasAttachedTrailers == 1 then
					setVisibility(self.displayControl.blinker1, mFlickering == 0);
					setVisibility(self.displayControl.blinker2, false);
				elseif self.hasAttachedTrailers == 2 then
					setVisibility(self.displayControl.blinker1, mFlickering == 0);
					setVisibility(self.displayControl.blinker2, mFlickering == 0);
				end;
			else
				setVisibility(self.displayControl.blinker1, false);
				setVisibility(self.displayControl.blinker2, false);
			end;
		end;
	end;
end;

function displayControl:draw()
end;