--
-- InteractiveButtons
-- Specialization for an interactive control button
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.1
-- @date  		29/08/11
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--				v2.1 - improvements
--
-- free for noncommerical-usage
--

InteractiveButtons = InteractiveControlBase.newSpecialization();

function InteractiveButtons:load(xmlFile)
	local i=0;
	while true do
		local xmlName = string.format("vehicle.interactiveComponents.buttons.button(%d)", i);	
		if not hasXMLProperty(xmlFile, xmlName) then
			break;
		end;
		local event  = getXMLString(xmlFile, xmlName .. "#event");
		local setter = getXMLString(xmlFile, xmlName .. "#setFunction");
		local getter = getXMLString(xmlFile, xmlName .. "#getFunction");
		
		local button = Button:new(self, xmlFile, xmlName, event, setter, getter);
		table.insert(self.interactiveObjects, button);
		i = i + 1;
	end;
end;


--
-- Button Class
-- Specifies an interactive Button
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  29/08/11
--

Button = {};

function Button:new(vehicle, xmlFile, xmlName, event, setter, getter)

	local Button_mt = Class(Button, InteractiveComponentInterface);	
	
  local instance = InteractiveComponentInterface:new(vehicle, xmlFile, xmlName, Button_mt, event, setter, getter)

	if instance.event == "cablight" then
		event  = "cl.turnOn"
		getter = nil
		setter = "setCablight"
	end;

	return instance;	
end;

function Button:update(dt)
	if self.vehicle ~= nil and type( self.getStateFunction ) == "function" then
		local newState = self.getStateFunction( self.vehicle );
		if ( self.isOpen and not ( newState ) ) or ( newState and not ( self.isOpen ) ) then
			self:doAction(true, newState)
		end
	end;
	InteractiveComponentInterface.update(self, dt);
end;

function Button:draw()
	InteractiveComponentInterface.draw(self);
end;

function Button:doAction(noEventSend, forceAction)
	print("Button:doAction: "..tostring(self.isOpen))
	InteractiveComponentInterface.doAction(self, noEventSend, forceValue);
	if ( noEventSend == nil or not noEventSend ) and self.vehicle ~= nil and type( self.setStateFunction ) == "function" then
		self.setStateFunction( self.vehicle, self.isOpen );
	end
end;
