-- by modelleicher
-- www.schwabenmodding.bplaced.net
-- edit by STv-Modding-adapted for Deutz-

DeutzAnimations = {};

function DeutzAnimations.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function DeutzAnimations:load(xmlFile)
	-- Zapfwellenstummel / Powershaft rotation
	self.stummelIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.DeutzAnimations#zapfwellenStummelIndex"));
	
	-- Zapfwellenstummel2 / Powershaft2 rotation
	self.stummel2Index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.DeutzAnimations.Stummel2#zapfwellenStummel2Index"));
	
	-- Temperaturzeiger / temperature Display animation
	self.temperaturZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.DeutzAnimations.TemperaturZeiger#zeigerIndex"));
	self.temperaturZeigerMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.DeutzAnimations.TemperaturZeiger#maxRotation"));
	self.tempCnt = 0;
	
	-- Zustzliche Blinkleuchten in den Armaturen bei angehngten Anhngern / additional lights for turninglights at the dashboard if trailers attached
	self.blinkerLeuchte1L = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.DeutzAnimations.BlinkerLeuchten#leuchte1L"));
	self.blinkerLeuchte1R = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.DeutzAnimations.BlinkerLeuchten#leuchte1R"));
	self.blinkerLeuchte2L = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.DeutzAnimations.BlinkerLeuchten#leuchte2L"));
	self.blinkerLeuchte2R = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.DeutzAnimations.BlinkerLeuchten#leuchte2R"));
	self.hasAttachedTrailers = 0;
	setVisibility(self.blinkerLeuchte1L, false);
	setVisibility(self.blinkerLeuchte2L, false);
	setVisibility(self.blinkerLeuchte1R, false);
	setVisibility(self.blinkerLeuchte2R, false);
	
	self.blinkerHebel = {};
	self.blinkerHebel.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.DeutzAnimations.blinkerhebel#index"))
	self.blinkerHebel.rotLeft = getXMLString(xmlFile, "vehicle.DeutzAnimations.blinkerhebel#rotLeft");
	self.blinkerHebel.rotRight = getXMLString(xmlFile, "vehicle.DeutzAnimations.blinkerhebel#rotRight");
	self.blinkerHebel.rotNormal = getXMLString(xmlFile, "vehicle.DeutzAnimations.blinkerhebel#rotNormal");
end;

function DeutzAnimations:delete()
end;

function DeutzAnimations:mouseEvent(posX, posY, isDown, isUp, button)
end;
function DeutzAnimations:keyEvent(unicode, sym, modifier, isDown)
end;

function DeutzAnimations:updateTick(dt)
	-- Zustzliche Blinkleuchten in den Armaturen bei angehngten Anhngern / additional lights for turninglights at the dashboard if trailers attached
	if table.getn(self.attachedImplements) > 0 or self.hasAttachedTrailers > 0 then
		self.hasAttachedTrailers = 0;
		for i=1, table.getn(self.attachedImplements) do  
			if self.attachedImplements[i].object.lastFillDelta ~= nil then -- "catch" all trailers 
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			elseif self.attachedImplements[i].object.isSprayerFilling ~= nil and self.attachedImplements[i].object.wheels[1] ~= nil then -- "catch" manure and dung spreader with wheels --> "trailers", too
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			end;
			if table.getn(self.attachedImplements[i].object.attachedImplements) > 0 then -- maybe the trailer has also attached a trailer.. 
				for r=1, table.getn(self.attachedImplements[i].object.attachedImplements) do
					if self.attachedImplements[i].object.attachedImplements[r].object.lastFillDelta ~= nil then -- "catch" attached trailer at the trailer here
						self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
					end;
				end;
			end;
		end;
		if self.hasAttachedTrailers == 0 then
			setVisibility(self.blinkerLeuchte1L, false);
			setVisibility(self.blinkerLeuchte2L, false);
			setVisibility(self.blinkerLeuchte1R, false);
			setVisibility(self.blinkerLeuchte2R, false);
		elseif self.hasAttachedTrailers == 1 then
			setVisibility(self.blinkerLeuchte1L, true);
			setVisibility(self.blinkerLeuchte2L, false);
			setVisibility(self.blinkerLeuchte1R, true);
			setVisibility(self.blinkerLeuchte2R, false);			
		elseif self.hasAttachedTrailers == 2 then
			setVisibility(self.blinkerLeuchte1L, true);
			setVisibility(self.blinkerLeuchte2L, true);	
			setVisibility(self.blinkerLeuchte1R, true);
			setVisibility(self.blinkerLeuchte2R, true);			
		end;
	end;
	if self.turnSignalState~=nil then
		if self.turnSignalState==1 then	-- Blinker links
			setRotation(self.blinkerHebel.index, 0, 0, math.rad(self.blinkerHebel.rotLeft));
		elseif self.turnSignalState==2 then	-- Blinker rechts
			setRotation(self.blinkerHebel.index, 0, 0, math.rad(self.blinkerHebel.rotRight));
		else -- kein Blinker aktiv / Warnblinker
			setRotation(self.blinkerHebel.index, 0, 0, math.rad(self.blinkerHebel.rotNormal));
		end;
    end;
end;

function DeutzAnimations:update(dt)

	if self:getIsActive() then
		if self.isMotorStarted then
			-- Ladekontrollleuchte / Batterie load light
			-- if self.ladeLeuchteOn == 1 then
				-- setVisibility(self.ladeLeuchte, true);
				-- if self.movingDirection ~= 0 then
					-- self.timerTrue = true;
				-- end;
				-- if self.timerTrue then
					-- self.ladeTimer = math.max(self.ladeTimer - 0.01, 0);
				-- end;
				-- if self.ladeTimer == 0 then
					-- setVisibility(self.ladeLeuchte, false);
					-- self.timerTrue = nil;
					-- self.ladeLeuchteOn = 0;
					-- self.ladeTimer = 0.1;
				-- end;
			-- end;
			
			-- Zapfwellenstummel / Powershaft rotation
			rotate(self.stummelIndex, 0,0,0.001*dt);
			
			-- Zapfwellenstummel2 / Powershaft2 rotation
			rotate(self.stummel2Index, 0,0,0.001*dt);
			
			-- Temperaturanzeiger / temperature display animation und / and berechnung / calculation
			if self.tempCnt < 3000 then
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = self.tempCnt + 0.5;
			elseif self.tempCnt > 3000 and self.tempCnt < 6000 then
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = math.min(self.tempCnt + 0.2, 10000);			
			else
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = math.min(self.tempCnt + 0.05, 10000);
			end;
		end;
	else
		self.tempCnt = math.max(self.tempCnt - 0.08, 0);
		
	end;
end;

function DeutzAnimations:draw()	
end;