--
-- ControlPanelAttacher
-- Specialization for a ControlPanelAttacher functionality
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to 2011 and some bugfixes
--				v4.0 - by Mogli: converted to 2015 and some improvements
--

ControlPanelAttacher = {};

function ControlPanelAttacher.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function ControlPanelAttacher:load(xmlFile)

	self.addControlPanel = SpecializationUtil.callSpecializationsFunction("addControlPanel");
	self.removeControlPanel = SpecializationUtil.callSpecializationsFunction("removeControlPanel");
	
	local controlPanelCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.controlPanels#count"), 0);
	
	i = 0
	while true do
		local controlPanelName = string.format("vehicle.controlPanels.controlPanel(%d)", i);	
		local nodeIndex        = getXMLString(xmlFile, controlPanelName .. "#index")
		if nodeIndex == nil then
			break
		end
		
		local controlPanel = {};
		controlPanel.node = Utils.indexToObject(self.components, nodeIndex);
		
		controlPanel.loaded = nil;
		controlPanel.implement = nil;
		
		if self.controlPanels == nil then
			self.controlPanels = {}
		end
		
		i = i + 1
		table.insert(self.controlPanels, controlPanel);
	end;

end;

function ControlPanelAttacher:delete()
end;

function ControlPanelAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ControlPanelAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function ControlPanelAttacher:update(dt)		
end;

function ControlPanelAttacher:draw()
end;

