--06/09/2015 edit --07/01/2016 
--Author: Fabyte Modding, edit by STv-Modding
--Specialization for Alpego Supports
--Extra Specialization for Bonnet Tractors

trigger_animation = {};

function trigger_animation.prerequisitesPresent(specializations)
    return true;
end;

function trigger_animation:load(xmlFile)
	self.controlTrigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlTrigger#index"));
	self.controlTrigger2 = Utils.indexToObject (self.components, getXMLString(xmlFile, "vehicle.controlTrigger2#index"));
	addTrigger(self.controlTrigger, "ControlTriggerCallback", self); 
	addTrigger(self.controlTrigger2, "ControlTriggerCallback2", self);
	self.playerIsInControlTrigger = false;
	self.playerIsInControlTrigger2 = false;
	self.supportLeftLowered = true;
	self.supportRightLowered = true;
	
	self.supportSound = Utils.loadSample(xmlFile, {}, "vehicle.supportSound", nil, self.baseDirectory);

	
end;



function trigger_animation:ControlTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		if onEnter then
			self.playerIsInControlTrigger = true;
		elseif onLeave then
			self.playerIsInControlTrigger = false;
		end;
	end;
end;

function trigger_animation:ControlTriggerCallback2(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		if onEnter then
			self.playerIsInControlTrigger2 = true;
		elseif onLeave then
			self.playerIsInControlTrigger2 = false;
		end;
	end;
end;

function trigger_animation:delete()
removeTrigger(self.controlTrigger); 
removeTrigger(self.controlTrigger2);
Utils.deleteSample(self.supportSound);
end;

function trigger_animation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function trigger_animation:keyEvent(unicode, sym, modifier, isDown)
end;

function trigger_animation:update(dt)
	if g_currentMission.player ~= nil and g_currentMission.player.isEntered then 
		local px, py, pz = getWorldTranslation(g_currentMission.player.rootNode); 
		local tx, ty, tz = getWorldTranslation(self.controlTrigger);
		local t2x, t2y, t2z = getWorldTranslation(self.controlTrigger2);
		if Utils.vector3Length(px-tx, py-ty, pz-tz) < 2.5 then
			g_currentMission:addHelpButtonText(g_i18n:getText("BONNET_UP_DOWN"), InputBinding.SUPPORT_UP_DOWN);
			if InputBinding.hasEvent(InputBinding.SUPPORT_UP_DOWN) then
				if self.supportLeftLowered == true then
					self:playAnimation("bonnet", 1);
					Utils.playSample(self.supportSound, 1, 0);
					self.supportLeftLowered = false
				elseif self.supportLeftLowered == false then
					self:playAnimation("bonnet", -1);
					Utils.playSample(self.supportSound, 1, 0);
					self.supportLeftLowered = true
				end;
			end;
		elseif Utils.vector3Length(px-t2x, py-t2y, pz-t2z) < 2.5 then
			g_currentMission:addHelpButtonText(g_i18n:getText("BONNET_UP_DOWN"), InputBinding.SUPPORT_UP_DOWN);
			if InputBinding.hasEvent(InputBinding.SUPPORT_UP_DOWN) then
				if self.supportRightLowered == true then
					self:playAnimation("bonnet", -1);
					Utils.playSample(self.supportSound, 1, 0);
					self.supportRightLowered = false
				elseif self.supportRightLowered == false then
					self:playAnimation("bonnet", 1);
					Utils.playSample(self.supportSound, 1, 0);
					self.supportRightLowered = true
				end;
			end;
		end;
	end;
end;


function trigger_animation:updateTick(dt)
end;

function trigger_animation:draw()	
end;
