--[[
	IncreaseRPMWhileTipping_Register.lua
	
	Autor: Ifko[nator]
	Datum: 31.10.2015
]]

local currentModName = g_currentModName;
local allowRegister = false;

local modDesc = loadXMLFile("modDesc", g_currentModDirectory .. "modDesc.xml");
local version = Utils.getNoNil(getXMLString(modDesc, "modDesc.version"), "Keine Versionsnummer gefunden!");

if SpecializationUtil.getSpecialization("increaseRPMWhileTippingDummy") == nil then
	--## make sure this script will run only once, even it is implemented in more mods, e.g. in an extra global mod
	
	--## dummy to check if IncreaseRPMWhileTipping_Register script is already loaded or not
	SpecializationUtil.registerSpecialization("increaseRPMWhileTippingDummy", "IncreaseRPMWhileTipping", g_currentModDirectory .. "scripts/IncreaseRPMWhileTipping.lua");
	
	--## here will be the real script registered
	SpecializationUtil.registerSpecialization("increaseRPMWhileTipping", "IncreaseRPMWhileTipping", g_currentModDirectory .. "scripts/IncreaseRPMWhileTipping.lua");
	allowRegister = true;
else
	print("	increaseRPMWhileTipping is already exsit. Stop register from Mod: '" .. currentModName .. "' now!");
end;

IncreaseRPMWhileTipping_Register = {};

function IncreaseRPMWhileTipping_Register:loadMap(name)
	if self.firstRun == nil and allowRegister then
		self.firstRun = false;
		
		print("");
		print("---------------Info from the IncreaseRPMWhileTipping_Register script start--------------------");
		print("");
		print("	---!!! ATTENTION !!!--- Installing now the 'IncreaseRPMWhileTipping' Script in Version " .. version .. " by Ifko[nator].");
		print("	Installing the Script from Mod: '" .. currentModName .. "' to ANY vehicle witch is 'drivable' or 'attachable', this should happen only once!");
		print("");
		print("---------------Info from the IncreaseRPMWhileTipping_Register script end----------------------");
		print("");
		
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					--## standard lua's
					
					if vs ~= nil and (vs == SpecializationUtil.getSpecialization("drivable") or vs == SpecializationUtil.getSpecialization("attachable")) then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							--## mod lua's
							
							if rawget(SpecializationUtil.specializations, string.format("%s.IncreaseRPMWhileTipping", _name)) ~= nil 
								or rawget(SpecializationUtil.specializations, string.format("%s.increaseRPMWhileTipping", _name)) ~= nil 
							then
								allowInsertion = false;
							end;
						end;
						if allowInsertion then
							table.insert(v.specializations, SpecializationUtil.getSpecialization("increaseRPMWhileTipping"));
							--print("installing 'IncreaseRPMWhileTipping' to: '" .. v_name_string .. "'.");
						end;
					end;
				end;
			end;	
		end;
	end;
end;

function IncreaseRPMWhileTipping_Register:deleteMap()end;
function IncreaseRPMWhileTipping_Register:keyEvent(unicode, sym, modifier, isDown)end;
function IncreaseRPMWhileTipping_Register:mouseEvent(posX, posY, isDown, isUp, button)end;
function IncreaseRPMWhileTipping_Register:update(dt)end;
function IncreaseRPMWhileTipping_Register:draw()end;

addModEventListener(IncreaseRPMWhileTipping_Register);