

CaseIH = {};

function CaseIH.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function CaseIH:load(xmlFile)
	self.CaseIHPresse = SpecializationUtil.callSpecializationsFunction("CaseIHPresse");
	
	self.wheatParticleSystems = {};
	local i=0;
	while true do
		local key = string.format("vehicle.CaseIH.Straw(%d)", i);
		local node = getXMLString(xmlFile, key.. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key.. "#file");
			local wheatParticleSystem = {};
			wheatParticleSystem.particleSystem = {};
			StaticParticleSystem.loadParticleSystem(xmlFile, wheatParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.wheatParticleSystems, wheatParticleSystem);
		end;
		i = i+1;
	end;
	
	self.dryGrassParticleSystems = {};
	local i=0;
	while true do
		local key = string.format("vehicle.CaseIH.dryGrass(%d)", i);
		local node = getXMLString(xmlFile, key.. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key.. "#file");
			local dryGrassParticleSystem = {};
			dryGrassParticleSystem.particleSystem = {};
			StaticParticleSystem.loadParticleSystem(xmlFile, dryGrassParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.dryGrassParticleSystems, dryGrassParticleSystem);
		end;
		i = i+1;
	end;
	
	self.extraParticleSystems = {};
	local i=0;
	while true do
		local key = string.format("vehicle.CaseIH.extraParticleSystem(%d)", i);
		local node = getXMLString(xmlFile, key.. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key.. "#file");
			local extraParticleSystem = {};
			extraParticleSystem.particleSystem = {};
			Utils.loadParticleSystem(xmlFile, extraParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.extraParticleSystems, extraParticleSystem);
		end;
		i = i+1;
	end;
end;

function CaseIH:delete()
	for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
		Utils.setEmittingState(wheatParticleSystem.particleSystem, false);
	end;
	for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
		Utils.setEmittingState(dryGrassParticleSystem.particleSystem, false);
	end;
	for _, extraParticleSystem in pairs(self.extraParticleSystems) do
		Utils.deleteParticleSystem(extraParticleSystem.particleSystem);
	end;
end;

function CaseIH:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CaseIH:keyEvent(unicode, sym, modifier, isDown)
end;

function CaseIH:update(dt)
end;

function CaseIH:updateTick(dt)
	if  self.previousLevel ~= self.fillLevel then
		self.previousLevel = self.fillLevel;
		self:CaseIHPresse(3, true);
	else
		self:CaseIHPresse(3, false);
	end;
end;
	
function CaseIH:draw()
end;

function CaseIH:CaseIHPresse(mode, state, noEventSend)
	if  mode == 3 and self.isTurnedOn then
		if  state then
			for _, extraParticleSystem in pairs(self.extraParticleSystems) do
				Utils.setEmittingState(extraParticleSystem.particleSystem, true);
			end;
			if FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_WHEAT or FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_BARLEY then
				for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
					Utils.setEmittingState(wheatParticleSystem.particleSystem, true);
				end;
			elseif FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_DRYGRASS then
				for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
					Utils.setEmittingState(dryGrassParticleSystem.particleSystem, true);
				end;
			end;
		else
			for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
				Utils.setEmittingState(wheatParticleSystem.particleSystem, false);
			end;
			for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
				Utils.setEmittingState(dryGrassParticleSystem.particleSystem, false);
			end;
			for _, extraParticleSystem in pairs(self.extraParticleSystems) do
				Utils.setEmittingState(extraParticleSystem.particleSystem, false);
			end;
		end;
	else
		for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
			Utils.setEmittingState(wheatParticleSystem.particleSystem, false);
		end;
		for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
			Utils.setEmittingState(dryGrassParticleSystem.particleSystem, false);
		end;
		for _, extraParticleSystem in pairs(self.extraParticleSystems) do
			Utils.setEmittingState(extraParticleSystem.particleSystem, false);
		end;
	end;	
end;

-------------------------------------------------------------------------------------------------------------------------------------
-- StaticParticleSystem fr die CaseIH

StaticParticleSystem = {};

function StaticParticleSystem.loadParticleSystem(xmlFile, particleSystemTable, baseString, component, currentEmittingState, defaultParticleSystem, directory)
	local defaultLinkNode = component;
	local isStatic = Utils.getNoNil(isStaticParticle, false);
	local posStr = getXMLString(xmlFile, baseString .. "#position");
    local rotStr = getXMLString(xmlFile, baseString .. "#rotation");
	if type(component) == "table" then
		defaultLinkNode = component[1].node;
	end;
	local linkNode = Utils.getNoNil(Utils.indexToObject(component, getXMLString(xmlFile, baseString .. "#node")), defaultLinkNode);
	local psFile = getXMLString(xmlFile, baseString .. "#file");
	if psFile == nil then
		psFile = defaultParticleSystem;
	end
	if psFile == nil then
		return;
	end
	psFile = Utils.getFilename(psFile, directory);
	local rootNode = loadI3DFile(psFile);
	if rootNode == 0 then
		print("[ERROR der CaseIH.lua]: Das ParticleSystem '"..psFile.."' konnte nicht geladen werden. Dieses ParticleSystem ist daher inakiv.");
		return;
	end
	link(linkNode, rootNode);
	if posStr ~= nil and rotStr ~= nil then
		local posX, posY, posZ = Utils.getVectorFromString(posStr);
		local rotX, rotY, rotZ = Utils.getVectorFromString(rotStr);
		if posStr ~= nil and rotStr ~= nil then
			rotX = Utils.degToRad(rotX);
			rotY = Utils.degToRad(rotY);
			rotZ = Utils.degToRad(rotZ);
			setTranslation(rootNode, posX, posY, posZ);
			setRotation(rootNode, rotX, rotY, rotZ);
		end;
	end;
	for i=0, getNumOfChildren(rootNode)-1 do
		local child = getChildAt(rootNode, i);
		if getClassName(child) == "Shape" then
			local geometry = getGeometry(child);
			if geometry ~= 0 then
				if getClassName(geometry) == "ParticleSystem" then
					table.insert(particleSystemTable, {geometry = geometry, shape = child});
					if currentEmittingState ~= nil then
						setEmittingState(geometry, currentEmittingState);
					end;
				end;
			end;
		end;
	end;
	return rootNode;
end;