variableScarico = {};
function variableScarico.prerequisitesPresent(specializations) return true; end;
function variableScarico:load(xmlFile)
	self.controlTrigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlTrigger#controlTriggerIndex"));
	addTrigger(self.controlTrigger, "ControlTriggerCallback", self); self.playerIsInControlTrigger = false;	self.setcurrentScarico = SpecializationUtil.callSpecializationsFunction("setcurrentScarico"); self.currentScarico = 0;
	self.SprayStartIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workAreas.workArea#startIndex")); self.SprayHeightIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workAreas.workArea#heightIndex")); self.SprayAiLeftMarker = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index")); self.SprayWidthIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workAreas.workArea#widthIndex")); self.SprayAiRightMarker = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiRightMarker#index"));end;
function variableScarico:delete() removeTrigger(self.controlTrigger); end;
function variableScarico:readStream(streamId, connection) self:setcurrentScarico(streamReadInt8(streamId), true); end;
function variableScarico:writeStream(streamId, connection) streamWriteInt8(streamId, self.currentScarico); end;
function variableScarico:setcurrentScarico(int, noEventSend) self.currentScarico = int; setcurrentScaricoEvent.sendEvent(self, int, noEventSend); end;
function variableScarico:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local currentScarico = getXMLInt(xmlFile, key .. "#currentScarico"); if currentScarico ~= nil then self:setcurrentScarico(currentScarico-1); end;
	return BaseMission.VEHICLE_LOAD_OK; end;
function variableScarico:getSaveAttributesAndNodes(nodeIdent) local attributes = 'currentScarico="' .. self.currentScarico .. '"'; return attributes; end;
function variableScarico:mouseEvent(posX, posY, isDown, isUp, button) end;
function variableScarico:keyEvent(unicode, sym, modifier, isDown) end;
function variableScarico:update(dt) if g_currentMission.player ~= nil and g_currentMission.player.isEntered then
	local px, py, pz = getWorldTranslation(g_currentMission.player.rootNode); local tx, ty, tz = getWorldTranslation(self.controlTrigger);
	if Utils.vector3Length(px-tx, py-ty, pz-tz) < 2 and not self.isTurnedOn then g_currentMission:addHelpButtonText(g_i18n:getText("variableScarico"), InputBinding.CAMERA_SWITCH); 
	if InputBinding.hasEvent(InputBinding.CAMERA_SWITCH) then if self.currentScarico == 1 then self:setcurrentScarico(2);	elseif self.currentScarico > 1 then self:setcurrentScarico(0); end; end;
	if self.currentScarico == 5 and InputBinding.hasEvent(InputBinding.TOGGLE_TURNSIGNAL_RIGHT) then self:setcurrentScarico(2);	end; if self.currentScarico == 3 and InputBinding.hasEvent(InputBinding.TOGGLE_TURNSIGNAL_LEFT) then self:setcurrentScarico(4); end;
	if self.currentScarico > 1 then g_currentMission:addHelpButtonText(g_i18n:getText("scaricoDestra"), InputBinding.TOGGLE_TURNSIGNAL_RIGHT); g_currentMission:addHelpButtonText(g_i18n:getText("scaricoSinistra"), InputBinding.TOGGLE_TURNSIGNAL_LEFT); end; end; end; end;
function variableScarico:updateTick(dt)
	if self.currentScarico == 0 then self:playAnimation("Ventaglio", 1, nil, true); self.currentScarico = 1; setTranslation(self.SprayWidthIndex, -7, 0, -5.419); setTranslation(self.SprayHeightIndex, 7, 0, -5.419); setTranslation(self.SprayAiRightMarker, -7, 0, -4.433); setTranslation(self.SprayAiLeftMarker, 7, 0, -4.433); setTranslation(self.SprayStartIndex, 7, 0, -4.433);
	elseif self.currentScarico == 2 then self:playAnimation("CurvaDestra", 1, nil, true); self.currentScarico = 3; setTranslation(self.SprayWidthIndex, -7, 0, -5.419); setTranslation(self.SprayHeightIndex, -1, 0, -5.419); setTranslation(self.SprayAiRightMarker, -7, 0, -4.433); setTranslation(self.SprayAiLeftMarker, -1, 0, -4.433); setTranslation(self.SprayStartIndex, -1, 0, -4.433); 
	elseif self.currentScarico == 4 then self:playAnimation("CurvaSinistra", 1, nil, true); self.currentScarico = 5; setTranslation(self.SprayWidthIndex, 1, 0, -4.433); setTranslation(self.SprayHeightIndex, 7, 0, -4.433); setTranslation(self.SprayAiRightMarker, 1, 0, -5.419); setTranslation(self.SprayAiLeftMarker, 7, 0, -5.419); setTranslation(self.SprayStartIndex, 1, 0, -4.433); end; end;
function variableScarico:onAttach(attacherVehicle, jointDescIndex) end;
function variableScarico:onDetach() end;
function variableScarico:draw() end;
function variableScarico:ControlTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if g_currentMission.player ~= nil then if g_currentMission.player.isEntered then if onEnter then self.playerIsInControlTrigger = true; elseif onLeave then self.playerIsInControlTrigger = false; end; end; end; end;
setcurrentScaricoEvent = {}; setcurrentScaricoEvent_mt = Class(setcurrentScaricoEvent, Event); InitEventClass(setcurrentScaricoEvent, "setcurrentScaricoEvent");
function setcurrentScaricoEvent:emptyNew() local self = Event:new(setcurrentScaricoEvent_mt); self.className="setcurrentScaricoEvent"; return self; end;
function setcurrentScaricoEvent:new(vehicle, currentScarico) local self = setcurrentScaricoEvent:emptyNew() self.vehicle = vehicle; self.currentScarico = currentScarico; return self; end;
function setcurrentScaricoEvent:readStream(streamId, connection) local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id); self.currentScarico = streamReadInt8(streamId); self.vehicle:setcurrentScarico(self.currentScarico, true);
	if not connection:getIsServer() then g_server:broadcastEvent(setcurrentScaricoEvent:new(self.vehicle, self.currentScarico), nil, connection, self.vehicle); end; end;
function setcurrentScaricoEvent:writeStream(streamId, connection) streamWriteInt32(streamId, networkGetObjectId(self.vehicle)); streamWriteInt8(streamId, self.currentScarico); end;
function setcurrentScaricoEvent.sendEvent(vehicle, currentScarico, noEventSend)	if noEventSend == nil or noEventSend == false then
	if g_server ~= nil then	g_server:broadcastEvent(setcurrentScaricoEvent:new(vehicle, currentScarico), nil, nil, vehicle);
	else g_client:getServerConnection():sendEvent(setcurrentScaricoEvent:new(vehicle, currentScarico)); end; end; end;