-- author: rafftnix
-- date: 10.08.2015

-- helps to animate a PTO with movingParts

MovingPartsPTO = {};

function MovingPartsPTO.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cylindered, specializations);
end;

function MovingPartsPTO:load(xmlFile)
	self.movingPartsPTONode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.movingPartsPTO#linkNodeIndex"));
	self.movingPartsPTONodeDetach = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.movingPartsPTO#detachLinkNodeIndex"));
	self.movingPartsPTOAttachPos = Utils.getVectorNFromString(getXMLString(xmlFile, "vehicle.movingPartsPTO#linkNodePos"), 3);
end;

function MovingPartsPTO:postLoad(xmlFile)
	MovingPartsPTO.onDetach(self);
end;

function MovingPartsPTO:delete()
end;

function MovingPartsPTO:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MovingPartsPTO:keyEvent(unicode, sym, modifier, isDown)
end;

function MovingPartsPTO:update(dt)
end;

function MovingPartsPTO:onAttach(attacherVehicle, jointDescIndex)
	local ptoAttacherNode = attacherVehicle.attacherJoints[jointDescIndex].ptoOutput.node;
	link(ptoAttacherNode, self.movingPartsPTONode);
	setTranslation(self.movingPartsPTONode, unpack(self.movingPartsPTOAttachPos));
	setRotation(self.movingPartsPTONode, math.rad(180), 0, 0);
end;

function MovingPartsPTO:onDetach(attacherVehicle, jointDescIndex)
	link(self.movingPartsPTONodeDetach, self.movingPartsPTONode);
	setTranslation(self.movingPartsPTONode, 0, 0, 0);
	setRotation(self.movingPartsPTONode, 0, 0, 0);
	for _, part in pairs(self.activeDirtyMovingParts) do
		Cylindered.updateMovingPart(self, part, false);
	end
end;

function MovingPartsPTO:draw()
end;