-- Change AllRad v.4  state event-class @Fix Ago-Systemtech (TIF) ---
AllradStateEvent = {};
AllradStateEvent_mt = Class(AllradStateEvent, Event);

InitEventClass(AllradStateEvent, "AllradStateEvent");

function AllradStateEvent:emptyNew() 
    local self = Event:new(AllradStateEvent_mt );
    self.className="AllradStateEvent";
    return self;
end;

function AllradStateEvent:new(vehicle, state) 
    self.vehicle = vehicle;
    self.state = state;
    return self;
end;

function AllradStateEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.state = streamReadBool(streamId); 
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;

function AllradStateEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteBool(streamId, self.state );   
end;

function AllradStateEvent:run(connection)  
    self.vehicle:allradState(self.state, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(AllradStateEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function AllradStateEvent.sendEvent(vehicle, state, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then  
			g_server:broadcastEvent(AllradStateEvent:new(vehicle, state), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(AllradStateEvent:new(vehicle, state));
		end;
	end;
end;
