

Godet = {};

source("dataS/scripts/vehicles/specializations/SetTurnedOnEvent.lua");
source("dataS/scripts/vehicles/specializations/PloughAreaEvent.lua");

  
function Godet.prerequisitesPresent(specializations)
      return true;
end;

function Godet:load(xmlFile)


  		assert(self.setIsTurnedOn == nil, "Sprayer needs to be the first specialization which implements setIsTurnedOn");
        self.setIsTurnedOn = Godet.setIsTurnedOn;
        self.isTurnedOn = false;
		self.activation = false;
		
		
		
		self.terrassement = false;
        self.terrassementNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.terrassement#index"));

        


      
        self.aiTerrainDetailChannel1 = g_currentMission.ploughChannel;
        self.aiTerrainDetailChannel2 = g_currentMission.sowingChannel;
    
        self.fillremplissage = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillremplissage"), 500);
        

            
end;
  
function Godet:delete()


   end;
   
   
   function Godet:readStream(streamId, connection)
          local turnedOn = streamReadBool(streamId);
       self:setIsTurnedOn(turnedOn, true);
end;
 
function Godet:writeStream(streamId, connection)
streamWriteBool(streamId, self.isTurnedOn);
end;
 
 
   function Godet:mouseEvent(posX, posY, isDown, isUp, button)
   end;
 
   function Godet:keyEvent(unicode, sym, modifier, isDown)

   end;
 
   function Godet:update(dt)
     
             if self.isClient then
           if self:getIsActiveForInput() then
               if InputBinding.hasEvent(InputBinding.Godet) then
                   self:setIsTurnedOn(not self.isTurnedOn);
               end;
           end;
       end;
       
        if self.isTurnedOn then
			self.activation = true ;
		else	
			 self.activation = false;
		end;
   end;
 
   function Godet:updateTick(dt)
   
       if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.Godet) then
        	self.activation = not self.activation;
        end;
    end;

   
      


   



                        local x,y,z = getWorldTranslation(self.terrassementNode);
                        local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
						if y<= terrainHeight then
							self.terrassement = true;
						else
							self.terrassement = false;
						end;


           if self.terrassement then
			if self.movingDirection == 1 then
               if self.activation then
                if self.fillLevel ~= self.capacity then
                          local workAreasSend = {};
                          for k, workArea in pairs(self.workAreas) do
                               if self:getIsAreaActive(workArea) then

                                   local x,y,z = getWorldTranslation(workArea.start);
                                   local x1,y1,z1 = getWorldTranslation(workArea.width);
                                   local x2,y2,z2 = getWorldTranslation(workArea.height);
                                   --Utils.updatePloughArea(x, z, x1, z1, x2, z2, not self.PloughLimitToField);
                                   table.insert(workAreasSend, {x,z,x1,z1,x2,z2});
                               end;
                           end;
                           if (table.getn(workAreasSend) > 0) then
                               local realArea = PloughAreaEvent.runLocally(workAreasSend, limitToField, limitGrassDestructionToField, angle);
                               local usage = self.fillremplissage * dt*0.001;
                               local usedFruitType = FruitUtil.FRUITTYPE_DIRT;
                               local usedFillType = FruitUtil.fruitTypeToFillType[usedFruitType];                                                                             
                               self:setFillLevel(self.fillLevel + usage, usedFillType);
                              end; 
                        
                        end;
                         end;
                            end;
                               end;
         
   end;
 
   function Godet:draw()
       if self.activation then
		g_currentMission:addHelpButtonText(g_i18n:getText("TerrOff"), InputBinding.Godet);
		else
		g_currentMission:addHelpButtonText(g_i18n:getText("TerrOn"), InputBinding.Godet);
    end;
    
   end;
 

   function Godet:onAttach(attacherVehicle)
  end;
  
   function Godet:onDetach()
   end;
 
   function Godet:onActivate()
   end;
 
   function Godet:onDeactivate()       
   end;
 
   function Godet:onDeactivateSounds()
   end;
 
   function Godet:aiRotateLeft()
   end;
 
   function Godet:aiRotateRight()
   end;
 
   function Godet:aiTurnOn()
   end;
 
   function Godet:aiTurnOff()
   end;
 
   function Godet:aiInvertsMarkerOnTurn(turnLeft)
   end;
 
 
 

   function Godet:setRotationMax(rotationMax, noEventSend)
   end;
   
   
      function Godet:setIsTurnedOn(isTurnedOn, noEventSend)

               SetTurnedOnEvent.sendEvent(self, isTurnedOn, noEventSend)
   
               self.isTurnedOn = isTurnedOn;
 
              

   end;
   
      function Godet:onDeactivate()
   self.isTurnedOn = false;
   end;
   
      function Godet:onLeave()
      self.isTurnedOn = false;
	end;  



