
HonkV2 = {};
source("dataS/scripts/vehicles/specializations/HonkEvent.lua");

function HonkV2.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function HonkV2:load(xmlFile)
	self.playHonkV2 = SpecializationUtil.callSpecializationsFunction("playHonkV2");
	self.playHonkV22 = SpecializationUtil.callSpecializationsFunction("playHonkV22");
	local HonkV2SoundFile = getXMLString(xmlFile, "vehicle.HonkLoopSound#file");
	local clientHonkV2SoundFile = getXMLString(xmlFile, "vehicle.HonkLoopSound#client");
	local HonkV2Sound2File = getXMLString(xmlFile, "vehicle.HonkLoopSound2#file");
	local clientHonkV2Sound2File = getXMLString(xmlFile, "vehicle.HonkLoopSound2#client");
	if clientHonkV2SoundFile == nil then
		clientHonkV2SoundFile = HonkV2SoundFile;
	end;
	if clientHonkV2Sound2File == nil then
		clientHonkV2Sound2File = HonkV2Sound2File;
	end;
	if HonkV2SoundFile ~= nil then
		HonkV2SoundFile = Utils.getFilename(HonkV2SoundFile, self.baseDirectory);
		clientHonkV2SoundFile = Utils.getFilename(clientHonkV2SoundFile, self.baseDirectory);
		self.HonkV2SoundId = createSample("HonkV2Sound");
		loadSample(self.HonkV2SoundId, HonkV2SoundFile, false);
		self.HonkV2SoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.HonkLoopSound#volume"), 1.0);
		self.HonkV2SoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.HonkLoopSound#radius"), 50);
		self.HonkV2SoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.HonkLoopSound#innerRadius"), 10);
		self.clientHonkV2Sound = createAudioSource("clientHonkV2Sound", clientHonkV2SoundFile, self.HonkV2SoundRadius, self.HonkV2SoundInnerRadius, self.HonkV2SoundVolume, 0);
		link(self.components[1].node, self.clientHonkV2Sound);
		setVisibility(self.clientHonkV2Sound, false);
		self.HonkV2Playing = false;
	end;
	if HonkV2Sound2File ~= nil then
		HonkV2Sound2File = Utils.getFilename(HonkV2Sound2File, self.baseDirectory);
		clientHonkV2Sound2File = Utils.getFilename(clientHonkV2Sound2File, self.baseDirectory);
		self.HonkV2Sound2Id = createSample("HonkV2Sound2");
		loadSample(self.HonkV2Sound2Id, HonkV2Sound2File, false);
		self.HonkV2Sound2Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.HonkLoopSound2#volume"), 1.0);
		self.HonkV2Sound2Radius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.HonkLoopSound2#radius"), 50);
		self.HonkV2Sound2InnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.HonkLoopSound2#innerRadius"), 10);
		self.clientHonkV2Sound2 = createAudioSource("clientHonkV2Sound2", clientHonkV2Sound2File, self.HonkV2Sound2Radius, self.HonkV2Sound2InnerRadius, self.HonkV2Sound2Volume, 0);
		link(self.components[1].node, self.clientHonkV2Sound2);
		setVisibility(self.clientHonkV2Sound2, false);
		self.HonkV2Playing2 = false;
	end;
end;

function HonkV2:delete()
	if self.HonkV2SoundId ~= nil then
		delete(self.HonkV2SoundId);
		self.HonkV2SoundId = nil;
	end;
	if self.HonkV2Sound2Id ~= nil then
		delete(self.HonkV2Sound2Id);
		self.HonkV2Sound2Id = nil;
	end;
end;

function HonkV2:readStream(streamId, connection)
end;

function HonkV2:writeStream(streamId, connection)
end;

function HonkV2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HonkV2:keyEvent(unicode, sym, modifier, isDown)
end;

function HonkV2:update(dt)
	if self.isEntered and self.isClient and self:getIsActiveForInput(false) then
		if self.HonkV2SoundId ~= nil then
			if InputBinding.hasEvent(InputBinding.HonkV2) then
				self:playHonkV2(not self.HonkV2Playing);
			end;
			if InputBinding.hasEvent(InputBinding.HonkV22) then
				self:playHonkV22(not self.HonkV2Playing2);
			end;
		end;
	end;
end;

function HonkV2:updateTick(dt)
end;

function HonkV2:draw()                            
end;

function HonkV2:onLeave()                            
end;

function HonkV2:onDetach()
	if self.HonkV2SoundId ~= nil then
		setVisibility(self.clientHonkV2Sound, false);
		stopSample(self.HonkV2SoundId);
	end;
	if self.HonkV2Sound2Id ~= nil then
		setVisibility(self.clientHonkV2Sound2, false);
		stopSample(self.HonkV2Sound2Id);
	end;
end;

function HonkV2:playHonkV2(isPlaying, noEventSend)
	if self.HonkV2SoundId ~= nil then
		HonkEvent.sendEvent(self, isPlaying, noEventSend);
		self.HonkV2Playing = isPlaying;
		if isPlaying then
			if self:getIsActive() then
				if self:getIsActiveForSound() then
					playSample(self.HonkV2SoundId, 0, self.HonkV2SoundVolume, 0);
				elseif self.isControlled then
					setVisibility(self.clientHonkV2Sound, true);
				end;
			end;
		else
			stopSample(self.HonkV2SoundId);
			setVisibility(self.clientHonkV2Sound, false);
		end;
	end;
end;

function HonkV2:playHonkV22(isPlaying, noEventSend)
	if self.HonkV2Sound2Id ~= nil then
		HonkEvent.sendEvent(self, isPlaying, noEventSend);
		self.HonkV2Playing2 = isPlaying;
		if isPlaying then
			if self:getIsActive() then
				if self:getIsActiveForSound() then
					playSample(self.HonkV2Sound2Id, 0, self.HonkV2Sound2Volume, 0);
				elseif self.isControlled then
					setVisibility(self.clientHonkV2Sound2, true);
				end;
			end;
		else
			stopSample(self.HonkV2Sound2Id);
			setVisibility(self.clientHonkV2Sound2, false);
		end;
	end;
end;
