--
-- add specialization to all mods.
--
--
-- @author:    	Xentro (Marcus@Xentro.se)
-- @website:	www.Xentro.se
-- @history:	v1.54 - 2015-01-18 - Added optimization improvements by Jakob Tischler
-- @history:	v1.53 - 2014-11-11 - Improvement
-- 				v1.52 - 2013-10-29 - 
--

local l10nName = "MANUAL_IGNITION"; -- looks for MANUAL_IGNITION_1 etc
local specName = "ManualIgnition";
local searchWords = {"ignition"};

local searchSpecializations = {
	-- prohibited
	[specName] = false,
	-- required
	["motorized"] = true,
	["steerable"] = true
};

-- prohibited vehicle types
local prohibitedVehicleTypes = {
	["waterTrailer"] = true,
	["cultivator_animated"] = true,
	["mower_animated"] = true,
	["baleLoader"] = true,
	["milktruck"] = true,
	["sprayer_mouseControlled"] = true,
	["baler"] = true,
	["dynamicMountAttacherImplement"] = true,
	["trailer"] = true,
	["plough"] = true,
	["sowingMachine_animated"] = true,
	["trafficVehicle"] = true,
	["implement_animated"] = true,
	["fuelTrailer"] = true,
	["attachableCombine"] = true,
	["defoliator_animated"] = true,
	["implement"] = true,
	["dynamicMountAttacherTrailer"] = true,
	["sprayer_animated"] = true,
	["windrower"] = true,
	["forageWagon"] = true,
	["mower"] = true,
	["manureBarrel"] = true,
	["sprayer"] = true,
	["shovel_animated"] = true,
	["manureSpreader"] = true,
	["cultivator"] = true,
	["cutter_animated"] = true,
	["cutter"] = true,
	["mixerWagon"] = true,
	["strawBlower"] = true,
	["sowingMachine"] = true,
	["tedder"] = true,
	["shovel"] = true
};

addSpecialization = {};
addSpecialization.isLoaded = true;
addSpecialization.g_currentModDirectory = g_currentModDirectory;

if SpecializationUtil.specializations[specName] == nil then
	SpecializationUtil.registerSpecialization(specName, specName, g_currentModDirectory .. specName .. ".lua")
	addSpecialization.newSpec = SpecializationUtil.getSpecialization(specName);
	addSpecialization.isLoaded = false;
end;

addModEventListener(addSpecialization);

function addSpecialization:loadMap(name)	
    if not g_currentMission.ManualIgnitionModIsLoaded then
		if not addSpecialization.isLoaded then
			addSpecialization:add();
			addSpecialization.isLoaded = true;
			-- self:removeModEventListener(addSpecialization);
		end;
		
		local x = 0.01;
		local y = 0.21;
		local width = 0.0371111;
		local height = 0.256;
		
		self.updateHudPos = false;
		self.position = {};
		
		self.position["mapVisual"] = {};
		self.position["mapVisual"].x = x;
		self.position["mapVisual"].y = y;
		
		self.position["original"] = {};
		self.position["original"].x = x;
		self.position["original"].y = -0.015;
		
		g_currentMission.ignitionSettings = {};
		g_currentMission.ignitionSettings["error_time_1"] = 1000;
		g_currentMission.ignitionSettings["error_time_2"] = 800;
		g_currentMission.ignitionSettings["axis_limit"] = 0.5;
		g_currentMission.ignitionSettings["engine_cooldown"] = 4;
		g_currentMission.ignitionSettings["engine_cooldown_rain"] = 2;
		g_currentMission.ignitionSettings["max_heat_time"] = 2;
		g_currentMission.ignitionSettings["pre_heat_start"] = false;
		g_currentMission.ignitionSettings["pre_heat_time"] = 1200;
		g_currentMission.ignitionSettings["show_hud_after_start_time"] = 3000;
		
		g_currentMission.ignitionOverlay = {};
		g_currentMission.ignitionOverlay[1] = Overlay:new("ignitionOverlay1", Utils.getFilename("bg.dds", addSpecialization.g_currentModDirectory .. "Huds/"), x, y, width, height);
		g_currentMission.ignitionOverlay[2] = Overlay:new("ignitionOverlay2", Utils.getFilename("step1.dds", addSpecialization.g_currentModDirectory .. "Huds/"), x, y, width, height);
		g_currentMission.ignitionOverlay[3] = Overlay:new("ignitionOverlay3", Utils.getFilename("step2.dds", addSpecialization.g_currentModDirectory .. "Huds/"), x, y, width, height);
		g_currentMission.ignitionOverlay[4] = Overlay:new("ignitionOverlay4", Utils.getFilename("step3.dds", addSpecialization.g_currentModDirectory .. "Huds/"), x, y, width, height);
		
		-- turn off other ignition mod
		if g_currentMission.driveControl ~= nil then
			g_currentMission.driveControl.useModules.manMotorStart = false;
		end;
		
		g_currentMission.ManualIgnitionModIsLoaded = true;
	else
		print(specName .. " - Error: The " .. specName .. " mod have been loaded already! remove one of the copy's");
	end;
end;

function addSpecialization:deleteMap()	
	for _, hud in ipairs(g_currentMission.ignitionOverlay) do
		hud:delete();
	end;
	
	g_currentMission.ignitionSettings = nil;
	g_currentMission.ignitionOverlay = nil;
	g_currentMission.ManualIgnitionModIsLoaded = nil;
end;

function addSpecialization:mouseEvent(posX, posY, isDown, isUp, button)
end;

function addSpecialization:keyEvent(unicode, sym, modifier, isDown)
end;

function addSpecialization:update(dt)
	if g_currentMission.ingameMap.mapOverlay ~= nil and self.position ~= nil then
		if self.updateHudPos ~= g_currentMission.ingameMap.isVisible then
			self.updateHudPos = g_currentMission.ingameMap.isVisible;
			local x, y = self.position["original"].x, self.position["original"].y;
			
			if self.updateHudPos then
				x, y = self.position["mapVisual"].x, self.position["mapVisual"].y;
			end;
			
			for _, v in ipairs(g_currentMission.ignitionOverlay) do
				v.x = x;
				v.y = y;
			end;
		end;
	end;
end;

function addSpecialization:draw()
end;

function addSpecialization:add()
	local neededNumSpecs = 0;
	local requiredSpecializations = {};
	local prohibitedSpecializations = {};

	for name, required in pairs(searchSpecializations) do
		local spec = SpecializationUtil.getSpecialization(name);
		
		if spec then
			if required then
				requiredSpecializations[spec] = name;
				neededNumSpecs = neededNumSpecs + 1;
			else
				prohibitedSpecializations[spec] = name;
			end;
		end;
	end;
	
	for k, vehicle in pairs(VehicleTypeUtil.vehicleTypes) do
		if not prohibitedVehicleTypes[k] then
			local hasRequiredNumSpecs = 0;
			local locationAllowed;
			
			for _, vs in ipairs(vehicle.specializations) do
				if prohibitedSpecializations[vs] then
					locationAllowed = prohibitedSpecializations[vs];
					break;
				elseif requiredSpecializations[vs] then
					hasRequiredNumSpecs = hasRequiredNumSpecs + 1;
				end;
			end;
			
			if locationAllowed == nil then
				if hasRequiredNumSpecs >= neededNumSpecs then
					local addSpec;
					local modName = Utils.splitString(".", k);
					local spec = {};
					
					for name in pairs(SpecializationUtil.specializations) do
						if name:find(modName[1]) ~= nil then
							local parts = Utils.splitString(".", name);
							
							if table.getn(parts) > 1 then
								table.insert(spec, parts);
							end;
						end;
					end;
					
					for _, s in ipairs(spec) do
						for _, search in ipairs(searchWords) do
							if s[2]:lower():find(search:lower()) ~= nil then
								addSpec = s[2];
								break;
							end;
						end;
						
						if addSpec ~= nil then
							break;
						end;
					end;
					
					if addSpec == nil then
						table.insert(vehicle.specializations, addSpecialization.newSpec);
						-- print(specName .. ": Inserted on " .. k);
					else
						print(specName .. ": Failed inserting on " .. k .. " as it has the specialization (" .. addSpec .. ")");
					end;
				end;
			else
				print(specName .. ": Failed inserting on " .. k .. " as it has the specialization (" .. locationAllowed .. ")");
			end;
		end;
	end;
	
	-- make l10n global 
	local i = 1;
	while true do
		local txt = string.format(l10nName .. "_%d", i);
		if not g_i18n:hasText(txt) then
			break;
		end;
		g_i18n.globalI18N.texts[txt] = g_i18n:getText(txt);
		
		i = i + 1;
	end;
end;

function addSpecialization:removeModEventListener(listenerToRemove)
	local index;
	for i,listener in ipairs(g_modEventListeners) do
		if listener == listenerToRemove then
			break;
		end;
	end;
	if index then
		g_modEventListeners[index] = nil;
	end;
end;