--
-- ahwiFM700
-- special functions for Ahwi FM700 V2.
--
-- author: Patar
-- date: 03.01.15
--

ahwiFM700 = {};

function ahwiFM700.prerequisitesPresent(specializations)
    return true;
end;

function ahwiFM700:load(xmlFile)

-- StumpColliMovement (SCM)
	self.SCM = {};
	self.SCM.valueY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.stumpColli#valueY"), 1);
	self.SCM.valueZ = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.stumpColli#valueZ"), -1);
	self.SCM.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.stumpColli#index"))
	self.maxCutTime = 250;
-- StumpColliMovement (SCM)

-- DustParticles (DP)
	self.DP = {PS={}, free=false, isPloughing=false};
	Utils.loadParticleSystem(xmlFile, self.DP.PS, "vehicle.stumpCutter.dustParticleSystem", self.components, false, nil, self.baseDirectory)
-- DustParticles (DP)


-- MouseControlLimit (MCL)
	self.MCL = {};
	self.MCL.backupBig = {
							rotMax = self.movingTools[2].rotMax;
							rotMin = self.movingTools[2].rotMin;
							};
	self.MCL.backupSmall = {
							rotMax = self.movingTools[1].rotMax;
							rotMin = self.movingTools[1].rotMin;
							};
-- MouseControlLimit (MCL)

--[[ WoodChipsCreator (WCC)
	self.WCC = {
				upspeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.woodChipsCreator#upspeed"), 0),
				downspeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.woodChipsCreator#downspeed"), 0),
				node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.woodChipsCreator#node")),
				xMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.woodChipsCreator#xMax"), 0.3),
				};
-- WoodChipsCreator (WCC) ]]

end;

function ahwiFM700:delete()
end;

function ahwiFM700:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ahwiFM700:keyEvent(unicode, sym, modifier, isDown)
end;

function ahwiFM700:update(dt)



end;

function ahwiFM700:updateTick(dt)

-- StumpColliMovement (SCM)
	if not self.stumpCutterParticleSystems.isEmitting then
		setTranslation(self.SCM.index, 0, self.SCM.valueY, 0);
	else
		local actZ = (0.1-self.nextCutTime/self.maxCutTime)*self.SCM.valueZ;
		setTranslation(self.SCM.index, 0, 0, actZ);
	end;
-- StumpColliMovement (SCM)

-- DirtParticles (DP)
	if self.stumpCutterParticleSystems.isEmitting then
		self.DP.free = true;
	end;
	Utils.setEmittingState(self.DP.PS, (self.resetCutTime > 0 and self.DP.free and self:getIsTurnedOn()) or (self.hasWheelGroundContact and self:getIsTurnedOn()));
-- DirtParticles (DP)



-- MouseControlLimit (MCL)
	if self.movingTools[2].curRot[1] > 0.619 then
		self.movingTools[1].rotMin = self.movingTools[1].rotMax-0.005;
	else
		self.movingTools[1].rotMin = self.MCL.backupSmall.rotMin;
	end;
	if self.movingTools[1].curRot[1] < self.MCL.backupSmall.rotMax-0.01 then
		self.movingTools[2].rotMax = 0.619;
	else
		self.movingTools[2].rotMax = self.MCL.backupBig.rotMax;
	end;
-- MouseControlLimit (MCL)

--[[WoodChipsCreator (WCC)
	if self.stumpCutterParticleSystems.isEmitting then
		local x,_,_ = getTranslation
-- WoodChipsCreator (WCC) ]]

end;

function ahwiFM700:draw()


-- MouseControlLimit (MCL)
	if (InputBinding.getInputAxis(InputBinding.AXIS_FRONTLOADER_ARM) < 0 or InputBinding.getIsInputMouseAxisTriggered(InputBinding.AXIS_FRONTLOADER_ARM)) and self.movingTools[2].curRot[1] == 0.619 then
		setTextColor(1,0.1,0.1,1); setTextBold(true);
		renderText(0.25, 0.92, 0.03, g_i18n:getText("MCL_pleaseLower"))
		setTextColor(1,1,1,1); setTextBold(false);
	end;
-- MouseControlLimit (MCL)
	--renderText(0.1, 0.5, 0.02, "InputBinding[axis] = "..tostring(InputBinding.AXIS_FRONTLOADER_ARM))
	--renderText(0.1, 0.48, 0.02, "isAxisZero = "..tostring(InputBinding.getInputAxis(InputBinding.AXIS_FRONTLOADER_ARM)))
	--renderText(0.1, 0.46, 0.02, "InputBinding.actions[actionIndex].mouseAxis = "..tostring(InputBinding.actions[InputBinding.AXIS_FRONTLOADER_ARM].mouseAxis))
	--renderText(0.1, 0.44, 0.02, "lastPloughArea = "..tostring(self.lastPloughArea))
	--renderText(0.1, 0.42, 0.02, "isPloughLowered = "..tostring(self.isPloughLowered))
	--renderText(0.1, 0.40, 0.02, "nextCutTime = "..tostring(self.nextCutTime))
end;

function ahwiFM700:onEnter()
end;