SpecializationUtil.registerSpecialization("SaveCam", "SaveCam", g_currentModDirectory.."SaveCam.lua")

MMRearCam_Register = {};

function MMRearCam_Register:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		
		--print("--- loading SaveCam - specialization for SaveCam");
		
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("steerable") then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							if rawget(SpecializationUtil.specializations, string.format("%s.SaveCam", _name)) ~= nil then
								allowInsertion = false;
								-- print(tostring(v.name)..": Specialization SaveCam is present! SaveCam was not inserted!");
							end;							
						end;
						if allowInsertion then
							-- print("adding SaveCam to:"..tostring(v.name));
							table.insert(v.specializations, SpecializationUtil.getSpecialization("SaveCam"));
						end;						
						
					end;
				end;
			end;	
		end;
	end;
end;

function MMRearCam_Register:deleteMap()
  
end;

function MMRearCam_Register:keyEvent(unicode, sym, modifier, isDown)

end;

function MMRearCam_Register:mouseEvent(posX, posY, isDown, isUp, button)

end;

function MMRearCam_Register:update(dt)
	
end;

function MMRearCam_Register:draw()
  
end;

addModEventListener(MMRearCam_Register);