-- LUA fr realistisches Standlicht/Fernlicht
-- Script for realistic Light Functions
-- by modelleicher
-- http://schwabenmodding.bplaced.net

oldtimerLights = {};

function oldtimerLights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function oldtimerLights:load(xmlFile)

	self.switchLights = oldtimerLights.switchLights;

	self.standlicht = {};
	self.fernlicht = {};
	
	self.standlicht.licht = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.oldtimerLights.standlicht#lichtIndex"));
	self.standlicht.coronas = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.oldtimerLights.standlicht#coronasIndex"));
	self.standlicht.beams = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.oldtimerLights.standlicht#beamsIndex"));
	self.standlicht.hasOn = false;
	
	self.fernlicht.licht = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.oldtimerLights.fernlicht#lichtIndex"));
	self.fernlicht.coronas = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.oldtimerLights.fernlicht#coronasIndex"));
	self.fernlicht.beams = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.oldtimerLights.fernlicht#beamsIndex"));
	self.fernlicht.armaturLicht = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.oldtimerLights.fernlicht#armaturCoronaIndex"));
	self.fernlicht.hasOn = false;
	
	
	self.actualLight = 0;  -- 0 = aus, 1 = standlicht, 2 = fernlicht
	self.lightsActive = false	
	
	self:switchLights(0);
	self.vehicleIsSelfControlled = false;
	self.vehicleIsOtherControlled = false;
end;
function oldtimerLights:readStream(streamId, connection)  
     self:switchLights(streamReadInt32(streamId), true);  
end;
function oldtimerLights:writeStream(streamId, connection) 
    streamWriteInt32(streamId, self.actualLight);   
end;
function oldtimerLights:delete()
end;
function oldtimerLights:mouseEvent(posX, posY, isDown, isUp, button)
end;
function oldtimerLights:keyEvent(unicode, sym, modifier, isDown)
end;
function oldtimerLights:onLeave()
	self:switchLights(0);
end;
function oldtimerLights:switchLights(actualState, noEventSend)
    oldtimerLightsEvent.sendEvent(self, actualState, noEventSend);		
	self.actualLight = actualState;

	
	if self.actualLight == 0 then
		self.standlicht.hasOn = false;
		self.fernlicht.hasOn = false;
		self:setLightsVisibility(false, true);			
	elseif self.actualLight == 1 then
		self.standlicht.hasOn = true;
		self.fernlicht.hasOn = false;
		self:setLightsVisibility(true, true);			
	elseif self.actualLight == 2 then
		self.standlicht.hasOn = false;
		self.fernlicht.hasOn = true;
		self:setLightsVisibility(true, true);			
	end;
	
	if self.standlicht.hasOn == false and self.fernlicht.hasOn == false then
		setVisibility(self.standlicht.licht, false);
		setVisibility(self.standlicht.coronas, false);
		setVisibility(self.standlicht.beams, false);
		setVisibility(self.fernlicht.licht, false);
		setVisibility(self.fernlicht.coronas, false);
			if self.fernlicht.armaturLicht ~= nil then
				setVisibility(self.fernlicht.armaturLicht, false);	
			end;		
		setVisibility(self.fernlicht.beams, false)	
	end;
	
	if self.vehicleIsOtherControlled then
		if self.standlicht.hasOn == true then
			setVisibility(self.standlicht.licht, false);
			setVisibility(self.standlicht.coronas, true);
			setVisibility(self.standlicht.beams, true);
		elseif self.fernlicht.hasOn == true then
			setVisibility(self.standlicht.licht, false);
			setVisibility(self.standlicht.coronas, true);
			setVisibility(self.standlicht.beams, true);
			setVisibility(self.fernlicht.licht, false);
			setVisibility(self.fernlicht.coronas, true);
			if self.fernlicht.armaturLicht ~= nil then
				setVisibility(self.fernlicht.armaturLicht, true);	
			end;
			setVisibility(self.fernlicht.beams, true)
		end;
	elseif self.vehicleIsSelfControlled then
		if self.standlicht.hasOn == true then
			setVisibility(self.standlicht.licht, true);
			setVisibility(self.standlicht.coronas, true);
			setVisibility(self.standlicht.beams, false);
		elseif self.fernlicht.hasOn == true then
			setVisibility(self.standlicht.licht, false);
			setVisibility(self.standlicht.coronas, true);
			setVisibility(self.standlicht.beams, false);
			setVisibility(self.fernlicht.licht, true);
			setVisibility(self.fernlicht.coronas, true);
			if self.fernlicht.armaturLicht ~= nil then
				setVisibility(self.fernlicht.armaturLicht, true);	
			end;			
			setVisibility(self.fernlicht.beams, false)
		end;	
	end;
end;
function oldtimerLights:update(dt)
	if self:getIsActive() then
			-- stellt fest, ob man selbst im Fahrzeug sitzt oder nicht (Ntig frn MP und den Helfer)
			if not self:getIsActiveForInput() then
				self.vehicleIsOtherControlled = true;
				self.vehicleIsSelfControlled = false;
			elseif self:getIsActiveForInput() then
				self.vehicleIsOtherControlled = false;
				self.vehicleIsSelfControlled = true;		
			end;
		if self:getIsActiveForInput() then	
			if InputBinding.hasEvent(InputBinding.TOGGLE_LIGHTS) then
				if self.actualLight < 2 then
					self:switchLights(self.actualLight +1);
				elseif self.actualLight == 2 then
					self:switchLights(0);
				end;	
			end;
		end;
		if self.isHired then
			setVisibility(self.standlicht.licht, false);
			setVisibility(self.standlicht.coronas, not g_currentMission.environment.isSunOn);
			setVisibility(self.standlicht.beams, not g_currentMission.environment.isSunOn);
			setVisibility(self.fernlicht.licht, false);
			setVisibility(self.fernlicht.coronas, not g_currentMission.environment.isSunOn);
			if self.fernlicht.armaturLicht ~= nil then
				setVisibility(self.fernlicht.armaturLicht, not g_currentMission.environment.isSunOn);	
			end;			
			setVisibility(self.fernlicht.beams, not g_currentMission.environment.isSunOn)
		end;
	end;
end;

function oldtimerLights:updateTick(dt)
end;
function oldtimerLights:draw()
end;


oldtimerLightsEvent = {};
oldtimerLightsEvent_mt = Class(oldtimerLightsEvent, Event);
InitEventClass(oldtimerLightsEvent, "oldtimerLightsEvent");
function oldtimerLightsEvent:emptyNew() 
    local self = Event:new(oldtimerLightsEvent_mt );
    self.className="oldtimerLightsEvent";
    return self;
end;
function oldtimerLightsEvent:new(vehicle, actualLightState) 
    self.vehicle = vehicle;
    self.actualLight = actualLightState;
    return self;
end;

function oldtimerLightsEvent:readStream(streamId, connection) 
    local id = streamReadInt32(streamId); 
    self.actualLight = streamReadInt32(streamId); 
    self.vehicle = networkGetObject(id);
    self:run(connection); 
end;

function oldtimerLightsEvent:writeStream(streamId, connection)  
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteInt32(streamId, self.actualLight );  
end;

function oldtimerLightsEvent:run(connection) 
    self.vehicle:switchLights(self.actualLight, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(oldtimerLightsEvent:new(self.vehicle, self.actualLight), nil, connection, self.object);
	end;
end;

function oldtimerLightsEvent.sendEvent(vehicle, actualLightState, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(oldtimerLightsEvent:new(vehicle, actualLightState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(oldtimerLightsEvent:new(vehicle, actualLightState));
		end;
	end;
end;

