--
-- PullPurely
-- Specialization for pull purely
--
-- @author  Stefan Maurus	
-- @date  2014-11-28
--
-- Copyright © Stefan Maurus, www.stefanmaurus.de
--

PullPurely = {};

function PullPurely.prerequisitesPresent(specializations)
    return true;
end;

function PullPurely:load(xmlFile)
	self.updateDeep = SpecializationUtil.callSpecializationsFunction("updateDeep");
	
    self.jointIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PullPurely#jointIndex"));
    self.movingToolLMK = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.PullPurely#movingTool"), 1);
	self.speedFactorOut = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PullPurely#speedFactorOut"), 0.001);
	self.speedFactorIn = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PullPurely#speedFactorIn"), 65);
	self.XOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PullPurely#XOffset"), 0);
	self.ZOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PullPurely#ZOffset"), 0);

	self.maxUpTrans = getXMLFloat(xmlFile, "vehicle.PullPurely#maxUpTrans");
	self.maxDownTrans = getXMLFloat(xmlFile, "vehicle.PullPurely#maxDownTrans");

	self.getLastMovement = PullPurely.getLastMovement;	
	self.cultiLastPosition = {nil, nil};
end;

function PullPurely:delete()
end;

function PullPurely:readStream(streamId, connection)
end;

function PullPurely:writeStream(streamId, connection) 
end;

function PullPurely:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PullPurely:keyEvent(unicode, sym, modifier, isDown)
end;

function PullPurely:update(dt)
	if self:getIsActive() then
		if self.isClient then
			if (self.cultivatorHasGroundContact and self.isChanged and self.movingDirection < 0) or (self.cultivatorHasGroundContact and not self.isChanged and self.movingDirection > 0) then
				local values = self:getLastMovement(self.components[1].node, self.cultiLastPosition[1], self.cultiLastPosition[2]);	
				self.cultiLastPosition = {values[2], values[3]};			
				self:updateDeep(self.jointIndex, self.movingToolLMK, self.XOffset, self.maxDownTrans, self.ZOffset, self.speedFactorIn*values[1]);
			elseif not self.cultivatorHasGroundContact then
				self.cultiLastPosition = {nil, nil};
				self:updateDeep(self.jointIndex, self.movingToolLMK, self.XOffset, self.maxUpTrans, self.ZOffset, self.speedFactorOut);
			end;
		end;
	end;
end;

function PullPurely:getLastMovement(node, lastX, lastZ)
	local newX, _, newZ = getWorldTranslation(node);
	if lastX == nil or lastZ == nil then
		return {0, newX, newZ};
	end;
	local distance = Utils.vector2Length(math.abs(newX-lastX), math.abs(newZ-lastZ));	
	return {distance, newX, newZ};
end;

function PullPurely:updateDeep(jointIndex, movingTool, targetX, targetY, targetZ, factor)
	local coordinatesCur = {getTranslation(jointIndex)};
	local coordinatesTar = {targetX, targetY, targetZ};
	local coordinatesNew = coordinatesCur;
	local update = false;
	for i=1, 3, 1 do
		if coordinatesCur[i] ~= coordinatesTar[i] then
			update = true;
			if coordinatesCur[i] > coordinatesTar[i] then
				coordinatesNew[i] = math.max(coordinatesCur[i]-factor,coordinatesTar[i]);
			else
				coordinatesNew[i] = math.min(coordinatesCur[i]+factor, coordinatesTar[i]);			
			end;
		end;
	end;
	if not update then
		return;
	end;
	setTranslation(jointIndex, coordinatesNew[1], coordinatesNew[2], coordinatesNew[3])
	if self.isServer then
		Cylindered.updateComponentJoints(self, self.movingTools[movingTool+1], false);
	end;
end;

function PullPurely:updateTick(dt)
end;

function PullPurely:draw()
end;

function PullPurely:onAttach()
end;

function PullPurely:onDetach()	
end; 