--
-- BackPTO
-- Specialization for PTO from implement to an attached implement
--
-- @author  	Stefan Maurus
-- @version 	v1.0
-- @date  		14.06.2014
--
-- Based on attachablePTO Script from JoXXer (http://www.bjr-modding.com/)
--

BackPTO = {};

function BackPTO.prerequisitesPresent(specializations)
    return true;
end;

function BackPTO:load(xmlFile)
	self.toggleBackPTOAttach = SpecializationUtil.callSpecializationsFunction("toggleBackPTOAttach");
	
	self.backPTO = {};
	
    self.backPTO.visIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backPTO#visIndex"));
	setVisibility(self.backPTO.visIndex,false);
	
    self.backPTO.tractorFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backPTO#tractorFixPoint"));
	self.backPTO.tractorFixPointTrans = {getTranslation(self.backPTO.tractorFixPoint)};
	self.backPTO.tractorFixPointRot = {getRotation(self.backPTO.tractorFixPoint)};
	
    self.backPTO.shaft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backPTO#shaftIndex"));
    self.backPTO.shaftRot = {getRotation(self.backPTO.shaft)};
	
    self.backPTO.referenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backPTO#referenceNode"));
    self.backPTO.movingPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backPTO#movingPart"));
	self.backPTO.movingPartTrans = {getTranslation(self.backPTO.movingPart)};
	
    self.backPTO.distanceModifier = getXMLFloat(xmlFile, "vehicle.backPTO#distanceModifier");
	
	self.backPTO.tractorPTONode = nil;
	self.backPTO.jointDescIndex = nil;
	self.backPTO.attached = false;
end;

function BackPTO:delete()
end;

function BackPTO:readStream(streamId, connection)
end;

function BackPTO:writeStream(streamId, connection)
end;

function BackPTO:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BackPTO:keyEvent(unicode, sym, modifier, isDown)
end;

function BackPTO:update(dt)
	if self.backPTO.tractorPTONode then
		if self.backPTO.attached then
			local ptoAttX, ptoAttY, ptoAttZ = getWorldTranslation(self.backPTO.tractorPTONode);
			setTranslation(self.backPTO.tractorFixPoint, 0, 0, 0);
			local localXTrans, localYTrans, localZTrans = worldToLocal(self.backPTO.tractorFixPoint, ptoAttX, ptoAttY, ptoAttZ);
			setTranslation(self.backPTO.tractorFixPoint, localXTrans, localYTrans, localZTrans+self.backPTO.distanceModifier);
			
			setDirection(self.backPTO.shaft, localXTrans, localYTrans, localZTrans, 0, 1, 0);
			local _,_,dist = worldToLocal(self.backPTO.referenceNode, ptoAttX, ptoAttY, ptoAttZ);
			local movPartX, movePartY, movPartZ = unpack(self.backPTO.movingPartTrans);
			setTranslation(self.backPTO.movingPart, movPartX, movePartY, movPartZ+dist+self.backPTO.distanceModifier);
		end;
	end;
end;

function BackPTO:updateTick(dt)
	for _, implement in pairs(self.attachedImplements) do
        if implement.object ~= nil then
            if implement.object.ptoInput ~= nil then
				self:toggleBackPTOAttach(true);
			else
				self:toggleBackPTOAttach(false);
			end;
		else
			self:toggleBackPTOAttach(false);
		end;
	end;	
end;

function BackPTO:draw()
end;

function BackPTO:detachImplement(implement, implementIndex)
	self:toggleBackPTOAttach(false);
	self.backPTO.tractorPTONode = nil;
	self.backPTO.jointDescIndex = nil;	
end;

function BackPTO:attachImplement(implement, implementIndex, object, jointDescIndex)
	local attachedJoint = implement.object;
	if attachedJoint.ptoInput ~= nil then
		if attachedJoint.ptoInput.node ~= nil then
			self.backPTO.tractorPTONode = attachedJoint.ptoInput.node;
			self.backPTO.jointDescIndex = jointDescIndex;
		end;
	end;
end;

function BackPTO:onDetach()
end;

function BackPTO:onSetLowered(moveDown)
end;

function BackPTO:toggleBackPTOAttach(attached)
	self.backPTO.attached = attached;
	if self.backPTO.tractorPTONode then
		if self.backPTO.attached then
			setRotation(self.backPTO.tractorFixPoint, 0, 0, 0);
			setVisibility(self.backPTO.visIndex, true);			
		else
			setVisibility(self.backPTO.visIndex, false);
			setTranslation(self.backPTO.tractorFixPoint, unpack(self.backPTO.tractorFixPointTrans));
			setRotation(self.backPTO.tractorFixPoint, unpack(self.backPTO.tractorFixPointRot));
			setTranslation(self.backPTO.movingPart, unpack(self.backPTO.movingPartTrans));
			setRotation(self.backPTO.shaft, unpack(self.backPTO.shaftRot));
		end;
	end;
end;